/*
 * Decompiled with CFR 0.152.
 */
package land.oras;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import land.oras.OrasModel;
import land.oras.utils.JsonUtils;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@OrasModel
public record Annotations(Map<String, String> configAnnotations, Map<String, String> manifestAnnotations, Map<String, Map<String, String>> filesAnnotations) {
    public static Annotations ofManifest(@Nullable Map<String, String> manifestAnnotations) {
        if (manifestAnnotations == null) {
            return Annotations.empty();
        }
        return new Annotations(new HashMap<String, String>(), manifestAnnotations, new HashMap<String, Map<String, String>>());
    }

    public static Annotations ofConfig(Map<String, String> configAnnotations) {
        return new Annotations(configAnnotations, new HashMap<String, String>(), new HashMap<String, Map<String, String>>());
    }

    public static Annotations empty() {
        return new Annotations(new HashMap<String, String>(), new HashMap<String, String>(), new HashMap<String, Map<String, String>>());
    }

    public Map<String, String> getFileAnnotations(String key) {
        return this.filesAnnotations().getOrDefault(key, new HashMap());
    }

    public static Annotations fromJson(String json) {
        AnnotationFile file = JsonUtils.fromJson(json, AnnotationFile.class);
        return new Annotations(file.getConfigAnnotations(), file.getManifestAnnotations(), file.getFilesAnnotations());
    }

    public String toJson() {
        AnnotationFile file = new AnnotationFile();
        file.put("$manifest", this.manifestAnnotations());
        file.put("$config", this.configAnnotations());
        file.putAll(this.filesAnnotations());
        return JsonUtils.toJson(file);
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    private static class AnnotationFile
    extends HashMap<String, Map<String, String>> {
        private AnnotationFile() {
        }

        public Map<String, String> getManifestAnnotations() {
            return this.getOrDefault("$manifest", new HashMap());
        }

        public Map<String, String> getConfigAnnotations() {
            return this.getOrDefault("$config", new HashMap());
        }

        public Map<String, Map<String, String>> getFilesAnnotations() {
            return this.entrySet().stream().filter(entry -> !"$manifest".equals(entry.getKey()) && !"$config".equals(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }
}

