/*
 * Decompiled with CFR 0.152.
 */
package land.oras.auth;

import land.oras.ContainerRef;
import land.oras.auth.AuthProvider;
import land.oras.auth.AuthScheme;
import land.oras.auth.AuthStore;
import land.oras.auth.UsernamePasswordProvider;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class AuthStoreAuthenticationProvider
implements AuthProvider {
    private final AuthStore authStore;

    public AuthStoreAuthenticationProvider() {
        this(AuthStore.newStore());
    }

    public AuthStoreAuthenticationProvider(AuthStore authStore) {
        this.authStore = authStore;
    }

    @Override
    public @Nullable String getAuthHeader(ContainerRef registry) {
        AuthStore.Credential credential = this.authStore.get(registry);
        if (credential == null) {
            return null;
        }
        return new UsernamePasswordProvider(credential.username(), credential.password()).getAuthHeader(registry);
    }

    @Override
    public AuthScheme getAuthScheme() {
        return AuthScheme.BASIC;
    }
}

