/*
 * Decompiled with CFR 0.152.
 */
package land.oras.auth;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import land.oras.ContainerRef;
import land.oras.exception.OrasException;
import land.oras.utils.JsonUtils;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class AuthStore {
    private static final Logger LOG = LoggerFactory.getLogger(AuthStore.class);
    private final Config config;

    AuthStore(Config config) {
        this.config = Objects.requireNonNull(config, "Config cannot be null");
    }

    public static AuthStore newStore(List<Path> configPaths) {
        ArrayList<ConfigFile> files = new ArrayList<ConfigFile>();
        for (Path configPath : configPaths) {
            if (!Files.exists(configPath, new LinkOption[0])) continue;
            ConfigFile configFile = JsonUtils.fromJson(configPath, ConfigFile.class);
            LOG.debug("Loaded auth config file: {}", (Object)configPath);
            files.add(configFile);
        }
        return new AuthStore(Config.load(files));
    }

    public static AuthStore newStore() {
        Path dockerPath = Path.of(System.getProperty("user.home"), ".docker", "config.json");
        List<Path> paths = List.of(dockerPath, System.getenv("XDG_RUNTIME_DIR") != null ? Path.of(System.getenv("XDG_RUNTIME_DIR"), "containers", "auth.json") : dockerPath);
        return AuthStore.newStore(paths);
    }

    public @Nullable Credential get(ContainerRef containerRef) throws OrasException {
        return this.config.getCredential(containerRef);
    }

    static class Config {
        private final ConcurrentHashMap<String, Credential> credentialStore = new ConcurrentHashMap();

        private Config() {
        }

        public static Config load(List<ConfigFile> configFiles) throws OrasException {
            Config config = new Config();
            for (ConfigFile configFile : configFiles) {
                configFile.auths.forEach((host, value) -> {
                    String auth = (String)value.get("auth");
                    if (auth != null) {
                        String base64Decoded = new String(Base64.getDecoder().decode(auth));
                        String[] parts = base64Decoded.split(":");
                        if (parts.length != 2) {
                            throw new OrasException("Invalid credential format");
                        }
                        config.credentialStore.put((String)host, new Credential(parts[0], parts[1]));
                    }
                });
            }
            return config;
        }

        public @Nullable Credential getCredential(ContainerRef containerRef) throws OrasException {
            return this.credentialStore.getOrDefault(containerRef.getRegistry(), null);
        }
    }

    record ConfigFile(Map<String, Map<String, String>> auths) {
        static ConfigFile fromCredential(Credential credential) {
            return new ConfigFile(Map.of("auths", Map.of("auth", Base64.getEncoder().encodeToString((credential.username + ":" + credential.password).getBytes()))));
        }
    }

    public record Credential(String username, String password) {
        public Credential(String username, String password) {
            this.username = Objects.requireNonNull(username, "Username cannot be null");
            this.password = Objects.requireNonNull(password, "Password cannot be null");
        }
    }
}

