/*
 * Decompiled with CFR 0.152.
 */
package land.oras;

import java.util.Objects;
import land.oras.OrasModel;
import land.oras.utils.JsonUtils;
import org.jspecify.annotations.NullMarked;

@NullMarked
@OrasModel
public final class Subject {
    private final String mediaType;
    private final String digest;
    private final long size;

    private Subject(String mediaType, String digest, long size) {
        this.mediaType = mediaType;
        this.digest = digest;
        this.size = size;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getDigest() {
        return this.digest;
    }

    public long getSize() {
        return this.size;
    }

    public String toJson() {
        return JsonUtils.toJson(this);
    }

    public static Subject of(String mediaType, String digest, long size) {
        return new Subject(mediaType, digest, size);
    }

    public static Subject fromJson(String json) {
        return JsonUtils.fromJson(json, Subject.class);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subject subject = (Subject)o;
        return Objects.equals(this.toJson(), subject.toJson());
    }

    public int hashCode() {
        return Objects.hash(this.toJson());
    }

    public String toString() {
        return this.toJson();
    }
}

