/*
 * Decompiled with CFR 0.152.
 */
package land.oras;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import land.oras.Annotations;
import land.oras.ArtifactType;
import land.oras.Config;
import land.oras.Describable;
import land.oras.Descriptor;
import land.oras.Layer;
import land.oras.ManifestDescriptor;
import land.oras.OrasModel;
import land.oras.Subject;
import land.oras.utils.JsonUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

@NullUnmarked
@OrasModel
public final class Manifest
extends Descriptor
implements Describable {
    private final int schemaVersion;
    private final Config config;
    private final Subject subject;
    private final List<Layer> layers;
    private final transient ManifestDescriptor descriptor;

    private Manifest(int schemaVersion, String mediaType, ArtifactType artifactType, ManifestDescriptor descriptor, Config config, Subject subject, List<Layer> layers, Annotations annotations, String json) {
        super(null, null, mediaType, Map.copyOf(annotations.manifestAnnotations()), artifactType != null ? artifactType.getMediaType() : null, json);
        this.schemaVersion = schemaVersion;
        this.descriptor = descriptor;
        this.config = config;
        this.subject = subject;
        this.layers = layers;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public @NonNull ArtifactType getArtifactType() {
        if (this.artifactType != null) {
            return ArtifactType.from(this.artifactType);
        }
        if (this.config != null) {
            return ArtifactType.from(this.config.getMediaType() != null ? this.config.getMediaType() : "application/vnd.unknown.artifact.v1");
        }
        return ArtifactType.unknown();
    }

    @Override
    public ManifestDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getDigest() {
        if (this.descriptor == null) {
            return super.getDigest();
        }
        return this.descriptor.getDigest();
    }

    public Config getConfig() {
        return this.config;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    public List<Layer> getLayers() {
        return this.layers != null ? Collections.unmodifiableList(this.layers) : List.of();
    }

    public Manifest withArtifactType(ArtifactType artifactType) {
        return new Manifest(this.schemaVersion, this.mediaType, artifactType, this.descriptor, this.config, this.subject, this.layers, Annotations.ofManifest(this.annotations), this.json);
    }

    public Manifest withLayers(List<Layer> layers) {
        return new Manifest(this.schemaVersion, this.mediaType, this.getTopLevelArtifactType(), this.descriptor, this.config, this.subject, layers, Annotations.ofManifest(this.annotations), this.json);
    }

    public Manifest withConfig(Config config) {
        return new Manifest(this.schemaVersion, this.mediaType, this.getTopLevelArtifactType(), this.descriptor, config, this.subject, this.layers, Annotations.ofManifest(this.annotations), this.json);
    }

    public Manifest withSubject(Subject subject) {
        return new Manifest(this.schemaVersion, this.mediaType, this.getTopLevelArtifactType(), this.descriptor, this.config, subject, this.layers, Annotations.ofManifest(this.annotations), this.json);
    }

    public Manifest withAnnotations(Map<String, String> annotations) {
        return new Manifest(this.schemaVersion, this.mediaType, this.getTopLevelArtifactType(), this.descriptor, this.config, this.subject, this.layers, Annotations.ofManifest(annotations), this.json);
    }

    public Manifest withDescriptor(ManifestDescriptor descriptor) {
        return new Manifest(this.schemaVersion, this.mediaType, this.getTopLevelArtifactType(), descriptor, this.config, this.subject, this.layers, Annotations.ofManifest(this.annotations), this.json);
    }

    @Override
    protected Manifest withJson(String json) {
        this.json = json;
        return this;
    }

    public static Manifest fromJson(String json) {
        return JsonUtils.fromJson(json, Manifest.class).withJson(json);
    }

    public static Manifest fromPath(Path path) {
        return Manifest.fromJson(JsonUtils.readFile(path));
    }

    private @Nullable ArtifactType getTopLevelArtifactType() {
        if (this.artifactType != null) {
            return ArtifactType.from(this.artifactType);
        }
        return null;
    }

    public static Manifest empty() {
        ManifestDescriptor descriptor = ManifestDescriptor.of("application/vnd.oci.empty.v1+json", "sha256:44136fa355b3678a1146ad16f7e8649e94fb4fc21fe77e8310c060f61caaff8a", 2L);
        return new Manifest(2, "application/vnd.oci.image.manifest.v1+json", null, descriptor, Config.empty(), null, List.of(), Annotations.empty(), null);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Manifest manifest = (Manifest)o;
        return Objects.equals(this.toJson(), manifest.toJson());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.toJson());
    }

    @Override
    public String toString() {
        return this.toJson();
    }
}

