/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.servlet;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.User;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.jenkins.plugins.opentelemetry.api.ReconfigurableOpenTelemetry;
import io.jenkins.plugins.opentelemetry.semconv.ConfigurationKey;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerMetrics;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.semconv.ClientAttributes;
import io.opentelemetry.semconv.ErrorAttributes;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import io.opentelemetry.semconv.UserAgentAttributes;
import io.opentelemetry.semconv.incubating.ThreadIncubatingAttributes;
import io.opentelemetry.semconv.incubating.UserIncubatingAttributes;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;

@Extension
public class StaplerInstrumentationServletFilter
implements Filter,
OpenTelemetryLifecycleListener {
    private static final Logger logger = Logger.getLogger(StaplerInstrumentationServletFilter.class.getName());
    final AtomicBoolean enabled = new AtomicBoolean(false);
    List<String> capturedRequestParameters;
    Tracer tracer;
    Meter meter;
    OperationListener httpServerMetrics;

    @PostConstruct
    public void postConstruct() {
        this.httpServerMetrics = HttpServerMetrics.get().create(this.meter);
    }

    public void afterConfiguration(ConfigProperties configProperties) {
        this.enabled.set(configProperties.getBoolean(ConfigurationKey.OTEL_INSTRUMENTATION_JENKINS_WEB_ENABLED.asProperty(), true));
        logger.log(Level.FINE, () -> "Jenkins Web instrumentation enabled: " + this.enabled.get() + ". To change config, use the property " + ConfigurationKey.OTEL_INSTRUMENTATION_JENKINS_WEB_ENABLED.asProperty() + ".");
        this.capturedRequestParameters = configProperties.getList(ConfigurationKey.OTEL_INSTRUMENTATION_SERVLET_CAPTURE_REQUEST_PARAMETERS.asProperty(), Collections.emptyList());
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.enabled.get() && servletRequest instanceof HttpServletRequest) {
            this._doFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _doFilter(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        AttributesBuilder httpServerMetricOnStartAttributesBuilder = Attributes.builder().put(HttpAttributes.HTTP_REQUEST_METHOD, (Object)servletRequest.getMethod()).put(UrlAttributes.URL_SCHEME, (Object)servletRequest.getScheme()).put(ServerAttributes.SERVER_ADDRESS, (Object)servletRequest.getServerName()).put(ServerAttributes.SERVER_PORT, (Object)servletRequest.getServerPort());
        Thread currentThread = Thread.currentThread();
        AttributesBuilder httpServerSpanAttributesBuilder = Attributes.builder().putAll(httpServerMetricOnStartAttributesBuilder.build()).put(ThreadIncubatingAttributes.THREAD_NAME, (Object)currentThread.getName()).put(ThreadIncubatingAttributes.THREAD_ID, (Object)currentThread.getId()).put(ClientAttributes.CLIENT_ADDRESS, (Object)servletRequest.getRemoteAddr()).put(ClientAttributes.CLIENT_PORT, (Object)servletRequest.getRemotePort()).put(UrlAttributes.URL_FULL, (Object)servletRequest.getRequestURL().toString()).put(UserAgentAttributes.USER_AGENT_ORIGINAL, (Object)servletRequest.getHeader("User-Agent"));
        Optional.ofNullable(User.current()).ifPresent(user -> httpServerSpanAttributesBuilder.put(UserIncubatingAttributes.USER_ID, (Object)user.getId()));
        Context httpServerDurationMetricContext = this.httpServerMetrics.onStart(Context.current(), httpServerMetricOnStartAttributesBuilder.build(), System.nanoTime());
        AttributesBuilder httpServerMetricOnEndAttributesBuilder = Attributes.builder();
        try {
            Object httpRoute;
            List<Object> pathInfoTokens = Collections.list(new StringTokenizer(servletRequest.getPathInfo(), "/")).stream().map(token -> (String)token).filter(t -> !t.isEmpty()).collect(Collectors.toList());
            if (pathInfoTokens.isEmpty()) {
                pathInfoTokens = Collections.singletonList("");
            }
            String rootPath = (String)pathInfoTokens.get(0);
            boolean skipSpan = false;
            try {
                switch (rootPath) {
                    case "job": {
                        ParsedJobUrl parsedJobUrl = this.parseJobUrl(pathInfoTokens);
                        httpRoute = parsedJobUrl.urlPattern;
                        Optional.ofNullable(parsedJobUrl.jobName).ifPresent(jobName -> httpServerSpanAttributesBuilder.put(ExtendedJenkinsAttributes.CI_PIPELINE_ID, jobName));
                        Optional.ofNullable(parsedJobUrl.runNumber).ifPresent(runNumber -> httpServerSpanAttributesBuilder.put(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_NUMBER, runNumber));
                        break;
                    }
                    case "blue": {
                        if (pathInfoTokens.size() == 1) {
                            httpRoute = "/blue/";
                            break;
                        }
                        if ("rest".equals(pathInfoTokens.get(1))) {
                            if (pathInfoTokens.size() == 2) {
                                httpRoute = "/blue/rest/";
                                break;
                            }
                            if ("organizations".equals(pathInfoTokens.get(2)) && pathInfoTokens.size() > 7) {
                                ParsedJobUrl parsedBlueOceanPipelineUrl = this.parseBlueOceanRestPipelineUrl(pathInfoTokens);
                                httpRoute = parsedBlueOceanPipelineUrl.urlPattern;
                                Optional.ofNullable(parsedBlueOceanPipelineUrl.jobName).ifPresent(jobName -> httpServerSpanAttributesBuilder.put(ExtendedJenkinsAttributes.CI_PIPELINE_ID, jobName));
                                Optional.ofNullable(parsedBlueOceanPipelineUrl.runNumber).ifPresent(runNumber -> httpServerSpanAttributesBuilder.put(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_NUMBER, runNumber));
                                break;
                            }
                            if ("classes".equals(pathInfoTokens.get(2)) && pathInfoTokens.size() > 3) {
                                String blueOceanClass = (String)pathInfoTokens.get(3);
                                httpRoute = "/blue/rest/classes/:blueOceanClass";
                                httpServerSpanAttributesBuilder.put("blueOceanClass", blueOceanClass);
                                break;
                            }
                            httpRoute = "/blue/rest/" + (String)pathInfoTokens.get(2) + "/*";
                            break;
                        }
                        httpRoute = "/blue/" + (String)pathInfoTokens.get(1) + "/*";
                        break;
                    }
                    case "administrativeMonitor": {
                        httpRoute = "/administrativeMonitor/:administrativeMonitor/*";
                        if (pathInfoTokens.size() > 1) {
                            httpServerSpanAttributesBuilder.put("administrativeMonitor", (String)pathInfoTokens.get(1));
                        }
                        break;
                    }
                    case "asynchPeople": {
                        httpRoute = "/asynchPeople";
                        break;
                    }
                    case "computer": {
                        httpRoute = "/computer/:computer/*";
                        break;
                    }
                    case "credentials": {
                        httpRoute = "/credentials/store/:store/domain/:domain/*";
                        break;
                    }
                    case "descriptorByName": {
                        httpRoute = "/descriptorByName/:descriptor/*";
                        if (pathInfoTokens.size() > 1) {
                            httpServerSpanAttributesBuilder.put("descriptor", (String)pathInfoTokens.get(1));
                        }
                        break;
                    }
                    case "extensionList": {
                        httpRoute = "/extensionList/:extension/*";
                        if (pathInfoTokens.size() > 1) {
                            httpServerSpanAttributesBuilder.put("extension", (String)pathInfoTokens.get(1));
                        }
                        break;
                    }
                    case "fingerprint": {
                        httpRoute = "/fingerprint/:fingerprint";
                        httpServerSpanAttributesBuilder.put("fingerprint", servletRequest.getPathInfo().substring("/fingerprint/".length()));
                        if (pathInfoTokens.size() > 1) {
                            httpServerSpanAttributesBuilder.put("fingerprint", (String)pathInfoTokens.get(1));
                        }
                        break;
                    }
                    case "user": {
                        httpRoute = "/user/:user/*";
                        if (pathInfoTokens.size() > 1) {
                            httpServerSpanAttributesBuilder.put("user", (String)pathInfoTokens.get(1));
                        }
                        break;
                    }
                    default: {
                        httpRoute = "/*";
                        skipSpan = true;
                        break;
                    }
                }
            }
            catch (RuntimeException e) {
                logger.log(Level.INFO, () -> "Exception processing URL " + servletRequest.getPathInfo() + ", skip instrumentation with tracing: " + String.valueOf(e));
                httpRoute = "/##error-processing-url-to-extract-http-route##";
            }
            httpServerSpanAttributesBuilder.put(HttpAttributes.HTTP_ROUTE, httpRoute);
            httpServerMetricOnEndAttributesBuilder.put(HttpAttributes.HTTP_ROUTE, httpRoute);
            this.capturedRequestParameters.forEach(parameterName -> Optional.ofNullable(servletRequest.getParameter(parameterName)).ifPresent(value -> httpServerSpanAttributesBuilder.put("http.request.parameter." + parameterName, value)));
            Span span = skipSpan ? Span.getInvalid() : this.tracer.spanBuilder(servletRequest.getMethod() + " " + (String)httpRoute).setAllAttributes(httpServerSpanAttributesBuilder.build()).setSpanKind(SpanKind.SERVER).startSpan();
            try (Scope scope = span.makeCurrent();){
                filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            }
            catch (ServletException | IOException | RuntimeException e) {
                if (servletResponse.getStatus() < 500) {
                    servletResponse.setStatus(500);
                }
                span.recordException(e);
                httpServerMetricOnEndAttributesBuilder.put(ErrorAttributes.ERROR_TYPE, (Object)e.getClass().getName());
                throw e;
            }
            finally {
                span.setAttribute(HttpAttributes.HTTP_RESPONSE_STATUS_CODE, servletResponse.getStatus());
                httpServerMetricOnEndAttributesBuilder.put(HttpAttributes.HTTP_RESPONSE_STATUS_CODE, servletResponse.getStatus());
                span.end();
            }
        }
        finally {
            this.httpServerMetrics.onEnd(httpServerDurationMetricContext, httpServerMetricOnEndAttributesBuilder.build(), System.nanoTime());
        }
    }

    void checkUrlPathInfoMatch(List<String> pathInfo, List<String> expected) {
        int violationIndex = this.getUrlPathInfoMatch(pathInfo, expected);
        if (violationIndex >= 0) {
            throw new IllegalArgumentException("Invalid URL path /" + String.join((CharSequence)"/", pathInfo) + ", expected: /" + String.join((CharSequence)"/", expected) + ". Violation on item " + violationIndex + ", expected: '" + expected.get(violationIndex) + "', actual: '" + (violationIndex < pathInfo.size() ? "<<missing>>" : pathInfo.get(violationIndex)) + "'");
        }
    }

    boolean isUrlPathInfoMatch(List<String> pathInfo, String ... expected) {
        return this.isUrlPathInfoMatch(pathInfo, Arrays.asList(expected));
    }

    boolean isUrlPathInfoMatch(List<String> pathInfo, List<String> expected) {
        int violationIndex = this.getUrlPathInfoMatch(pathInfo, expected);
        return violationIndex == -1;
    }

    private int getUrlPathInfoMatch(List<String> pathInfo, List<String> expected) {
        int violationIndex = -1;
        if (pathInfo.size() < expected.size()) {
            violationIndex = pathInfo.size() + 1;
        }
        for (int i = 0; i < expected.size(); ++i) {
            String expectedPathInfo = expected.get(i);
            String actualPathInfo = pathInfo.get(i);
            if (expectedPathInfo.startsWith("*") || expectedPathInfo.startsWith(":") || expectedPathInfo.equals(actualPathInfo)) continue;
            violationIndex = i;
        }
        return violationIndex;
    }

    ParsedJobUrl parseBlueOceanRestPipelineUrl(List<String> pathInfo) {
        ArrayList<String> jobUrlPattern;
        Integer stepId;
        String nodeId;
        Long runNumber;
        List<Object> job;
        if (pathInfo.size() > 14 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber", "nodes", ":node", "steps", ":step", "*")) {
            job = Arrays.asList(pathInfo.get(5), pathInfo.get(7));
            runNumber = Long.parseLong(pathInfo.get(9));
            nodeId = pathInfo.get(11);
            stepId = Integer.parseInt(pathInfo.get(13));
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber", "nodes", ":node", "steps", ":step"));
            if (pathInfo.size() > jobUrlPattern.size() + 1) {
                jobUrlPattern.add("*");
            } else {
                jobUrlPattern.add(pathInfo.get(jobUrlPattern.size()));
            }
        } else if (pathInfo.size() > 10 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "runs", ":runNumber", "steps", ":step", "*")) {
            job = Collections.singletonList(pathInfo.get(5));
            runNumber = Long.parseLong(pathInfo.get(7));
            nodeId = null;
            stepId = Integer.parseInt(pathInfo.get(9));
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "runs", ":runNumber", "steps", ":step"));
            if (pathInfo.size() > jobUrlPattern.size() + 1) {
                jobUrlPattern.add("*");
            } else {
                jobUrlPattern.add(pathInfo.get(jobUrlPattern.size()));
            }
        } else if (pathInfo.size() > 13 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber", "nodes", ":node", "steps", "*")) {
            job = Arrays.asList(pathInfo.get(5), pathInfo.get(7));
            runNumber = Long.parseLong(pathInfo.get(9));
            nodeId = pathInfo.get(11);
            stepId = Integer.parseInt(pathInfo.get(13));
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber", "nodes", ":node", "steps"));
            if (pathInfo.size() > jobUrlPattern.size() + 1) {
                jobUrlPattern.add("*");
            } else {
                jobUrlPattern.add(pathInfo.get(jobUrlPattern.size()));
            }
        } else if (pathInfo.size() > 12 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber", "nodes", ":node", "*")) {
            job = Arrays.asList(pathInfo.get(5), pathInfo.get(7));
            runNumber = Long.parseLong(pathInfo.get(9));
            nodeId = pathInfo.get(11);
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber", "nodes", ":node"));
            if (pathInfo.size() > jobUrlPattern.size() + 1) {
                jobUrlPattern.add("*");
            } else {
                jobUrlPattern.add(pathInfo.get(jobUrlPattern.size()));
            }
        } else if (pathInfo.size() > 8 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "runs", ":runNumber")) {
            job = Collections.singletonList(pathInfo.get(5));
            runNumber = Long.parseLong(pathInfo.get(7));
            nodeId = null;
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "runs", ":runNumber"));
            if (pathInfo.size() > jobUrlPattern.size() + 1) {
                jobUrlPattern.add("*");
            } else {
                jobUrlPattern.add(pathInfo.get(jobUrlPattern.size()));
            }
        } else if (pathInfo.size() > 10 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber")) {
            job = Arrays.asList(pathInfo.get(5), pathInfo.get(7));
            runNumber = Long.parseLong(pathInfo.get(9));
            nodeId = null;
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber"));
            if (pathInfo.size() > jobUrlPattern.size() + 1) {
                jobUrlPattern.add("*");
            } else {
                jobUrlPattern.add(pathInfo.get(jobUrlPattern.size()));
            }
        } else if (pathInfo.size() > 9 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber")) {
            job = Arrays.asList(pathInfo.get(5), pathInfo.get(7));
            runNumber = Long.parseLong(pathInfo.get(9));
            nodeId = null;
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "branches", ":branch", "runs", ":runNumber"));
        } else if (pathInfo.size() > 7 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "runs", ":runNumber")) {
            job = Collections.singletonList(pathInfo.get(5));
            runNumber = Long.parseLong(pathInfo.get(7));
            nodeId = null;
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "runs", ":runNumber"));
        } else if (pathInfo.size() > 6 && this.isUrlPathInfoMatch(pathInfo, "blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "*")) {
            job = Collections.singletonList(pathInfo.get(5));
            runNumber = null;
            nodeId = null;
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "organizations", ":organization", "pipelines", ":pipelineName", "*"));
        } else if (pathInfo.size() > 4 && this.isUrlPathInfoMatch(pathInfo, "blue", "organizations", ":organization", ":pipelineName", "activity")) {
            job = Collections.singletonList(pathInfo.get(3));
            runNumber = null;
            nodeId = null;
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "organizations", ":organization", ":pipelineName", "activity"));
        } else if (pathInfo.size() > 1 && this.isUrlPathInfoMatch(Arrays.asList("blue", "rest", "*"), new String[0])) {
            job = Collections.emptyList();
            runNumber = null;
            nodeId = null;
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "rest", "*"));
        } else {
            job = Collections.emptyList();
            runNumber = null;
            nodeId = null;
            stepId = null;
            jobUrlPattern = new ArrayList<String>(Arrays.asList("blue", "*"));
        }
        return new ParsedBlueOceanPipelineJobUrl(job, runNumber, jobUrlPattern, nodeId, stepId);
    }

    ParsedJobUrl parseJobUrl(List<String> pathInfo) {
        String runSegment;
        if (pathInfo.isEmpty()) {
            throw new IllegalArgumentException("Job URL cannot be empty");
        }
        ListIterator<String> pathInfoTokensIt = pathInfo.listIterator();
        String firstToken = pathInfo.get(0);
        if (!"job".equals(firstToken)) {
            throw new IllegalArgumentException("Job URL.pathInfo doesn't start with '/job': " + String.join((CharSequence)"/", pathInfo));
        }
        ArrayList<String> jobName = new ArrayList<String>(5);
        ArrayList<String> jobUrlPattern = new ArrayList<String>(Arrays.asList("job", ":jobFullName"));
        int idx = 0;
        while (pathInfoTokensIt.hasNext()) {
            String nextToken;
            String token = (String)pathInfoTokensIt.next();
            String previousToken = idx == 0 ? null : pathInfo.get(idx - 1);
            String string = nextToken = pathInfoTokensIt.hasNext() ? pathInfo.get(idx + 1) : null;
            if ("job".equals(previousToken)) {
                jobName.add(token);
                if (!"job".equals(nextToken)) break;
            } else if (!"job".equals(token)) {
                throw new IllegalStateException("Unexpected token '" + token + "' with previousToken '" + previousToken + "' and nextToken '" + nextToken + "' in " + String.join((CharSequence)"/", pathInfo));
            }
            ++idx;
        }
        if (!pathInfoTokensIt.hasNext()) {
            return new ParsedJobUrl(jobName, null, jobUrlPattern);
        }
        String token = (String)pathInfoTokensIt.next();
        if ("lastBuild".equals(token)) {
            jobUrlPattern.add("lastBuild");
            if (pathInfoTokensIt.hasNext()) {
                runSegment = (String)pathInfoTokensIt.next();
                jobUrlPattern.add(runSegment);
                if ("artifact".equals(runSegment)) {
                    jobUrlPattern.add(":artifact");
                } else if ("descriptorByName".equals(runSegment)) {
                    jobUrlPattern.add(":descriptor");
                    if (pathInfoTokensIt.hasNext()) {
                        jobUrlPattern.add(":method");
                    }
                } else {
                    pathInfoTokensIt.forEachRemaining(jobUrlPattern::add);
                }
            }
            return new ParsedJobUrl(jobName, null, jobUrlPattern);
        }
        if (StringUtils.isNumeric((String)token)) {
            Long runNumber = Long.parseLong(token);
            jobUrlPattern.add(":runNumber");
            if (pathInfoTokensIt.hasNext()) {
                runSegment = (String)pathInfoTokensIt.next();
                jobUrlPattern.add(runSegment);
                if ("artifact".equals(runSegment)) {
                    jobUrlPattern.add(":artifact");
                } else if ("descriptorByName".equals(runSegment)) {
                    jobUrlPattern.add(":descriptor");
                    if (pathInfoTokensIt.hasNext()) {
                        jobUrlPattern.add(":method");
                    }
                } else if ("execution".equals(runSegment)) {
                    jobUrlPattern.add(":execution");
                    jobUrlPattern.add("*");
                } else {
                    pathInfoTokensIt.forEachRemaining(jobUrlPattern::add);
                }
            }
            return new ParsedJobUrl(jobName, runNumber, jobUrlPattern);
        }
        if ("descriptorByName".equals(token)) {
            jobUrlPattern.add("descriptorByName");
            jobUrlPattern.add(":descriptor");
            jobUrlPattern.add("*");
            return new ParsedJobUrl(jobName, null, jobUrlPattern);
        }
        jobUrlPattern.add(token);
        pathInfoTokensIt.forEachRemaining(jobUrlPattern::add);
        return new ParsedJobUrl(jobName, null, jobUrlPattern);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hashCode(this.getClass());
    }

    @Inject
    public void setTracer(ReconfigurableOpenTelemetry openTelemetry) {
        this.tracer = openTelemetry.getTracer("io.jenkins.stapler");
        this.meter = openTelemetry.getMeter("io.jenkins.stapler");
    }

    public static class ParsedJobUrl {
        @Nullable
        final String jobName;
        @Nullable
        final Long runNumber;
        final String urlPattern;

        public ParsedJobUrl(List<String> jobName, @Nullable Long runNumber, List<String> urlPattern) {
            this(String.join((CharSequence)"/", jobName), runNumber, "/" + String.join((CharSequence)"/", urlPattern));
        }

        public ParsedJobUrl(@Nullable String jobName, @Nullable Long runNumber, String urlPattern) {
            this.jobName = jobName;
            this.urlPattern = urlPattern;
            this.runNumber = runNumber;
        }

        public String toString() {
            return "ParsedJobUrl{jobName='" + this.jobName + "'runNumber='" + this.runNumber + "', uri='" + this.urlPattern + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParsedJobUrl that = (ParsedJobUrl)o;
            return Objects.equals(this.jobName, that.jobName) && Objects.equals(this.runNumber, that.runNumber) && Objects.equals(this.urlPattern, that.urlPattern);
        }

        public int hashCode() {
            return Objects.hash(this.jobName, this.runNumber, this.urlPattern);
        }
    }

    public static class ParsedBlueOceanPipelineJobUrl
    extends ParsedJobUrl {
        final String flowNodeId;
        final Integer stepId;

        public ParsedBlueOceanPipelineJobUrl(List<String> jobName, @Nullable Long runNumber, List<String> urlPattern, @Nullable String flowNodeId, @Nullable Integer stepId) {
            super(jobName, runNumber, urlPattern);
            this.flowNodeId = flowNodeId;
            this.stepId = stepId;
        }

        public ParsedBlueOceanPipelineJobUrl(@Nullable String jobName, @Nullable Long runNumber, @Nullable String flowNodeId, @Nullable Integer stepId, @Nullable String urlPattern) {
            super(jobName, runNumber, urlPattern);
            this.flowNodeId = flowNodeId;
            this.stepId = stepId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ParsedBlueOceanPipelineJobUrl that = (ParsedBlueOceanPipelineJobUrl)o;
            return Objects.equals(this.flowNodeId, that.flowNodeId) && Objects.equals(this.stepId, that.stepId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.flowNodeId, this.stepId);
        }

        @Override
        public String toString() {
            return "ParsedBlueOceanPipelineJobUrl{jobName='" + this.jobName + "', runNumber=" + this.runNumber + ", flowNodeId='" + this.flowNodeId + "', stepId=" + this.stepId + ", urlPattern='" + this.urlPattern + "'}";
        }
    }
}

