/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.step;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.opentelemetry.job.step.SpanAttribute;
import io.jenkins.plugins.opentelemetry.job.step.SpanAttributeStepExecution;
import io.jenkins.plugins.opentelemetry.job.step.SpanAttributeTarget;
import io.opentelemetry.api.common.AttributeType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@Extension
public class WithSpanAttributeStep
extends Step {
    private static final Logger logger = Logger.getLogger(WithSpanAttributeStep.class.getName());
    String key;
    Object value;
    AttributeType type;
    SpanAttributeTarget target;

    @DataBoundConstructor
    public WithSpanAttributeStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        if (this.value == null) {
            return new StepExecution(context){

                public boolean start() {
                    this.getContext().onFailure((Throwable)new IllegalArgumentException("withSpanAttribute requires the value parameter for key " + WithSpanAttributeStep.this.key));
                    return true;
                }
            };
        }
        AttributeType type = this.type;
        if (type == null) {
            boolean isArray = this.value.getClass().isArray();
            type = this.value instanceof Boolean ? (isArray ? AttributeType.BOOLEAN_ARRAY : AttributeType.BOOLEAN) : (this.value instanceof Double || this.value instanceof Float ? (isArray ? AttributeType.DOUBLE_ARRAY : AttributeType.DOUBLE) : (this.value instanceof Long || this.value instanceof Integer ? (isArray ? AttributeType.LONG_ARRAY : AttributeType.LONG) : (isArray ? AttributeType.STRING_ARRAY : AttributeType.STRING)));
        }
        return new SpanAttributeStepExecution(List.of(new SpanAttribute(this.key, this.value, type, this.target)), context.hasBody(), context);
    }

    public String getKey() {
        return this.key;
    }

    @DataBoundSetter
    public void setKey(String key) {
        this.key = key;
    }

    public Object getValue() {
        return this.value;
    }

    @DataBoundSetter
    public void setValue(Object value) {
        this.value = value;
    }

    @CheckForNull
    public String getType() {
        return Optional.ofNullable(this.type).map(Enum::name).orElse(null);
    }

    @DataBoundSetter
    public void setType(String type) {
        this.type = Optional.ofNullable(type).map(String::trim).filter(Predicate.not(String::isEmpty)).map(String::toUpperCase).map(AttributeType::valueOf).orElse(null);
    }

    @DataBoundSetter
    public void setTarget(String target) {
        this.target = Optional.ofNullable(target).map(String::trim).filter(Predicate.not(String::isEmpty)).map(String::toUpperCase).map(SpanAttributeTarget::valueOf).orElse(null);
    }

    @CheckForNull
    public String getTarget() {
        return Optional.ofNullable(this.target).map(Enum::name).orElse(null);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public static final String FUNCTION_NAME = "withSpanAttribute";

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }

        public String getFunctionName() {
            return FUNCTION_NAME;
        }

        @NonNull
        public String getDisplayName() {
            return "Set Span Attribute";
        }

        public ListBoxModel doFillTypeItems(@AncestorInPath Item item, @AncestorInPath ItemGroup context) {
            List<AttributeType> supportedAttributeTypes = Arrays.asList(AttributeType.STRING, AttributeType.LONG, AttributeType.BOOLEAN, AttributeType.DOUBLE);
            return new ListBoxModel((Collection)supportedAttributeTypes.stream().map(t -> new ListBoxModel.Option(t.name(), t.name())).collect(Collectors.toList()));
        }

        public ListBoxModel doFillTargetItems(@AncestorInPath Item item, @AncestorInPath ItemGroup context) {
            return new ListBoxModel((Collection)Arrays.stream(SpanAttributeTarget.values()).map(t -> new ListBoxModel.Option(t.name(), t.name())).collect(Collectors.toList()));
        }
    }
}

