/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.step;

import hudson.Extension;
import hudson.model.TaskListener;
import io.jenkins.plugins.opentelemetry.job.step.SpanAttribute;
import io.jenkins.plugins.opentelemetry.job.step.SpanAttributeStepExecution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class WithNewSpanStep
extends Step {
    private final String label;
    private List<SpanAttribute> attributes = new ArrayList<SpanAttribute>();
    private boolean setAttributesOnlyOnParent = false;

    @DataBoundConstructor
    public WithNewSpanStep(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public List<SpanAttribute> getAttributes() {
        return this.attributes;
    }

    public boolean isSetAttributesOnlyOnParent() {
        return this.setAttributesOnlyOnParent;
    }

    @DataBoundSetter
    public void setAttributes(List<SpanAttribute> attributes) {
        this.attributes = attributes != null ? attributes : new ArrayList();
    }

    @DataBoundSetter
    public void setSetAttributesOnlyOnParent(Boolean setAttributesOnlyOnParent) {
        this.setAttributesOnlyOnParent = setAttributesOnlyOnParent != null && setAttributesOnlyOnParent != false;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public StepExecution start(StepContext context) throws Exception {
        this.attributes.forEach(SpanAttribute::setDefaultType);
        return new SpanAttributeStepExecution(this.attributes, context.hasBody(), context, this.setAttributesOnlyOnParent);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "withNewSpan";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public String getDisplayName() {
            return "Step with a new user-defined Span";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }
    }
}

