/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.step;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.opentelemetry.job.step.SpanAttribute;
import io.jenkins.plugins.opentelemetry.job.step.SpanAttributeStepExecution;
import io.jenkins.plugins.opentelemetry.job.step.SpanAttributeTarget;
import io.opentelemetry.api.common.AttributeType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;

public class SetSpanAttributesStep
extends Step {
    List<SpanAttribute> spanAttributes;

    @DataBoundConstructor
    public SetSpanAttributesStep(List<SpanAttribute> spanAttributes) {
        this.spanAttributes = spanAttributes;
    }

    public StepExecution start(StepContext context) throws Exception {
        if (this.spanAttributes == null) {
            return new StepExecution(context){

                public boolean start() {
                    this.getContext().onFailure((Throwable)new IllegalArgumentException("setSpanAttributes requires the spanAttributes parameter"));
                    return true;
                }
            };
        }
        List noValueSet = this.spanAttributes.stream().filter(spanAttribute -> spanAttribute.getValue() == null).collect(Collectors.toList());
        if (!noValueSet.isEmpty()) {
            final String keys = noValueSet.stream().map(SpanAttribute::getKey).reduce("", (accumulator, spanAttribute) -> {
                if (accumulator.isEmpty()) {
                    return spanAttribute;
                }
                return accumulator + ", " + spanAttribute;
            });
            return new StepExecution(context){

                public boolean start() {
                    this.getContext().onFailure((Throwable)new IllegalArgumentException("setSpanAttributes requires that all spanAttributes have a value set. The attribute(s) with the following keys violate this requirement: " + keys));
                    return true;
                }
            };
        }
        this.spanAttributes.forEach(SpanAttribute::setDefaultType);
        return new SpanAttributeStepExecution(this.spanAttributes, context.hasBody(), context);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public static final String FUNCTION_NAME = "setSpanAttributes";

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }

        public String getFunctionName() {
            return FUNCTION_NAME;
        }

        @NonNull
        public String getDisplayName() {
            return "Set Span Attributes";
        }

        public ListBoxModel doFillTypeItems(@AncestorInPath Item item, @AncestorInPath ItemGroup context) {
            List<AttributeType> supportedAttributeTypes = Arrays.asList(AttributeType.STRING, AttributeType.LONG, AttributeType.BOOLEAN, AttributeType.DOUBLE);
            return new ListBoxModel((Collection)supportedAttributeTypes.stream().map(t -> new ListBoxModel.Option(t.name(), t.name())).collect(Collectors.toList()));
        }

        public ListBoxModel doFillTargetItems(@AncestorInPath Item item, @AncestorInPath ItemGroup context) {
            return new ListBoxModel((Collection)Arrays.stream(SpanAttributeTarget.values()).map(t -> new ListBoxModel.Option(t.name(), t.name())).collect(Collectors.toList()));
        }
    }
}

