/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.step;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.opentelemetry.job.step.StepHandler;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import java.util.Map;
import jenkins.YesNoMaybe;
import org.jenkinsci.plugins.workflow.actions.ArgumentsAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildTriggerStep;

@Extension(optional=true, dynamicLoadable=YesNoMaybe.YES)
public class BuildTriggerStepHandler
implements StepHandler {
    @Override
    public boolean canCreateSpanBuilder(@NonNull FlowNode flowNode, @NonNull WorkflowRun run) {
        return flowNode instanceof StepAtomNode && ((StepAtomNode)flowNode).getDescriptor() instanceof BuildTriggerStep.DescriptorImpl;
    }

    @Override
    @NonNull
    public SpanBuilder createSpanBuilder(@NonNull FlowNode node, @NonNull WorkflowRun run, @NonNull Tracer tracer) {
        Map arguments = ArgumentsAction.getFilteredArguments((FlowNode)node);
        String job = Preconditions.checkNotNull(arguments.get("job")).toString();
        SpanBuilder spanBuilder = tracer.spanBuilder("build: " + job);
        spanBuilder.setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_NAME, (Object)job);
        return spanBuilder;
    }
}

