/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log.util;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.jenkins.plugins.opentelemetry.job.log.LogLine;
import io.jenkins.plugins.opentelemetry.job.log.util.LogLineIterator;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Scope;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogLineIteratorInputStream<Id>
extends InputStream {
    private static final Logger logger = Logger.getLogger(LogLineIteratorInputStream.class.getName());
    private final LogLineIterator.LogLineBytesToLogLineIdMapper<Id> logLineBytesToLogLineIdConverter;
    private final LogLineIterator<Id> logLines;
    protected final Tracer tracer;
    private int cursorOnCurrentLine;
    private byte[] currentLine;
    private long readBytes;
    private Id lastLogLineId;

    public LogLineIteratorInputStream(LogLineIterator<Id> logLines, LogLineIterator.LogLineBytesToLogLineIdMapper<Id> logLineBytesToLogLineIdConverter, Tracer tracer) {
        this.logLines = logLines;
        this.logLineBytesToLogLineIdConverter = logLineBytesToLogLineIdConverter;
        this.tracer = tracer;
    }

    @Override
    public int read() throws IOException {
        if (this.currentLine == null) {
            if (this.cursorOnCurrentLine != 0) {
                throw new IllegalStateException("Current line is null but cursorOnCurrentLine!=0: " + this.cursorOnCurrentLine);
            }
            this.currentLine = Optional.ofNullable(this.readLine()).map(line -> (line.getMessage() + "\n").getBytes(StandardCharsets.UTF_8)).orElse(null);
            if (this.currentLine == null) {
                return -1;
            }
        }
        if (this.cursorOnCurrentLine > this.currentLine.length) {
            throw new IllegalStateException();
        }
        byte result = this.currentLine[this.cursorOnCurrentLine++];
        if (this.cursorOnCurrentLine == this.currentLine.length) {
            this.currentLine = null;
            this.cursorOnCurrentLine = 0;
        }
        ++this.readBytes;
        return result;
    }

    @Nullable
    LogLine<Id> readLine() {
        if (this.logLines.hasNext()) {
            LogLine logLine = (LogLine)this.logLines.next();
            this.lastLogLineId = logLine.getId();
            return logLine;
        }
        return null;
    }

    @Override
    public long skip(long skipBytes) throws IOException {
        Tracer tracer = logger.isLoggable(Level.FINE) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("LogLineIteratorInputStream.skip").setAttribute("skipBytes", skipBytes).startSpan();
        try {
            long l;
            block9: {
                Scope scope = span.makeCurrent();
                try {
                    Optional<Id> logLineId = Optional.ofNullable(this.logLineBytesToLogLineIdConverter.getLogLineIdFromLogBytes(skipBytes));
                    logLineId.ifPresentOrElse(id -> {
                        span.setAttribute("previousLastLogLineId", String.valueOf(this.lastLogLineId));
                        span.setAttribute("lastLogLineId", String.valueOf(id));
                        this.logLines.skipLines(id);
                        this.readBytes += skipBytes;
                        this.lastLogLineId = id;
                    }, () -> span.addEvent("LogLine Bytes to LogLine Id conversion not found"));
                    l = skipBytes;
                    if (scope == null) break block9;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return l;
        }
        finally {
            span.end();
        }
    }

    @Override
    public int available() throws IOException {
        Tracer tracer = logger.isLoggable(Level.FINER) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("LogLineIteratorInputStream.available").startSpan();
        try {
            int n;
            block13: {
                Scope scope;
                block11: {
                    int n2;
                    block12: {
                        scope = span.makeCurrent();
                        try {
                            if (!this.logLines.hasNext()) break block11;
                            n2 = 1;
                            if (scope == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (scope != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        scope.close();
                    }
                    return n2;
                }
                n = 0;
                if (scope == null) break block13;
                scope.close();
            }
            return n;
        }
        finally {
            span.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Tracer tracer = logger.isLoggable(Level.FINER) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("LogLineIteratorInputStream.close").setAttribute("readBytes", this.readBytes).setAttribute("lastLogLineId", String.valueOf(this.lastLogLineId)).startSpan();
        try (Scope scope = span.makeCurrent();){
            this.logLineBytesToLogLineIdConverter.putLogBytesToLogLineId(this.readBytes, this.lastLogLineId);
            if (this.logLines instanceof Closeable) {
                ((Closeable)((Object)this.logLines)).close();
            }
        }
        finally {
            span.end();
        }
    }
}

