/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log.util;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.jenkins.plugins.opentelemetry.job.RunFlowNodeIdentifier;
import io.jenkins.plugins.opentelemetry.job.log.LogLine;
import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

public interface LogLineIterator<Id>
extends Iterator<LogLine<Id>> {
    public void skipLines(Id var1);

    public static class JenkinsHttpSessionLineBytesToLogLineIdMapper<Id>
    implements LogLineBytesToLogLineIdMapper<Id> {
        private static final Logger logger = Logger.getLogger(JenkinsHttpSessionLineBytesToLogLineIdMapper.class.getName());
        public static final String HTTP_SESSION_KEY = "JenkinsHttpSessionLineBytesToLineNumberConverter";
        final String jobFullName;
        final int runNumber;
        @Nullable
        final String flowNodeId;

        public JenkinsHttpSessionLineBytesToLogLineIdMapper(String jobFullName, int runNumber, @Nullable String flowNodeId) {
            this.jobFullName = jobFullName;
            this.runNumber = runNumber;
            this.flowNodeId = flowNodeId;
        }

        @Override
        @Nullable
        public Id getLogLineIdFromLogBytes(long bytes) {
            RunFlowNodeIdentifier contextKey = new RunFlowNodeIdentifier(this.jobFullName, this.runNumber, this.flowNodeId);
            return Optional.ofNullable(this.getContext().get(contextKey)).map(d -> d.get(bytes)).orElse(null);
        }

        @Override
        public void putLogBytesToLogLineId(long bytes, Id logLineId) {
            RunFlowNodeIdentifier contextKey = new RunFlowNodeIdentifier(this.jobFullName, this.runNumber, this.flowNodeId);
            this.getContext().computeIfAbsent(contextKey, runFlowNodeIdentifier -> new HashMap()).put(bytes, logLineId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Map<RunFlowNodeIdentifier, Map<Long, Id>> getContext() {
            HttpSession session;
            StaplerRequest2 currentRequest = Stapler.getCurrentRequest2();
            if (currentRequest == null) {
                logger.log(Level.WARNING, "No current request found, default to default LogLineNumber context");
                return new HashMap<RunFlowNodeIdentifier, Map<Long, Id>>();
            }
            HttpSession httpSession = session = currentRequest.getSession();
            synchronized (httpSession) {
                HashMap<RunFlowNodeIdentifier, Map<Long, Id>> context = (HashMap<RunFlowNodeIdentifier, Map<Long, Id>>)session.getAttribute(HTTP_SESSION_KEY);
                if (context == null) {
                    context = new HashMap<RunFlowNodeIdentifier, Map<Long, Id>>();
                    session.setAttribute(HTTP_SESSION_KEY, context);
                }
                return context;
            }
        }
    }

    public static interface LogLineBytesToLogLineIdMapper<Id> {
        @Nullable
        public Id getLogLineIdFromLogBytes(long var1);

        public void putLogBytesToLogLineId(long var1, Id var3);
    }
}

