/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log;

import com.google.common.base.Objects;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;

public class RunTraceContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    final String jobFullName;
    final int runNumber;
    final String spanId;
    final String traceId;
    final Map<String, String> w3cTraceContext;

    public RunTraceContext(String jobFullName, int runNumber, String traceId, String spanId, Map<String, String> w3cTraceContext) {
        this.jobFullName = jobFullName;
        this.runNumber = runNumber;
        this.traceId = traceId;
        this.spanId = spanId;
        this.w3cTraceContext = Collections.unmodifiableMap(w3cTraceContext);
    }

    @NonNull
    public Attributes toAttributes() {
        return Attributes.builder().put(ExtendedJenkinsAttributes.CI_PIPELINE_ID, (Object)this.jobFullName).put(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_NUMBER, this.runNumber).build();
    }

    public String getJobFullName() {
        return this.jobFullName;
    }

    public int getRunNumber() {
        return this.runNumber;
    }

    public Map<String, String> getW3cTraceContext() {
        return this.w3cTraceContext;
    }

    public Context getContext() {
        return W3CTraceContextPropagator.getInstance().extract(Context.current(), this.getW3cTraceContext(), (TextMapGetter)new TextMapGetter<Map<String, String>>(){

            public Iterable<String> keys(@Nonnull Map<String, String> carrier) {
                return carrier.keySet();
            }

            @Nullable
            public String get(@Nullable Map<String, String> carrier, @Nonnull String key) {
                assert (carrier != null);
                return carrier.get(key);
            }
        });
    }

    public String toString() {
        return "RunTraceContext{jobFullName='" + this.jobFullName + "', runNumber=" + this.runNumber + ", spanId='" + this.spanId + "', traceId='" + this.traceId + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunTraceContext runTraceContext = (RunTraceContext)o;
        return this.runNumber == runTraceContext.runNumber && Objects.equal((Object)this.jobFullName, (Object)runTraceContext.jobFullName) && Objects.equal((Object)this.traceId, (Object)runTraceContext.traceId) && Objects.equal((Object)this.spanId, (Object)runTraceContext.spanId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.jobFullName, this.runNumber, this.traceId, this.spanId});
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }
}

