/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Queue;
import hudson.model.Run;
import io.jenkins.plugins.opentelemetry.JenkinsControllerOpenTelemetry;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.jenkins.plugins.opentelemetry.job.MonitoringAction;
import io.jenkins.plugins.opentelemetry.job.OtelTraceService;
import io.jenkins.plugins.opentelemetry.job.log.OtelLogStorage;
import io.opentelemetry.api.trace.Tracer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.log.BrokenLogStorage;
import org.jenkinsci.plugins.workflow.log.LogStorage;
import org.jenkinsci.plugins.workflow.log.LogStorageFactory;

@Extension
public final class OtelLogStorageFactory
implements LogStorageFactory,
OpenTelemetryLifecycleListener {
    private static final Logger logger = Logger.getLogger(OtelLogStorageFactory.class.getName());
    @Inject
    JenkinsControllerOpenTelemetry jenkinsControllerOpenTelemetry;
    @Nullable
    private OtelTraceService otelTraceService;
    private Tracer tracer;

    static OtelLogStorageFactory get() {
        return (OtelLogStorageFactory)ExtensionList.lookupSingleton(OtelLogStorageFactory.class);
    }

    @Nullable
    public LogStorage forBuild(@NonNull FlowExecutionOwner owner) {
        LogStorage ret = null;
        if (!this.getJenkinsControllerOpenTelemetry().isLogsEnabled()) {
            logger.log(Level.FINE, () -> "OTel Logs disabled");
            return ret;
        }
        try {
            Queue.Executable exec = owner.getExecutable();
            ret = this.forExec(exec);
        }
        catch (IOException x) {
            ret = new BrokenLogStorage((Throwable)x);
        }
        return ret;
    }

    @Nullable
    private LogStorage forExec(@NonNull Queue.Executable exec) {
        Run run;
        OtelLogStorage ret = null;
        if (exec instanceof Run && (run = (Run)exec).getAction(MonitoringAction.class) != null) {
            logger.log(Level.FINEST, () -> "forExec(" + String.valueOf(run) + ")");
            ret = new OtelLogStorage(run, this.getOtelTraceService(), this.tracer);
        }
        return ret;
    }

    @NonNull
    private JenkinsControllerOpenTelemetry getJenkinsControllerOpenTelemetry() {
        if (this.jenkinsControllerOpenTelemetry == null) {
            this.jenkinsControllerOpenTelemetry = JenkinsControllerOpenTelemetry.get();
        }
        return this.jenkinsControllerOpenTelemetry;
    }

    @NonNull
    private OtelTraceService getOtelTraceService() {
        if (this.otelTraceService == null) {
            this.otelTraceService = OtelTraceService.get();
        }
        return this.otelTraceService;
    }

    @PostConstruct
    public void postConstruct() {
        this.tracer = this.jenkinsControllerOpenTelemetry.getDefaultTracer();
    }

    static {
        System.setProperty("org.jenkinsci.plugins.workflow.steps.durable_task.DurableTaskStep.USE_WATCHING", "true");
    }
}

