/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.console.AnnotatedLargeText;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.opentelemetry.JenkinsControllerOpenTelemetry;
import io.jenkins.plugins.opentelemetry.JenkinsOpenTelemetryPluginConfiguration;
import io.jenkins.plugins.opentelemetry.job.MonitoringAction;
import io.jenkins.plugins.opentelemetry.job.OtelTraceService;
import io.jenkins.plugins.opentelemetry.job.log.FlowNodeTraceContext;
import io.jenkins.plugins.opentelemetry.job.log.LogStorageRetriever;
import io.jenkins.plugins.opentelemetry.job.log.LogsQueryResult;
import io.jenkins.plugins.opentelemetry.job.log.OtelLogSenderBuildListener;
import io.jenkins.plugins.opentelemetry.job.log.OverallLog;
import io.jenkins.plugins.opentelemetry.job.log.RunTraceContext;
import io.jenkins.plugins.opentelemetry.job.log.util.TeeBuildListener;
import io.jenkins.plugins.opentelemetry.job.log.util.TeeOutputStreamBuildListener;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.BuildListenerAdapter;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.log.BrokenLogStorage;
import org.jenkinsci.plugins.workflow.log.FileLogStorage;
import org.jenkinsci.plugins.workflow.log.LogStorage;
import org.jenkinsci.plugins.workflow.log.OutputStreamTaskListener;

class OtelLogStorage
implements LogStorage {
    private static final Logger logger = Logger.getLogger(OtelLogStorage.class.getName());
    final Run run;
    final RunTraceContext runTraceContext;
    final String runFolderPath;
    final Tracer tracer;
    final OtelTraceService otelTraceService;

    public OtelLogStorage(@NonNull Run run, @NonNull OtelTraceService otelTraceService, @NonNull Tracer tracer) {
        this.run = run;
        MonitoringAction monitoringAction = Optional.ofNullable((MonitoringAction)run.getAction(MonitoringAction.class)).orElseThrow(() -> new IllegalStateException("No MonitoringAction found for " + String.valueOf(run)));
        this.runTraceContext = new RunTraceContext(run.getParent().getFullName(), run.getNumber(), monitoringAction.getTraceId(), monitoringAction.getSpanId(), monitoringAction.getW3cTraceContext());
        this.otelTraceService = otelTraceService;
        this.tracer = tracer;
        this.runFolderPath = run.getRootDir().getPath();
    }

    @NonNull
    public BuildListener overallListener() throws IOException {
        Object result;
        OtelLogSenderBuildListener.OtelLogSenderBuildListenerOnController otelLogSenderBuildListener = new OtelLogSenderBuildListener.OtelLogSenderBuildListenerOnController(this.runTraceContext);
        if (JenkinsControllerOpenTelemetry.get().isOtelLogsMirrorToDisk()) {
            try {
                File logFile = new File(this.runFolderPath, "log");
                BuildListener fileStorageBuildListener = FileLogStorage.forFile((File)logFile).overallListener();
                if (fileStorageBuildListener instanceof OutputStreamTaskListener) {
                    result = new TeeOutputStreamBuildListener(otelLogSenderBuildListener, fileStorageBuildListener);
                }
                logger.log(Level.INFO, () -> "overallListener(): FileLogStorage's TaskListener is not a OutputStreamTaskListener, use TeeBuildListener for " + String.valueOf(fileStorageBuildListener));
                result = new TeeBuildListener((TaskListener)otelLogSenderBuildListener, (TaskListener)fileStorageBuildListener);
            }
            catch (IOException | InterruptedException e) {
                throw new IOException("Failure creating the mirror logs.", e);
            }
        } else {
            result = otelLogSenderBuildListener;
        }
        return result;
    }

    @NonNull
    public BuildListener nodeListener(@NonNull FlowNode flowNode) throws IOException {
        Object result;
        Span span = this.otelTraceService.getSpan(this.run, flowNode);
        FlowNodeTraceContext flowNodeTraceContext = FlowNodeTraceContext.newFlowNodeTraceContext(this.run, flowNode, span);
        OtelLogSenderBuildListener.OtelLogSenderBuildListenerOnController otelLogSenderBuildListener = new OtelLogSenderBuildListener.OtelLogSenderBuildListenerOnController(flowNodeTraceContext);
        if (JenkinsControllerOpenTelemetry.get().isOtelLogsMirrorToDisk()) {
            try {
                File logFile = new File(this.runFolderPath, "log");
                BuildListener fileStorageBuildListener = BuildListenerAdapter.wrap((TaskListener)FileLogStorage.forFile((File)logFile).nodeListener(flowNode));
                if (fileStorageBuildListener instanceof OutputStreamTaskListener) {
                    result = new TeeOutputStreamBuildListener(otelLogSenderBuildListener, fileStorageBuildListener);
                }
                logger.log(Level.INFO, () -> "nodeListener(): FileLogStorage's TaskListener is not a OutputStreamTaskListener, use TeeBuildListener for " + String.valueOf(fileStorageBuildListener));
                result = new TeeBuildListener((TaskListener)otelLogSenderBuildListener, (TaskListener)fileStorageBuildListener);
            }
            catch (IOException | InterruptedException e) {
                throw new IOException("Failure creating the mirror logs.", e);
            }
        } else {
            result = otelLogSenderBuildListener;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public AnnotatedLargeText<FlowExecutionOwner.Executable> overallLog(@NonNull FlowExecutionOwner.Executable build, boolean complete) {
        File logFile = new File(this.runFolderPath, "log");
        if (logFile.exists()) {
            return FileLogStorage.forFile((File)logFile).overallLog(build, complete);
        }
        Span span = this.tracer.spanBuilder("OtelLogStorage.overallLog").setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_ID, (Object)this.run.getParent().getFullName()).setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_NUMBER, (Object)this.run.getNumber()).setAttribute("complete", complete).startSpan();
        try {
            OverallLog overallLog;
            block12: {
                Scope ignored = span.makeCurrent();
                try {
                    LogStorageRetriever logStorageRetriever = this.getLogStorageRetriever();
                    Instant startTime = Instant.ofEpochMilli(this.run.getStartTimeInMillis());
                    Instant endTime = this.run.getDuration() == 0L ? null : startTime.plusMillis(this.run.getDuration());
                    LogsQueryResult logsQueryResult = logStorageRetriever.overallLog(this.run.getParent().getFullName(), this.run.getNumber(), this.runTraceContext.getTraceId(), this.runTraceContext.getSpanId(), complete, startTime, endTime);
                    span.setAttribute("completed", logsQueryResult.isComplete());
                    overallLog = new OverallLog(logsQueryResult.getByteBuffer(), logsQueryResult.getLogsViewHeader(), logsQueryResult.getCharset(), logsQueryResult.isComplete(), build, this.tracer);
                    if (ignored == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception x) {
                        span.recordException((Throwable)x);
                        AnnotatedLargeText annotatedLargeText = new BrokenLogStorage((Throwable)x).overallLog(build, complete);
                        return annotatedLargeText;
                    }
                }
                ignored.close();
            }
            return overallLog;
        }
        finally {
            span.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public AnnotatedLargeText<FlowNode> stepLog(@NonNull FlowNode flowNode, boolean complete) {
        File logFile = new File(this.runFolderPath, "log");
        if (logFile.exists()) {
            return FileLogStorage.forFile((File)logFile).stepLog(flowNode, complete);
        }
        Span span = this.tracer.spanBuilder("OtelLogStorage.stepLog").setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_ID, (Object)this.run.getParent().getFullName()).setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_NUMBER, (Object)this.run.getNumber()).setAttribute("complete", complete).startSpan();
        try {
            AnnotatedLargeText annotatedLargeText;
            block13: {
                Scope ignored = span.makeCurrent();
                try {
                    String traceId = this.runTraceContext.getTraceId();
                    String spanId = this.runTraceContext.getSpanId();
                    if (traceId == null || spanId == null) {
                        throw new IllegalStateException("traceId or spanId is null for " + String.valueOf(this.run));
                    }
                    LogStorageRetriever logStorageRetriever = this.getLogStorageRetriever();
                    Instant startTime = Instant.ofEpochMilli(this.run.getStartTimeInMillis());
                    Instant endTime = this.run.getDuration() == 0L ? null : startTime.plusMillis(this.run.getDuration());
                    LogsQueryResult logsQueryResult = logStorageRetriever.stepLog(this.run.getParent().getFullName(), this.run.getNumber(), flowNode.getId(), traceId, spanId, complete, startTime, endTime);
                    span.setAttribute("completed", logsQueryResult.isComplete()).setAttribute("length", logsQueryResult.byteBuffer.length());
                    annotatedLargeText = new AnnotatedLargeText(logsQueryResult.getByteBuffer(), logsQueryResult.getCharset(), logsQueryResult.isComplete(), (Object)flowNode);
                    if (ignored == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception x) {
                        span.recordException((Throwable)x);
                        AnnotatedLargeText annotatedLargeText2 = new BrokenLogStorage((Throwable)x).stepLog(flowNode, complete);
                        return annotatedLargeText2;
                    }
                }
                ignored.close();
            }
            return annotatedLargeText;
        }
        finally {
            span.end();
        }
    }

    @Deprecated
    public File getLogFile(@NonNull FlowExecutionOwner.Executable build, boolean complete) {
        logger.log(Level.FINE, "getLogFile(complete: " + complete + ")");
        File logFile = new File(this.runFolderPath, "log");
        if (logFile.exists()) {
            return FileLogStorage.forFile((File)logFile).getLogFile(build, complete);
        }
        Span span = this.tracer.spanBuilder("OtelLogStorage.getLogFile").setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_ID, (Object)this.run.getParent().getFullName()).setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_NUMBER, (Object)this.run.getNumber()).setAttribute("complete", complete).startSpan();
        try {
            File file;
            block20: {
                Scope ignored = span.makeCurrent();
                try {
                    AnnotatedLargeText<FlowExecutionOwner.Executable> logText = this.overallLog(build, complete);
                    File f = new File(((Run)build).getRootDir(), "log");
                    f.deleteOnExit();
                    try (FileOutputStream os = new FileOutputStream(f);){
                        long pos2;
                        long pos = 0L;
                        while ((pos2 = logText.writeRawLogTo(pos, (OutputStream)os)) > pos) {
                            pos = pos2;
                        }
                    }
                    catch (Exception x) {
                        logger.log(Level.WARNING, null, x);
                        span.recordException((Throwable)x);
                    }
                    file = f;
                    if (ignored == null) break block20;
                }
                catch (Throwable throwable) {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored.close();
            }
            return file;
        }
        finally {
            span.end();
        }
    }

    public String toString() {
        return "OtelLogStorage{context=" + String.valueOf(this.runTraceContext) + "}";
    }

    @NonNull
    public LogStorageRetriever getLogStorageRetriever() {
        return JenkinsOpenTelemetryPluginConfiguration.get().getLogStorageRetriever();
    }
}

