/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.BuildListener;
import io.jenkins.plugins.opentelemetry.job.log.OtelLogOutputStream;
import io.jenkins.plugins.opentelemetry.job.log.RunTraceContext;
import io.jenkins.plugins.opentelemetry.opentelemetry.GlobalOpenTelemetrySdk;
import io.jenkins.plugins.opentelemetry.opentelemetry.common.Clocks;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.sdk.common.Clock;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.JenkinsJVM;
import org.jenkinsci.plugins.workflow.log.OutputStreamTaskListener;

abstract class OtelLogSenderBuildListener
implements BuildListener,
OutputStreamTaskListener {
    protected static final Logger LOGGER = Logger.getLogger(OtelLogSenderBuildListener.class.getName());
    final RunTraceContext runTraceContext;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    transient Clock clock;
    @CheckForNull
    transient OutputStream outputStream;
    @CheckForNull
    transient PrintStream logger;

    public OtelLogSenderBuildListener(@NonNull RunTraceContext runTraceContext) {
        this.runTraceContext = runTraceContext;
        this.clock = Clocks.monotonicClock();
        JenkinsJVM.checkJenkinsJVM();
    }

    @NonNull
    public final synchronized OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = new OtelLogOutputStream(this.runTraceContext, this.getOtelLogger(), this.clock);
        }
        return this.outputStream;
    }

    @NonNull
    public final synchronized PrintStream getLogger() {
        if (this.logger == null) {
            this.logger = new PrintStream((OutputStream)((Object)new OtelLogOutputStream(this.runTraceContext, this.getOtelLogger(), this.clock)), false, StandardCharsets.UTF_8);
        }
        return this.logger;
    }

    abstract io.opentelemetry.api.logs.Logger getOtelLogger();

    private static class OtelLogSenderBuildListenerOnAgent
    extends OtelLogSenderBuildListener {
        private static final long serialVersionUID = 1L;
        private static final Logger logger = Logger.getLogger(OtelLogSenderBuildListenerOnAgent.class.getName());
        private long instantInNanosOnJenkinsControllerBeforeSerialization;

        private OtelLogSenderBuildListenerOnAgent(@NonNull RunTraceContext runTraceContext) {
            super(runTraceContext);
            logger.log(Level.FINEST, () -> "new OtelLogSenderBuildListenerOnAgent()");
            JenkinsJVM.checkJenkinsJVM();
        }

        @Override
        public io.opentelemetry.api.logs.Logger getOtelLogger() {
            JenkinsJVM.checkNotJenkinsJVM();
            return GlobalOpenTelemetrySdk.getOtelLogger();
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            logger.log(Level.FINEST, () -> "writeObject(): set instantInNanosOnJenkinsControllerBeforeSerialization");
            JenkinsJVM.checkJenkinsJVM();
            this.instantInNanosOnJenkinsControllerBeforeSerialization = Clock.getDefault().now();
            stream.defaultWriteObject();
        }

        private Object readResolve() {
            JenkinsJVM.checkNotJenkinsJVM();
            if (this.instantInNanosOnJenkinsControllerBeforeSerialization == 0L) {
                logger.log(Level.INFO, () -> "adjustClock: unexpected timeBeforeSerialization of 0ns, don't adjust the clock");
                this.clock = Clocks.monotonicClock();
            } else {
                long instantInNanosOnJenkinsAgentAtDeserialization = Clock.getDefault().now();
                long offsetInNanosOnJenkinsAgent = this.instantInNanosOnJenkinsControllerBeforeSerialization - instantInNanosOnJenkinsAgentAtDeserialization;
                logger.log(Level.FINE, () -> "adjustClock: offsetInNanos: " + TimeUnit.MILLISECONDS.convert(offsetInNanosOnJenkinsAgent, TimeUnit.NANOSECONDS) + "ms / " + offsetInNanosOnJenkinsAgent + "ns. A negative offset of few milliseconds is expected due to the latency of the communication from the Jenkins Controller to the Jenkins Agent. Higher offsets indicate a synchronization gap of the system clocks between the Jenkins Controller that will be work arounded by the clock adjustment.");
                this.clock = Clocks.monotonicOffsetClock(offsetInNanosOnJenkinsAgent);
            }
            return this;
        }
    }

    static final class OtelLogSenderBuildListenerOnController
    extends OtelLogSenderBuildListener {
        private static final long serialVersionUID = 1L;
        private static final Logger logger = Logger.getLogger(OtelLogSenderBuildListenerOnController.class.getName());

        public OtelLogSenderBuildListenerOnController(@NonNull RunTraceContext runTraceContext) {
            super(runTraceContext);
            logger.log(Level.FINEST, () -> "new OtelLogSenderBuildListenerOnController()");
            JenkinsJVM.checkJenkinsJVM();
        }

        @Override
        public io.opentelemetry.api.logs.Logger getOtelLogger() {
            JenkinsJVM.checkJenkinsJVM();
            return GlobalOpenTelemetry.get().getLogsBridge().get("io.jenkins.opentelemetry");
        }

        private Object writeReplace() throws IOException {
            logger.log(Level.FINEST, () -> "writeReplace()");
            JenkinsJVM.checkJenkinsJVM();
            return new OtelLogSenderBuildListenerOnAgent(this.runTraceContext);
        }
    }
}

