/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotationOutputStream;
import hudson.console.ConsoleAnnotator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.output.CountingOutputStream;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

public class LogsViewHeader {
    private static final String messageFirstToken = " View logs in ";
    private final String backendName;
    private final String backendUrl;
    private final String backendIconUrl;

    public LogsViewHeader(String backendName, String backendUrl, String backendIconUrl) {
        this.backendName = backendName;
        this.backendUrl = backendUrl;
        this.backendIconUrl = backendIconUrl;
    }

    public String getMessage() {
        return messageFirstToken + this.backendName;
    }

    public long writeHeader(Writer w, FlowExecutionOwner.Executable context, Charset charset) throws IOException {
        ConsoleAnnotator<Object> consoleAnnotator = new ConsoleAnnotator<Object>(){

            public ConsoleAnnotator<Object> annotate(@NonNull Object context, @NonNull MarkupText text) {
                StaplerRequest2 currentRequest = Stapler.getCurrentRequest2();
                Object iconRootContextRelativeUrl = currentRequest == null ? LogsViewHeader.this.backendIconUrl : currentRequest.getContextPath() + LogsViewHeader.this.backendIconUrl;
                text.addMarkup(0, 0, "<img src='" + (String)iconRootContextRelativeUrl + "' />", "");
                text.addMarkup(LogsViewHeader.messageFirstToken.length(), LogsViewHeader.messageFirstToken.length() + LogsViewHeader.this.backendName.length(), "<a href='" + LogsViewHeader.this.backendUrl + "' target='_blank'>", "</a>");
                return this;
            }
        };
        ConsoleAnnotationOutputStream caw = new ConsoleAnnotationOutputStream(w, (ConsoleAnnotator)consoleAnnotator, (Object)context, charset);
        try (CountingOutputStream cos = new CountingOutputStream((OutputStream)caw);){
            cos.write((this.getMessage() + "\n").getBytes(StandardCharsets.UTF_8));
            cos.flush();
            long l = cos.getByteCount();
            return l;
        }
    }
}

