/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.jenkins;

import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Action;
import hudson.model.Queue;
import io.jenkins.plugins.opentelemetry.job.step.WithNewSpanStep;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.StageStatus;
import org.jenkinsci.plugins.pipeline.SyntheticStage;
import org.jenkinsci.plugins.workflow.actions.BodyInvocationAction;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.TagsAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.cps.actions.ArgumentsActionImpl;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.cps.steps.ParallelStep;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStep;
import org.jenkinsci.plugins.workflow.support.steps.StageStep;

public class PipelineNodeUtil {
    private static final Logger LOGGER = Logger.getLogger(PipelineNodeUtil.class.getName());

    public static boolean isStartStage(FlowNode node) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof StepStartNode)) {
            return false;
        }
        StepStartNode stepStartNode = (StepStartNode)node;
        if (!(stepStartNode.getDescriptor() instanceof StageStep.DescriptorImpl)) {
            return false;
        }
        return node.getAction(LabelAction.class) != null;
    }

    public static boolean isStartWithNewSpan(FlowNode node) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof StepStartNode)) {
            return false;
        }
        StepStartNode stepStartNode = (StepStartNode)node;
        if (!(stepStartNode.getDescriptor() instanceof WithNewSpanStep.DescriptorImpl)) {
            return false;
        }
        return node.getAction(ArgumentsActionImpl.class) != null;
    }

    public static boolean isSyntheticStage(@Nullable FlowNode node) {
        return node != null && PipelineNodeUtil.getSyntheticStage(node) != null;
    }

    @CheckForNull
    public static TagsAction getSyntheticStage(@Nullable FlowNode node) {
        if (node != null) {
            for (Action action : node.getActions()) {
                if (!(action instanceof TagsAction) || ((TagsAction)action).getTagValue("SYNTHETIC_STAGE") == null) continue;
                return (TagsAction)action;
            }
        }
        return null;
    }

    public static boolean isPostSyntheticStage(@Nullable FlowNode node) {
        if (node == null) {
            return false;
        }
        TagsAction tagsAction = PipelineNodeUtil.getSyntheticStage(node);
        if (tagsAction == null) {
            return false;
        }
        String value = tagsAction.getTagValue("SYNTHETIC_STAGE");
        return value != null && value.equals(SyntheticStage.getPost());
    }

    public static boolean isSkippedStage(@Nullable FlowNode node) {
        if (node == null) {
            return false;
        }
        for (Action action : node.getActions()) {
            if (!(action instanceof TagsAction) || ((TagsAction)action).getTagValue("STAGE_STATUS") == null) continue;
            TagsAction tagsAction = (TagsAction)action;
            String value = tagsAction.getTagValue("STAGE_STATUS");
            return value != null && (value.equals(StageStatus.getSkippedForConditional()) || value.equals(StageStatus.getSkippedForFailure()) || value.equals(StageStatus.getSkippedForUnstable()));
        }
        return false;
    }

    public static boolean isPreSyntheticStage(@Nullable FlowNode node) {
        if (node == null) {
            return false;
        }
        TagsAction tagsAction = PipelineNodeUtil.getSyntheticStage(node);
        if (tagsAction == null) {
            return false;
        }
        String value = tagsAction.getTagValue("SYNTHETIC_STAGE");
        return value != null && value.equals(SyntheticStage.getPre());
    }

    public static boolean isStartParallelBranch(@Nullable FlowNode node) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof StepStartNode)) {
            return false;
        }
        StepStartNode stepStartNode = (StepStartNode)node;
        if (!(stepStartNode.getDescriptor() instanceof ParallelStep.DescriptorImpl)) {
            return false;
        }
        ThreadNameAction threadNameAction = (ThreadNameAction)node.getPersistentAction(ThreadNameAction.class);
        return threadNameAction != null;
    }

    public static boolean isStartExecutorNode(@Nullable FlowNode node) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof StepStartNode)) {
            return false;
        }
        StepStartNode stepStartNode = (StepStartNode)node;
        if (!(stepStartNode.getDescriptor() instanceof ExecutorStep.DescriptorImpl)) {
            return false;
        }
        BodyInvocationAction bodyInvocationAction = (BodyInvocationAction)node.getAction(BodyInvocationAction.class);
        if (bodyInvocationAction != null) {
            LOGGER.log(Level.FINER, () -> "isStartNode(): false - " + PipelineNodeUtil.getDetailedDebugString(node));
            return false;
        }
        LOGGER.log(Level.FINE, () -> "isStartNode(): true - " + PipelineNodeUtil.getDetailedDebugString(node));
        return true;
    }

    public static boolean isStartParallelBlock(@Nullable FlowNode node) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof StepStartNode)) {
            return false;
        }
        StepStartNode stepStartNode = (StepStartNode)node;
        if (!(stepStartNode.getDescriptor() instanceof ParallelStep.DescriptorImpl)) {
            return false;
        }
        ThreadNameAction threadNameAction = (ThreadNameAction)node.getPersistentAction(ThreadNameAction.class);
        return threadNameAction == null;
    }

    public static boolean isEndParallelBlock(@Nullable FlowNode node) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof StepEndNode)) {
            return false;
        }
        StepEndNode stepEndNode = (StepEndNode)node;
        return PipelineNodeUtil.isStartParallelBlock((FlowNode)stepEndNode.getStartNode());
    }

    public static boolean isStartExecutorNodeExecution(@NonNull FlowNode node) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof StepStartNode)) {
            return false;
        }
        StepStartNode stepStartNode = (StepStartNode)node;
        if (!(stepStartNode.getDescriptor() instanceof ExecutorStep.DescriptorImpl)) {
            return false;
        }
        BodyInvocationAction bodyInvocationAction = (BodyInvocationAction)node.getAction(BodyInvocationAction.class);
        return bodyInvocationAction != null;
    }

    @NonNull
    public static String getDisplayName(@NonNull FlowNode node) {
        ThreadNameAction threadNameAction = (ThreadNameAction)node.getAction(ThreadNameAction.class);
        return threadNameAction != null ? threadNameAction.getThreadName() : node.getDisplayName();
    }

    @CheckForNull
    public static FlowNode getPreviousNode(@NonNull FlowNode node) {
        List parents = node.getParents();
        if (parents.size() > 1) {
            System.out.println(PipelineNodeUtil.getDetailedDebugString(node));
        }
        return (FlowNode)Iterables.getFirst((Iterable)parents, null);
    }

    @CheckForNull
    public static WorkflowRun getWorkflowRun(@NonNull FlowNode flowNode) {
        Queue.Executable executable;
        try {
            executable = flowNode.getExecution().getOwner().getExecutable();
        }
        catch (IOException e) {
            return null;
        }
        if (executable instanceof WorkflowRun) {
            return (WorkflowRun)executable;
        }
        return null;
    }

    @NonNull
    public static String getDebugString(@Nullable FlowNode flowNode) {
        if (flowNode == null) {
            return "#null#";
        }
        String value = "Node[" + flowNode.getDisplayFunctionName() + ", " + flowNode.getClass().getSimpleName();
        if (flowNode instanceof StepNode) {
            StepNode node = (StepNode)flowNode;
            StepDescriptor descriptor = node.getDescriptor();
            value = value + "descriptor: " + (descriptor == null ? "#null#" : descriptor.getClass().getName());
        }
        value = value + "actions: [" + flowNode.getActions().stream().map(action -> action.getClass().getSimpleName()).collect(Collectors.joining(",")) + "]";
        value = value + ", id: " + flowNode.getId() + "]";
        return value;
    }

    @NonNull
    public static String getDetailedDebugString(@Nullable FlowNode flowNode) {
        if (flowNode == null) {
            return "#null#";
        }
        String value = "Node[" + flowNode.getDisplayFunctionName() + ", id: " + flowNode.getId() + ", class: " + flowNode.getClass().getSimpleName() + ",";
        if (flowNode instanceof StepNode) {
            StepNode node = (StepNode)flowNode;
            StepDescriptor descriptor = node.getDescriptor();
            String descriptorClass = descriptor == null ? "#null#" : StringUtils.substringAfterLast((String)descriptor.getClass().getName(), (String)".");
            value = value + "descriptor: " + descriptorClass + ",";
        }
        if (flowNode instanceof StepEndNode) {
            StepEndNode o = (StepEndNode)flowNode;
            value = value + "startNode: [id:" + ((StepStartNode)o.getStartNode()).getId() + "],";
        }
        value = value + ", actions: [" + flowNode.getActions().stream().map(action -> action.getClass().getSimpleName()).collect(Collectors.joining(",")) + "]";
        value = value + "]";
        return value;
    }
}

