/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.jenkins;

import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Run;
import io.jenkins.plugins.opentelemetry.job.jenkins.PipelineListener;
import io.jenkins.plugins.opentelemetry.job.jenkins.PipelineNodeUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.workflow.actions.ArgumentsAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.flow.StepListener;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

@Extension
public class GraphListenerAdapterToPipelineListener
implements StepListener,
GraphListener.Synchronous {
    private static final Logger LOGGER = Logger.getLogger(GraphListenerAdapterToPipelineListener.class.getName());

    public final void onNewHead(FlowNode node) {
        WorkflowRun run = PipelineNodeUtil.getWorkflowRun(node);
        this.processPreviousNodes(node, run);
        this.processCurrentNode(node, run);
    }

    private void processPreviousNodes(FlowNode node, WorkflowRun run) {
        this.log(Level.FINE, () -> run.getFullDisplayName() + " - onNewHead - Process " + PipelineNodeUtil.getDetailedDebugString(node));
        for (FlowNode previousNode : node.getParents()) {
            this.log(Level.FINE, () -> run.getFullDisplayName() + " - Process previous node " + PipelineNodeUtil.getDetailedDebugString(previousNode) + " of node " + PipelineNodeUtil.getDetailedDebugString(node));
            if (previousNode instanceof StepAtomNode) {
                StepAtomNode stepAtomNode = (StepAtomNode)previousNode;
                this.fireOnAfterAtomicStep(stepAtomNode, node, run);
                continue;
            }
            if (this.isBeforeEndExecutorNodeStep(previousNode)) {
                String nodeName = PipelineNodeUtil.getDisplayName((FlowNode)((StepEndNode)previousNode).getStartNode());
                this.fireOnAfterEndNodeStep((StepEndNode)previousNode, nodeName, node, run);
                continue;
            }
            if (this.isBeforeEndStageStep(previousNode)) {
                String stageName = PipelineNodeUtil.getDisplayName((FlowNode)((StepEndNode)previousNode).getStartNode());
                this.fireOnAfterEndStageStep((StepEndNode)previousNode, stageName, node, run);
                continue;
            }
            if (this.isBeforeEndParallelBranch(previousNode)) {
                StepEndNode endParallelBranchNode = (StepEndNode)previousNode;
                StepStartNode beginParallelBranch = (StepStartNode)endParallelBranchNode.getStartNode();
                ThreadNameAction persistentAction = (ThreadNameAction)Verify.verifyNotNull((Object)((ThreadNameAction)beginParallelBranch.getPersistentAction(ThreadNameAction.class)), (String)"Null ThreadNameAction on %s", (Object[])new Object[]{beginParallelBranch});
                this.fireOnAfterEndParallelStepBranch(endParallelBranchNode, persistentAction.getThreadName(), node, run);
                continue;
            }
            if (this.isBeforeEndWithNewSpanStep(previousNode)) {
                this.fireOnAfterEndWithNewSpanStep((StepEndNode)previousNode, node, run);
                continue;
            }
            this.log(Level.FINE, () -> "Ignore previous node " + PipelineNodeUtil.getDetailedDebugString(previousNode));
        }
    }

    private void processCurrentNode(FlowNode node, WorkflowRun run) {
        if (node instanceof FlowStartNode) {
            this.fireOnStartPipeline((FlowStartNode)node, run);
        } else if (node instanceof FlowEndNode) {
            this.fireOnEndPipeline((FlowEndNode)node, run);
        } else if (node instanceof StepAtomNode) {
            this.fireOnBeforeAtomicStep((StepAtomNode)node, run);
        } else if (PipelineNodeUtil.isStartStage(node)) {
            String stageName = PipelineNodeUtil.getDisplayName(node);
            this.fireOnBeforeStartStageStep((StepStartNode)node, stageName, run);
        } else if (PipelineNodeUtil.isStartParallelBranch(node)) {
            ThreadNameAction persistentAction = (ThreadNameAction)Verify.verifyNotNull((Object)((ThreadNameAction)node.getPersistentAction(ThreadNameAction.class)), (String)"Null ThreadNameAction on %s", (Object[])new Object[]{node});
            this.fireOnBeforeStartParallelStepBranch((StepStartNode)node, persistentAction.getThreadName(), run);
        } else if (!PipelineNodeUtil.isStartParallelBlock(node) && !PipelineNodeUtil.isEndParallelBlock(node)) {
            if (PipelineNodeUtil.isStartExecutorNode(node)) {
                Map arguments = ArgumentsAction.getFilteredArguments((FlowNode)node);
                String label = Objects.toString(arguments.get("label"), null);
                this.fireOnStartNodeStep((StepStartNode)node, label, run);
            } else if (PipelineNodeUtil.isStartExecutorNodeExecution(node)) {
                Map arguments = ArgumentsAction.getFilteredArguments((FlowNode)node);
                String label = Objects.toString(arguments.get("label"), null);
                this.fireOnAfterStartNodeStep((StepStartNode)node, label, run);
            } else if (PipelineNodeUtil.isStartWithNewSpan(node)) {
                this.fireOnBeforeWithNewSpanStep((StepStartNode)node, run);
            } else {
                this.logFlowNodeDetails(node, run);
            }
        }
    }

    public void notifyOfNewStep(@NonNull Step step, @NonNull StepContext context) {
        try {
            Run run = (Run)context.get(Run.class);
            FlowNode flowNode = (FlowNode)context.get(FlowNode.class);
            Computer computer = (Computer)context.get(Computer.class);
            String computerHostname = computer == null ? "#null#" : computer.getHostName();
            String computerActions = computer == null ? "#null#" : computer.getAllActions().stream().map(action -> action.getClass().getSimpleName()).collect(Collectors.joining(", "));
            String computerName = computer == null ? "#null#" : computer.getName() + "/" + computer.getDisplayName();
            this.log(Level.FINE, () -> run.getFullDisplayName() + " - notifyOfNewStep - Process " + PipelineNodeUtil.getDetailedDebugString(flowNode) + " - computer[name: " + computerName + ", hostname: " + computerHostname + "," + computerActions + "]");
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void fireOnBeforeStartParallelStepBranch(@NonNull StepStartNode node, @NonNull String branchName, @NonNull WorkflowRun run) {
        for (PipelineListener pipelineListener : PipelineListener.all()) {
            this.log(Level.FINE, () -> "onBeforeStartParallelStepBranch(branchName: " + branchName + ", " + node.getDisplayName() + "): " + pipelineListener.toString());
            try {
                pipelineListener.onStartParallelStepBranch(node, branchName, run);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, e, () -> "Exception invoking `onBeforeStartParallelStepBranch` on " + String.valueOf(pipelineListener));
            }
        }
    }

    private void fireOnAfterEndParallelStepBranch(@NonNull StepEndNode node, @NonNull String branchName, FlowNode nextNode, @NonNull WorkflowRun run) {
        for (PipelineListener pipelineListener : PipelineListener.all()) {
            this.log(Level.FINE, () -> "onAfterEndParallelStepBranch(branchName: " + branchName + ", node[name:" + node.getDisplayName() + ", id: " + node.getId() + "]): " + pipelineListener.toString());
            try {
                pipelineListener.onEndParallelStepBranch(node, branchName, nextNode, run);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, e, () -> "Exception invoking `onAfterEndParallelStepBranch` on " + String.valueOf(pipelineListener));
            }
        }
    }

    private void logFlowNodeDetails(@NonNull FlowNode node, @NonNull WorkflowRun run) {
        this.log(Level.FINE, () -> {
            String message = run.getFullDisplayName() + " - before " + node.getDisplayFunctionName() + " // " + PipelineNodeUtil.getDisplayName(node) + ", ";
            if (node instanceof StepNode) {
                StepNode stepNode = (StepNode)node;
                StepDescriptor descriptor = stepNode.getDescriptor();
                message = message + "descriptor (class:" + descriptor.getClass().getName() + ", " + descriptor.getFunctionName() + "), ";
            }
            message = message + node.getAllActions().stream().map(action -> Objects.toString(action.getDisplayName(), action.getClass().toString())).collect(Collectors.joining(", "));
            message = message + ", node.parent: " + String.valueOf(Iterables.getFirst((Iterable)node.getParents(), null));
            return message;
        });
    }

    public void fireOnAfterAtomicStep(@NonNull StepAtomNode stepAtomNode, FlowNode nextNode, @NonNull WorkflowRun run) {
        for (PipelineListener pipelineListener : PipelineListener.all()) {
            this.log(() -> "onAfterAtomicStep(" + stepAtomNode.getDisplayName() + "): " + pipelineListener.toString());
            try {
                pipelineListener.onAfterAtomicStep(stepAtomNode, nextNode, run);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, e, () -> "Exception invoking `onAfterAtomicStep` on " + String.valueOf(pipelineListener));
            }
        }
    }

    public void fireOnEndPipeline(@NonNull FlowEndNode node, @NonNull WorkflowRun run) {
        for (PipelineListener pipelineListener : PipelineListener.all()) {
            this.log(() -> "onEndPipeline(" + node.getDisplayName() + "): " + pipelineListener.toString());
            try {
                pipelineListener.onEndPipeline((FlowNode)node, run);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, e, () -> "Exception invoking `onEndPipeline` on " + String.valueOf(pipelineListener));
            }
        }
    }

    public void fireOnStartPipeline(@NonNull FlowStartNode node, @NonNull WorkflowRun run) {
        for (PipelineListener pipelineListener : PipelineListener.all()) {
            this.log(() -> "onStartPipeline(" + node.getDisplayName() + ") run " + run.getFullDisplayName() + ", pipelineListenerStep:" + pipelineListener.toString());
            try {
                pipelineListener.onStartPipeline((FlowNode)node, run);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, e, () -> "Exception invoking `onStartPipeline` on " + String.valueOf(pipelineListener));
            }
        }
    }

    public void fireOnAfterEndNodeStep(@NonNull StepEndNode node, @NonNull String nodeName, FlowNode nextNode, @NonNull WorkflowRun run) {
        for (PipelineListener pipelineListener : PipelineListener.all()) {
            this.log(() -> "onAfterEndNodeStep(" + node.getDisplayName() + "): " + pipelineListener.toString() + (String)(node.getError() != null ? "error: " + String.valueOf(node.getError().getError()) : ""));
            try {
                pipelineListener.onEndNodeStep(node, nodeName, nextNode, run);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, e, () -> "Exception invoking `onAfterEndNodeStep` on " + String.valueOf(pipelineListener));
            }
        }
    }

    public void fireOnAfterEndStageStep(@NonNull StepEndNode node, @NonNull String stageName, FlowNode nextNode, @NonNull WorkflowRun run) {
        for (PipelineListener pipelineListener : PipelineListener.all()) {
            this.log(() -> "onAfterEndStageStep(" + node.getDisplayName() + "): " + pipelineListener.toString() + (String)(node.getError() != null ? "error: " + String.valueOf(node.getError().getError()) : ""));
            try {
                pipelineListener.onEndStageStep(node, stageName, nextNode, run);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, e, () -> "Exception invoking `onAfterEndStageStep` on " + String.valueOf(pipelineListener));
            }
        }
    }

    public void fireOnBeforeWithNewSpanStep(@NonNull StepStartNode node, @NonNull WorkflowRun run) {
        for (PipelineListener pipelineListener : PipelineListener.all()) {
            this.log(() -> "onBeforeWithNewSpanStep(" + node.getDisplayName() + "): " + pipelineListener.toString());
            try {
                pipelineListener.onStartWithNewSpanStep(node, run);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, e, () -> "Exception invoking `onBeforeWithNewSpanStep` on " + String.valueOf(pipelineListener));
            }
        }
    }

    public void fireOnAfterEndWithNewSpanStep(@NonNull StepEndNode node, FlowNode nextNode, @NonNull WorkflowRun run) {
        for (PipelineListener pipelineListener : PipelineListener.all()) {
            this.log(() -> "onAfterEndWithNewSpanStep(" + node.getDisplayName() + "): " + pipelineListener.toString() + (String)(node.getError() != null ? "error: " + String.valueOf(node.getError().getError()) : ""));
            try {
                pipelineListener.onEndWithNewSpanStep(node, nextNode, run);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, e, () -> "Exception invoking `onAfterEndWithNewSpanStep` on " + String.valueOf(pipelineListener));
            }
        }
    }

    public void fireOnBeforeAtomicStep(@NonNull StepAtomNode node, @NonNull WorkflowRun run) {
        for (PipelineListener pipelineListener : PipelineListener.all()) {
            this.log(() -> "onBeforeAtomicStep(" + node.getDisplayName() + "): " + pipelineListener.toString());
            try {
                pipelineListener.onAtomicStep(node, run);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, e, () -> "Exception invoking `onBeforeAtomicStep` on " + String.valueOf(pipelineListener));
            }
        }
    }

    public void fireOnStartNodeStep(@NonNull StepStartNode node, @NonNull String nodeLabel, @NonNull WorkflowRun run) {
        for (PipelineListener pipelineListener : PipelineListener.all()) {
            this.log(() -> "onStartNodeStep(" + node.getDisplayName() + "): " + pipelineListener.toString());
            try {
                pipelineListener.onStartNodeStep(node, nodeLabel, run);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, e, () -> "Exception invoking `onStartNodeStep` on " + String.valueOf(pipelineListener));
            }
        }
    }

    public void fireOnAfterStartNodeStep(@NonNull StepStartNode node, @NonNull String nodeLabel, @NonNull WorkflowRun run) {
        for (PipelineListener pipelineListener : PipelineListener.all()) {
            this.log(() -> "onAfterStartNodeStep(" + node.getDisplayName() + "): " + pipelineListener.toString());
            try {
                pipelineListener.onAfterStartNodeStep(node, nodeLabel, run);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, e, () -> "Exception invoking `onAfterStartNodeStep` on " + String.valueOf(pipelineListener));
            }
        }
    }

    public void fireOnBeforeStartStageStep(@NonNull StepStartNode node, @NonNull String stageName, @NonNull WorkflowRun run) {
        for (PipelineListener pipelineListener : PipelineListener.all()) {
            this.log(() -> "onBeforeStartStageStep(" + node.getDisplayName() + "): " + pipelineListener.toString());
            try {
                pipelineListener.onStartStageStep(node, stageName, run);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, e, () -> "Exception invoking `onBeforeStartStageStep` on " + String.valueOf(pipelineListener));
            }
        }
    }

    private boolean isBeforeEndExecutorNodeStep(@NonNull FlowNode node) {
        return node instanceof StepEndNode && PipelineNodeUtil.isStartExecutorNode((FlowNode)((StepEndNode)node).getStartNode());
    }

    private boolean isBeforeEndStageStep(@NonNull FlowNode node) {
        return node instanceof StepEndNode && PipelineNodeUtil.isStartStage((FlowNode)((StepEndNode)node).getStartNode());
    }

    private boolean isBeforeEndParallelBranch(@NonNull FlowNode node) {
        return node instanceof StepEndNode && PipelineNodeUtil.isStartParallelBranch((FlowNode)((StepEndNode)node).getStartNode());
    }

    private boolean isBeforeEndWithNewSpanStep(@NonNull FlowNode node) {
        return node instanceof StepEndNode && PipelineNodeUtil.isStartWithNewSpan((FlowNode)((StepEndNode)node).getStartNode());
    }

    protected void log(@NonNull Supplier<String> message) {
        this.log(Level.FINE, message);
    }

    protected void log(@NonNull Level level, @NonNull Supplier<String> message) {
        LOGGER.log(level, message);
    }
}

