/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job;

import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Run;
import hudson.tasks.BuildStep;
import io.jenkins.plugins.opentelemetry.OpenTelemetryAttributesAction;
import io.jenkins.plugins.opentelemetry.OtelUtils;
import io.jenkins.plugins.opentelemetry.job.MonitoringAction;
import io.jenkins.plugins.opentelemetry.job.action.AbstractMonitoringAction;
import io.jenkins.plugins.opentelemetry.job.action.BuildStepMonitoringAction;
import io.jenkins.plugins.opentelemetry.job.action.FlowNodeMonitoringAction;
import io.jenkins.plugins.opentelemetry.job.action.OtelMonitoringAction;
import io.jenkins.plugins.opentelemetry.job.action.RunPhaseMonitoringAction;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.AtomNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStep;

@Extension
public class OtelTraceService {
    private static final Logger LOGGER = Logger.getLogger(OtelTraceService.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean STRICT_MODE = false;

    public Span getSpan(@NonNull Run<?, ?> run) {
        return ImmutableList.copyOf((Collection)run.getActions(RunPhaseMonitoringAction.class)).reverse().stream().filter(Predicate.not(AbstractMonitoringAction::hasEnded)).findFirst().map(AbstractMonitoringAction::getSpan).orElse(Span.getInvalid());
    }

    @NonNull
    public Span getPipelineRootSpan(@NonNull Run<?, ?> run) {
        return run.getActions(MonitoringAction.class).stream().findFirst().map(AbstractMonitoringAction::getSpan).orElse(Span.getInvalid());
    }

    @NonNull
    public Span getSpan(@NonNull Run<?, ?> run, FlowNode flowNode) {
        Iterable<FlowNode> ancestors = this.getAncestors(flowNode);
        for (FlowNode currentFlowNode : ancestors) {
            Optional<Span> span = ImmutableList.copyOf((Collection)currentFlowNode.getActions(FlowNodeMonitoringAction.class)).reverse().stream().filter(Predicate.not(AbstractMonitoringAction::hasEnded)).findFirst().map(AbstractMonitoringAction::getSpan);
            if (!span.isPresent()) continue;
            return span.get();
        }
        return this.getSpan(run);
    }

    @NonNull
    public Span getSpan(@NonNull AbstractBuild<?, ?> build, @NonNull BuildStep buildStep) {
        return ImmutableList.copyOf((Collection)build.getActions(BuildStepMonitoringAction.class)).reverse().stream().filter(Predicate.not(AbstractMonitoringAction::hasEnded)).findFirst().map(AbstractMonitoringAction::getSpan).orElseGet(() -> this.getSpan((Run<?, ?>)build));
    }

    @NonNull
    private Iterable<FlowNode> getAncestors(@NonNull FlowNode flowNode) {
        ArrayList<FlowNode> ancestors = new ArrayList<FlowNode>();
        Object startNode = flowNode instanceof StepEndNode ? ((StepEndNode)flowNode).getStartNode() : flowNode;
        ancestors.add((FlowNode)startNode);
        ancestors.addAll(startNode.getEnclosingBlocks());
        LOGGER.log(Level.FINEST, () -> "getAncestors(" + OtelUtils.toDebugString(flowNode) + "): " + ancestors.stream().map(OtelUtils.flowNodeToDebugString()).collect(Collectors.joining(", ")));
        return ancestors;
    }

    public void removePipelineStepSpanAndCloseAssociatedScopes(@NonNull WorkflowRun run, @NonNull FlowNode flowNode, @NonNull Span span) {
        FlowNode startSpanNode;
        if (flowNode instanceof AtomNode) {
            startSpanNode = flowNode;
        } else if (flowNode instanceof StepEndNode) {
            StepEndNode stepEndNode = (StepEndNode)flowNode;
            startSpanNode = stepEndNode.getStartNode();
        } else if (flowNode instanceof StepStartNode && ((StepStartNode)flowNode).getDescriptor() instanceof ExecutorStep.DescriptorImpl) {
            startSpanNode = flowNode.getParents().stream().findFirst().orElse(null);
            if (startSpanNode == null) {
                if (STRICT_MODE) {
                    throw new IllegalStateException("Parent node NOT found for " + OtelUtils.toDebugString(flowNode) + " on " + String.valueOf(run));
                }
                LOGGER.log(Level.WARNING, () -> "Parent node NOT found for " + OtelUtils.toDebugString(flowNode) + " on " + String.valueOf(run));
                return;
            }
        } else {
            throw new VerifyException("Can't remove span from node of type" + String.valueOf(flowNode.getClass()) + " - " + String.valueOf(flowNode));
        }
        ImmutableList.copyOf((Collection)startSpanNode.getActions(FlowNodeMonitoringAction.class)).reverse().stream().filter(flowNodeMonitoringAction -> Objects.equals(flowNodeMonitoringAction.getSpanId(), span.getSpanContext().getSpanId())).findFirst().ifPresentOrElse(AbstractMonitoringAction::purgeSpanAndCloseAssociatedScopes, () -> {
            if (!Objects.equals(span, Span.getInvalid())) {
                String msg = "span not found to be purged: " + OtelUtils.toDebugString(span) + " ending " + OtelUtils.toDebugString(startSpanNode) + " in " + String.valueOf(run);
                if (STRICT_MODE) {
                    throw new IllegalStateException(msg);
                }
                LOGGER.log(Level.WARNING, msg);
            }
        });
    }

    public void removeJobPhaseSpan(@NonNull Run<?, ?> run, @NonNull Span span) {
    }

    public void removeBuildStepSpan(@NonNull AbstractBuild<?, ?> build, @NonNull BuildStep buildStep, @NonNull Span span) {
        ImmutableList.copyOf((Collection)build.getActions(BuildStepMonitoringAction.class)).reverse().stream().filter(buildStepMonitoringAction -> Objects.equals(buildStepMonitoringAction.getSpanId(), span.getSpanContext().getSpanId())).findFirst().ifPresentOrElse(AbstractMonitoringAction::purgeSpanAndCloseAssociatedScopes, () -> {
            if (!Objects.equals(span, Span.getInvalid())) {
                throw new IllegalStateException("span not found to be purged: " + String.valueOf(span) + " for " + String.valueOf(buildStep));
            }
        });
    }

    public void purgeRun(@NonNull Run<?, ?> run) {
        run.getActions(OtelMonitoringAction.class).forEach(OtelMonitoringAction::purgeSpanAndCloseAssociatedScopes);
        if (run instanceof WorkflowRun) {
            WorkflowRun workflowRun = (WorkflowRun)run;
            List flowNodesHeads = Optional.ofNullable(workflowRun.getExecution()).map(FlowExecution::getCurrentHeads).orElse(Collections.emptyList());
            ForkScanner scanner = new ForkScanner();
            scanner.setup(flowNodesHeads);
            StreamSupport.stream(scanner.spliterator(), false).forEach(flowNode -> flowNode.getActions(OtelMonitoringAction.class).forEach(OtelMonitoringAction::purgeSpanAndCloseAssociatedScopes));
        }
    }

    public void putSpan(@NonNull AbstractBuild<?, ?> build, @NonNull Span span) {
        build.addAction((Action)new MonitoringAction(span));
        LOGGER.log(Level.FINEST, () -> "putSpan(" + build.getFullDisplayName() + "," + OtelUtils.toDebugString(span) + ")");
    }

    public void putSpan(AbstractBuild<?, ?> build, BuildStep buildStep, Span span) {
        build.addAction((Action)new BuildStepMonitoringAction(span));
        LOGGER.log(Level.FINEST, () -> "putSpan(" + build.getFullDisplayName() + ", " + String.valueOf(buildStep) + "," + OtelUtils.toDebugString(span) + ")");
    }

    public void putSpan(@NonNull Run<?, ?> run, @NonNull Span span) {
        run.addAction((Action)new MonitoringAction(span));
        LOGGER.log(Level.FINEST, () -> "putSpan(" + run.getFullDisplayName() + "," + OtelUtils.toDebugString(span) + ")");
    }

    public void putRunPhaseSpan(@NonNull Run<?, ?> run, @NonNull Span span) {
        run.addAction((Action)new RunPhaseMonitoringAction(span));
        this.setAttributesToSpan(span, (OpenTelemetryAttributesAction)run.getAction(OpenTelemetryAttributesAction.class));
        LOGGER.log(Level.FINEST, () -> "putRunPhaseSpan(" + run.getFullDisplayName() + "," + OtelUtils.toDebugString(span) + ")");
    }

    public void putAgentSpan(@NonNull Run<?, ?> run, @NonNull Span span, @NonNull FlowNode flowNode) {
        this.setAttributesToSpan(span, (OpenTelemetryAttributesAction)run.getAction(OpenTelemetryAttributesAction.class));
        this.putSpan(run, span, flowNode);
        LOGGER.log(Level.FINEST, () -> "putAgentSpan(" + run.getFullDisplayName() + "," + OtelUtils.toDebugString(span) + ")");
    }

    public void putSpan(@NonNull Run<?, ?> run, @NonNull Span span, @NonNull FlowNode flowNode) {
        flowNode.addAction((Action)new FlowNodeMonitoringAction(span));
        LOGGER.log(Level.FINE, () -> "putSpan(" + run.getFullDisplayName() + ", " + OtelUtils.toDebugString(flowNode) + ", " + OtelUtils.toDebugString(span) + ")");
    }

    public void putSpanAndScopes(@NonNull Run<?, ?> run, @NonNull Span span, @NonNull FlowNode flowNode, List<Scope> scopes) {
        flowNode.addAction((Action)new FlowNodeMonitoringAction(span, scopes));
        LOGGER.log(Level.FINE, () -> "putSpan(" + run.getFullDisplayName() + ", " + OtelUtils.toDebugString(flowNode) + ", " + OtelUtils.toDebugString(span) + ")");
    }

    private void setAttributesToSpan(@NonNull Span span, OpenTelemetryAttributesAction openTelemetryAttributesAction) {
        if (openTelemetryAttributesAction == null) {
            return;
        }
        for (Map.Entry<AttributeKey<?>, Object> entry : openTelemetryAttributesAction.getAttributes().entrySet()) {
            AttributeKey<?> attributeKey = entry.getKey();
            Object value = Verify.verifyNotNull((Object)entry.getValue());
            span.setAttribute(attributeKey, value);
        }
    }

    public static OtelTraceService get() {
        return (OtelTraceService)ExtensionList.lookupSingleton(OtelTraceService.class);
    }
}

