/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.opentelemetry.job.OtelEnvironmentContributorService;
import io.jenkins.plugins.opentelemetry.job.OtelTraceService;
import javax.inject.Inject;

@Extension
public class OtelEnvironmentContributor
extends EnvironmentContributor {
    private OtelEnvironmentContributorService otelEnvironmentContributorService;
    private OtelTraceService otelTraceService;

    public void buildEnvironmentFor(@NonNull Run run, @NonNull EnvVars envs, @NonNull TaskListener listener) {
        this.otelEnvironmentContributorService.addEnvironmentVariables(run, envs, this.otelTraceService.getSpan(run));
    }

    @Inject
    public void setOtelTraceService(OtelTraceService otelTraceService) {
        this.otelTraceService = otelTraceService;
    }

    @Inject
    public void setEnvironmentContributorService(OtelEnvironmentContributorService otelEnvironmentContributorService) {
        this.otelEnvironmentContributorService = otelEnvironmentContributorService;
    }
}

