/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import io.jenkins.plugins.opentelemetry.OtelUtils;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.jenkins.plugins.opentelemetry.job.MonitoringAction;
import io.jenkins.plugins.opentelemetry.job.cause.CauseHandler;
import io.jenkins.plugins.opentelemetry.job.opentelemetry.OtelContextAwareAbstractRunListener;
import io.jenkins.plugins.opentelemetry.job.runhandler.RunHandler;
import io.jenkins.plugins.opentelemetry.queue.RemoteSpanAction;
import io.jenkins.plugins.opentelemetry.semconv.ConfigurationKey;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.TraceStateBuilder;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.semconv.ExceptionAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import jenkins.YesNoMaybe;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildUpstreamCause;

@Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
public class MonitoringRunListener
extends OtelContextAwareAbstractRunListener
implements OpenTelemetryLifecycleListener {
    static final Pattern MATCH_ANYTHING = Pattern.compile(".*");
    static final Pattern MATCH_NOTHING = Pattern.compile("$^");
    static final List<Double> DURATION_SECONDS_BUCKETS = Collections.unmodifiableList(Arrays.asList(1.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0, 128.0, 256.0, 512.0, 1024.0, 2048.0, 4096.0, 8192.0));
    protected static final Logger LOGGER = Logger.getLogger(MonitoringRunListener.class.getName());
    private AtomicInteger activeRunGauge;
    private List<CauseHandler> causeHandlers;
    private DoubleHistogram runDurationHistogram;
    private LongCounter runLaunchedCounter;
    private LongCounter runStartedCounter;
    private LongCounter runCompletedCounter;
    private LongCounter runAbortedCounter;
    private LongCounter runSuccessCounter;
    private LongCounter runFailedCounter;
    private List<RunHandler> runHandlers;
    @VisibleForTesting
    Pattern runDurationHistogramAllowList;
    @VisibleForTesting
    Pattern runDurationHistogramDenyList;

    @PostConstruct
    public void postConstruct() {
        LOGGER.log(Level.FINE, () -> "Start monitoring Jenkins build executions...");
        Meter meter = this.getMeter();
        ConfigProperties configProperties = this.getConfigProperties();
        ArrayList<CauseHandler> causeHandlers = new ArrayList<CauseHandler>((Collection<CauseHandler>)ExtensionList.lookup(CauseHandler.class));
        causeHandlers.forEach(causeHandler -> causeHandler.configure(configProperties));
        Collections.sort(causeHandlers);
        this.causeHandlers = causeHandlers;
        ArrayList<RunHandler> runHandlers = new ArrayList<RunHandler>((Collection<RunHandler>)ExtensionList.lookup(RunHandler.class));
        runHandlers.forEach(runHandler -> runHandler.configure(configProperties));
        Collections.sort(runHandlers);
        this.runHandlers = runHandlers;
        this.activeRunGauge = new AtomicInteger();
        this.runDurationHistogram = meter.histogramBuilder("ci.pipeline.run.duration").setUnit("s").setExplicitBucketBoundariesAdvice(DURATION_SECONDS_BUCKETS).build();
        this.runDurationHistogramAllowList = MATCH_ANYTHING;
        this.runDurationHistogramDenyList = MATCH_NOTHING;
        meter.gaugeBuilder("ci.pipeline.run.active").ofLongs().setDescription("Gauge of active jobs").setUnit("{jobs}").buildWithCallback(valueObserver -> valueObserver.record((long)this.activeRunGauge.get()));
        this.runLaunchedCounter = meter.counterBuilder("ci.pipeline.run.launched").setDescription("Job launched").setUnit("{jobs}").build();
        this.runStartedCounter = meter.counterBuilder("ci.pipeline.run.started").setDescription("Job started").setUnit("{jobs}").build();
        this.runSuccessCounter = meter.counterBuilder("ci.pipeline.run.success").setDescription("Job succeed").setUnit("{jobs}").build();
        this.runFailedCounter = meter.counterBuilder("ci.pipeline.run.failed").setDescription("Job failed").setUnit("{jobs}").build();
        this.runAbortedCounter = meter.counterBuilder("ci.pipeline.run.aborted").setDescription("Job aborted").setUnit("{jobs}").build();
        this.runCompletedCounter = meter.counterBuilder("ci.pipeline.run.completed").setDescription("Job completed").setUnit("{jobs}").build();
    }

    public void afterConfiguration(ConfigProperties configProperties) {
        Pattern newRunDurationHistogramDenyList;
        Pattern newRunDurationHistogramAllowList;
        try {
            newRunDurationHistogramAllowList = Optional.ofNullable(configProperties.getString(ConfigurationKey.OTEL_INSTRUMENTATION_JENKINS_RUN_DURATION_ALLOW_LIST.asProperty())).map(Pattern::compile).orElse(MATCH_NOTHING);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid regex for '" + ConfigurationKey.OTEL_INSTRUMENTATION_JENKINS_RUN_DURATION_ALLOW_LIST.asProperty() + "'", e);
        }
        try {
            newRunDurationHistogramDenyList = Optional.ofNullable(configProperties.getString(ConfigurationKey.OTEL_INSTRUMENTATION_JENKINS_RUN_DURATION_DENY_LIST.asProperty())).map(Pattern::compile).orElse(MATCH_NOTHING);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid regex for '" + ConfigurationKey.OTEL_INSTRUMENTATION_JENKINS_RUN_DURATION_DENY_LIST.asProperty() + "'", e);
        }
        this.runDurationHistogramAllowList = newRunDurationHistogramAllowList;
        this.runDurationHistogramDenyList = newRunDurationHistogramDenyList;
    }

    @NonNull
    public List<CauseHandler> getCauseHandlers() {
        return (List)Preconditions.checkNotNull(this.causeHandlers);
    }

    @NonNull
    public CauseHandler getCauseHandler(@NonNull Cause cause) throws NoSuchElementException {
        return this.getCauseHandlers().stream().filter(ch -> ch.isSupported(cause)).findFirst().orElseThrow();
    }

    @Override
    public void _onInitialize(@NonNull Run<?, ?> run) {
        ParametersAction parameters;
        LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - onInitialize");
        this.activeRunGauge.incrementAndGet();
        RunHandler runHandler = this.getRunHandlers().stream().filter(rh -> rh.canCreateSpanBuilder(run)).findFirst().orElseThrow(() -> new IllegalStateException("No RunHandler found for run " + String.valueOf(run.getClass()) + " - " + String.valueOf(run)));
        SpanBuilder rootSpanBuilder = runHandler.createSpanBuilder(run, this.getTracer());
        rootSpanBuilder.setSpanKind(SpanKind.SERVER);
        String runUrl = Objects.toString(Jenkins.get().getRootUrl(), "") + run.getUrl();
        rootSpanBuilder.setAttribute(ExtendedJenkinsAttributes.ELASTIC_TRANSACTION_TYPE, (Object)"job");
        rootSpanBuilder.setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_ID, (Object)run.getParent().getFullName()).setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_NAME, (Object)run.getParent().getFullDisplayName()).setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_URL, (Object)runUrl).setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_NUMBER, (Object)run.getNumber()).setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_TYPE, (Object)OtelUtils.getProjectType(run));
        Set culpritIds = run instanceof WorkflowRun ? ((WorkflowRun)run).getCulprits() : (run instanceof AbstractBuild ? ((AbstractBuild)run).getCulprits() : null);
        if (culpritIds != null) {
            rootSpanBuilder.setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_COMMITTERS, culpritIds.stream().map(User::getId).collect(Collectors.toList()));
        }
        if ((parameters = (ParametersAction)run.getAction(ParametersAction.class)) != null) {
            ArrayList<String> parameterNames = new ArrayList<String>();
            ArrayList<Boolean> parameterIsSensitive = new ArrayList<Boolean>();
            ArrayList<String> nonNullParameterValues = new ArrayList<String>();
            for (ParameterValue parameter : parameters.getParameters()) {
                parameterNames.add(Objects.toString(parameter.getName(), "#NULL#"));
                parameterIsSensitive.add(parameter.isSensitive());
                if (parameter.isSensitive()) {
                    nonNullParameterValues.add("#REDACTED#");
                    continue;
                }
                nonNullParameterValues.add(Objects.toString(parameter.getValue(), "#NULL#"));
            }
            rootSpanBuilder.setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_PARAMETER_NAME, parameterNames);
            rootSpanBuilder.setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_PARAMETER_IS_SENSITIVE, parameterIsSensitive);
            rootSpanBuilder.setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_PARAMETER_VALUE, nonNullParameterValues);
        }
        Optional.ofNullable((RemoteSpanAction)run.getAction(RemoteSpanAction.class)).filter(r -> r.getTraceId() != null && r.getSpanId() != null).ifPresent(action -> {
            TraceStateBuilder traceStateBuilder = TraceState.builder();
            Map<String, String> traceStateMap = action.getTraceStateMap();
            traceStateMap.forEach((arg_0, arg_1) -> ((TraceStateBuilder)traceStateBuilder).put(arg_0, arg_1));
            SpanContext spanContext = SpanContext.createFromRemoteParent((String)action.getTraceId(), (String)action.getSpanId(), (TraceFlags)TraceFlags.fromByte((byte)action.getTraceFlagsAsByte()), (TraceState)traceStateBuilder.build());
            Context context = Context.current().with((ImplicitContextKeyed)Span.wrap((SpanContext)spanContext));
            rootSpanBuilder.setParent(context);
        });
        List causesDescriptions = run.getCauses().stream().map(c -> this.getCauseHandler((Cause)c).getStructuredDescription((Cause)c)).collect(Collectors.toList());
        rootSpanBuilder.setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_CAUSE, causesDescriptions);
        Optional optCause = run.getCauses().stream().findFirst();
        optCause.ifPresent(cause -> {
            Cause.UpstreamCause upstreamCause;
            Run upstreamRun;
            if (cause instanceof Cause.UpstreamCause && (upstreamRun = (upstreamCause = (Cause.UpstreamCause)cause).getUpstreamRun()) != null) {
                Map<Object, Object> w3cTraceContext;
                MonitoringAction monitoringAction = (MonitoringAction)upstreamRun.getAction(MonitoringAction.class);
                if (monitoringAction == null) {
                    w3cTraceContext = Collections.emptyMap();
                } else if (upstreamCause instanceof BuildUpstreamCause) {
                    BuildUpstreamCause buildUpstreamCause = (BuildUpstreamCause)cause;
                    String upstreamNodeId = buildUpstreamCause.getNodeId();
                    w3cTraceContext = monitoringAction.getW3cTraceContext(upstreamNodeId);
                } else {
                    w3cTraceContext = monitoringAction.getW3cTraceContext();
                }
                Context context = W3CTraceContextPropagator.getInstance().extract(Context.current(), w3cTraceContext, (TextMapGetter)new TextMapGetter<Map<String, String>>(){

                    public Iterable<String> keys(Map<String, String> carrier) {
                        return carrier.keySet();
                    }

                    @Nullable
                    public String get(@Nullable Map<String, String> carrier, String key) {
                        return carrier == null ? null : carrier.get(key);
                    }
                });
                rootSpanBuilder.setParent(context);
            }
        });
        Span rootSpan = rootSpanBuilder.startSpan();
        this.getTraceService().putSpan(run, rootSpan);
        try (Scope rootSpanScope = rootSpan.makeCurrent();){
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - begin root " + OtelUtils.toDebugString(rootSpan));
            Span startSpan = this.getTracer().spanBuilder("Phase: Start").setParent(Context.current().with((ImplicitContextKeyed)rootSpan)).startSpan();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - begin " + OtelUtils.toDebugString(startSpan));
            this.getTraceService().putRunPhaseSpan(run, startSpan);
            try (Scope startSpanScope = startSpan.makeCurrent();){
                this.runLaunchedCounter.add(1L);
            }
        }
    }

    @Override
    public void _onStarted(@NonNull Run<?, ?> run, @NonNull TaskListener listener) {
        try (Scope parentScope = this.endPipelinePhaseSpan(run);){
            Span runSpan = this.getTracer().spanBuilder("Phase: Run").setParent(Context.current()).startSpan();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - begin " + OtelUtils.toDebugString(runSpan));
            try (Scope scope = runSpan.makeCurrent();){
                this.getTraceService().putRunPhaseSpan(run, runSpan);
                this.runStartedCounter.add(1L);
            }
        }
    }

    @Override
    public void _onCompleted(@NonNull Run<?, ?> run, @NonNull TaskListener listener) {
        try (Scope ignoredParentScope = this.endPipelinePhaseSpan(run);){
            Span finalizeSpan = this.getTracer().spanBuilder("Phase: Finalise").setParent(Context.current()).startSpan();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - begin " + OtelUtils.toDebugString(finalizeSpan));
            try (Scope ignored = finalizeSpan.makeCurrent();){
                this.getTraceService().putRunPhaseSpan(run, finalizeSpan);
            }
        }
    }

    @MustBeClosed
    @NonNull
    protected Scope endPipelinePhaseSpan(@NonNull Run<?, ?> run) {
        Span pipelinePhaseSpan = (Span)Verify.verifyNotNull((Object)Span.current(), (String)"No pipelinePhaseSpan found in context", (Object[])new Object[0]);
        pipelinePhaseSpan.end();
        LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - end " + OtelUtils.toDebugString(pipelinePhaseSpan));
        this.getTraceService().removeJobPhaseSpan(run, pipelinePhaseSpan);
        Span newCurrentSpan = this.getTraceService().getPipelineRootSpan(run);
        return newCurrentSpan.makeCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _onFinalized(@NonNull Run<?, ?> run) {
        try (Scope ignoredParentScope = this.endPipelinePhaseSpan(run);){
            Node node;
            Result runResult;
            Span parentSpan = Span.current();
            parentSpan.setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_DURATION_MILLIS, (Object)run.getDuration());
            String description = run.getDescription();
            if (description != null) {
                parentSpan.setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_DESCRIPTION, (Object)description);
            }
            if (OtelUtils.isMultibranch(run)) {
                parentSpan.setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_MULTIBRANCH_TYPE, (Object)OtelUtils.getMultibranchType(run));
            }
            if ((runResult = run.getResult()) == null) {
                parentSpan.setStatus(StatusCode.UNSET);
            } else {
                parentSpan.setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_COMPLETED, (Object)runResult.completeBuild);
                parentSpan.setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_RESULT, (Object)Objects.toString(runResult, null));
                if (Result.SUCCESS.equals(runResult)) {
                    parentSpan.setStatus(StatusCode.OK, runResult.toString());
                } else if (Result.FAILURE.equals(runResult) || Result.UNSTABLE.equals(runResult)) {
                    parentSpan.setAttribute(ExceptionAttributes.EXCEPTION_TYPE, (Object)("PIPELINE_" + String.valueOf(runResult)));
                    parentSpan.setAttribute(ExceptionAttributes.EXCEPTION_MESSAGE, (Object)("PIPELINE_" + String.valueOf(runResult)));
                    parentSpan.setStatus(StatusCode.ERROR, runResult.toString());
                } else if (Result.ABORTED.equals(runResult) || Result.NOT_BUILT.equals(runResult)) {
                    parentSpan.setStatus(StatusCode.UNSET, runResult.toString());
                }
            }
            if (run instanceof AbstractBuild && (node = ((AbstractBuild)run).getBuiltOn()) != null) {
                parentSpan.setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_AGENT_LABEL, (Object)node.getLabelString());
                parentSpan.setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_AGENT_ID, (Object)node.getNodeName());
                parentSpan.setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_AGENT_NAME, (Object)node.getDisplayName());
            }
            parentSpan.end();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - end " + OtelUtils.toDebugString(parentSpan));
            this.getTraceService().removeJobPhaseSpan(run, parentSpan);
            this.getTraceService().purgeRun(run);
            Result result = (Result)Verify.verifyNotNull((Object)run.getResult(), (String)"%s", (Object[])new Object[]{run});
            if (result.isCompleteBuild()) {
                LOGGER.log(Level.FINE, () -> "Increment completion counters");
                this.runCompletedCounter.add(1L);
                if (result.equals(Result.SUCCESS)) {
                    this.runSuccessCounter.add(1L);
                } else {
                    this.runFailedCounter.add(1L);
                }
            } else {
                this.runAbortedCounter.add(1L);
            }
            String jobFullName = run.getParent().getFullName();
            String pipelineId = this.runDurationHistogramAllowList.matcher(jobFullName).matches() && !this.runDurationHistogramDenyList.matcher(jobFullName).matches() ? jobFullName : "#other#";
            this.runDurationHistogram.record((double)TimeUnit.SECONDS.convert(run.getDuration(), TimeUnit.MILLISECONDS), Attributes.of(ExtendedJenkinsAttributes.CI_PIPELINE_ID, (Object)pipelineId, ExtendedJenkinsAttributes.CI_PIPELINE_RUN_RESULT, (Object)result.toString()));
        }
        finally {
            this.activeRunGauge.decrementAndGet();
        }
    }

    @NonNull
    protected List<RunHandler> getRunHandlers() {
        return (List)Preconditions.checkNotNull(this.runHandlers);
    }
}

