/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.jenkins;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.remoting.DelegatingCallable;
import io.jenkins.plugins.opentelemetry.JenkinsOpenTelemetryPluginConfiguration;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.jenkins.plugins.opentelemetry.opentelemetry.GlobalOpenTelemetrySdk;
import io.jenkins.plugins.opentelemetry.semconv.ConfigurationKey;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.remoting.RoleChecker;

@Extension
public class OpenTelemetryTraceContextPropagatorFileCallableWrapperFactory
extends FilePath.FileCallableWrapperFactory
implements OpenTelemetryLifecycleListener {
    static final Logger LOGGER = Logger.getLogger(OpenTelemetryTraceContextPropagatorFileCallableWrapperFactory.class.getName());
    final AtomicBoolean remotingTracingEnabled = new AtomicBoolean(false);
    final AtomicBoolean buildAgentsInstrumentationEnabled = new AtomicBoolean(false);

    public <T> DelegatingCallable<T, IOException> wrap(DelegatingCallable<T, IOException> callable) {
        if (this.buildAgentsInstrumentationEnabled.get()) {
            return new OTelDelegatingCallable<T, IOException>(callable, this.remotingTracingEnabled.get());
        }
        return callable;
    }

    @Inject
    public void setJenkinsOpenTelemetryPluginConfiguration(JenkinsOpenTelemetryPluginConfiguration jenkinsOpenTelemetryPluginConfiguration) {
        ConfigProperties configProperties = jenkinsOpenTelemetryPluginConfiguration.getConfigProperties();
        this.buildAgentsInstrumentationEnabled.set(configProperties.getBoolean(ConfigurationKey.OTEL_INSTRUMENTATION_JENKINS_AGENTS_ENABLED.asProperty(), false));
        this.remotingTracingEnabled.set(configProperties.getBoolean(ConfigurationKey.OTEL_INSTRUMENTATION_JENKINS_REMOTING_ENABLED.asProperty(), false));
    }

    public void afterConfiguration(@NonNull ConfigProperties configProperties) {
        this.buildAgentsInstrumentationEnabled.set(configProperties.getBoolean(ConfigurationKey.OTEL_INSTRUMENTATION_JENKINS_AGENTS_ENABLED.asProperty(), false));
        this.remotingTracingEnabled.set(configProperties.getBoolean(ConfigurationKey.OTEL_INSTRUMENTATION_JENKINS_REMOTING_ENABLED.asProperty(), false));
    }

    static class OTelDelegatingCallable<V, T extends Throwable>
    implements DelegatingCallable<V, T> {
        private static final long serialVersionUID = 1L;
        final DelegatingCallable<V, T> callable;
        final Map<String, String> w3cTraceContext;
        final boolean remotingTracingEnabled;

        public OTelDelegatingCallable(DelegatingCallable<V, T> callable, boolean remotingTracingEnabled) {
            this.callable = callable;
            this.w3cTraceContext = new HashMap<String, String>();
            W3CTraceContextPropagator.getInstance().inject(Context.current(), this.w3cTraceContext, (carrier, key, value) -> {
                assert (carrier != null);
                carrier.put(key, value);
            });
            this.remotingTracingEnabled = remotingTracingEnabled;
            LOGGER.log(Level.FINER, () -> "Wrap " + String.valueOf(callable) + " to propagate trace context " + String.valueOf(this.w3cTraceContext));
        }

        public ClassLoader getClassLoader() {
            return this.callable.getClassLoader();
        }

        public V call() throws T {
            Span span;
            if (!GlobalOpenTelemetrySdk.isInitialized()) {
                LOGGER.log(Level.INFO, () -> "Call " + String.valueOf(this.callable) + " before OpenTelemetry SDK was initialized. " + String.valueOf(this.w3cTraceContext));
                return (V)this.callable.call();
            }
            Context callerContext = W3CTraceContextPropagator.getInstance().extract(Context.current(), this.w3cTraceContext, (TextMapGetter)new TextMapGetter<Map<String, String>>(){

                public Iterable<String> keys(@Nonnull Map<String, String> carrier) {
                    return carrier.keySet();
                }

                @Nullable
                public String get(@Nullable Map<String, String> carrier, @Nonnull String key) {
                    assert (carrier != null);
                    return carrier.get(key);
                }
            });
            LOGGER.log(Level.FINER, () -> "Call " + String.valueOf(this.callable) + " with trace context " + String.valueOf(this.w3cTraceContext));
            if (this.remotingTracingEnabled) {
                String callableToString = this.callable.toString();
                String spanName = "hudson.FilePath$FileCallableWrapper".equals(this.callable.getClass().getName()) && StringUtils.contains((String)callableToString, (String)"@") ? StringUtils.substringBefore((String)callableToString, (String)"@") : "Call";
                span = GlobalOpenTelemetry.getTracer((String)"io.jenkins.opentelemetry").spanBuilder(spanName).setParent(callerContext).setSpanKind(SpanKind.SERVER).setAttribute("jenkins.remoting.callable", callableToString).setAttribute("jenkins.remoting.callable.class", this.callable.getClass().getName()).startSpan();
            } else {
                span = Span.fromContext((Context)callerContext);
            }
            try {
                Object object;
                block14: {
                    Scope scope = span.makeCurrent();
                    try {
                        object = this.callable.call();
                        if (scope == null) break block14;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (scope != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable t) {
                            span.setStatus(StatusCode.ERROR, t.getMessage());
                            span.recordException(t);
                            throw t;
                        }
                    }
                    scope.close();
                }
                return (V)object;
            }
            finally {
                span.end();
            }
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
            this.callable.checkRoles(checker);
        }
    }
}

