/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.init;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.LoadStatistics;
import hudson.model.Node;
import io.jenkins.plugins.opentelemetry.JenkinsControllerOpenTelemetry;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jenkins.YesNoMaybe;
import jenkins.model.Jenkins;

@Extension(dynamicLoadable=YesNoMaybe.MAYBE, optional=true)
public class JenkinsExecutorMonitoringInitializer
implements OpenTelemetryLifecycleListener {
    private static final Logger logger = Logger.getLogger(JenkinsExecutorMonitoringInitializer.class.getName());
    @Inject
    JenkinsControllerOpenTelemetry jenkinsControllerOpenTelemetry;

    public JenkinsExecutorMonitoringInitializer() {
        logger.log(Level.FINE, () -> "JenkinsExecutorMonitoringInitializer constructor");
    }

    @PostConstruct
    public void postConstruct() {
        logger.log(Level.FINE, () -> "Start monitoring Jenkins controller executor pool...");
        Meter meter = Objects.requireNonNull(this.jenkinsControllerOpenTelemetry).getDefaultMeter();
        ObservableLongMeasurement queueLength = meter.gaugeBuilder("jenkins.executor.queue").setUnit("${items}").setDescription("Executors queue items").ofLongs().buildObserver();
        ObservableLongMeasurement totalExecutors = meter.gaugeBuilder("jenkins.executor.total").setUnit("${executors}").setDescription("Total executors").ofLongs().buildObserver();
        ObservableLongMeasurement nodes = meter.gaugeBuilder("jenkins.node").setUnit("${nodes}").setDescription("Nodes").ofLongs().buildObserver();
        ObservableLongMeasurement executors = meter.gaugeBuilder("jenkins.executor.count").setUnit("${executors}").setDescription("Count of executors per label").ofLongs().buildObserver();
        ObservableLongMeasurement availableExecutors = meter.gaugeBuilder("jenkins.executor.available").setUnit("${executors}").setDescription("Available executors").ofLongs().buildObserver();
        ObservableLongMeasurement busyExecutors = meter.gaugeBuilder("jenkins.executor.busy").setUnit("${executors}").setDescription("Busy executors").ofLongs().buildObserver();
        ObservableLongMeasurement idleExecutors = meter.gaugeBuilder("jenkins.executor.idle").setUnit("${executors}").setDescription("Idle executors").ofLongs().buildObserver();
        ObservableLongMeasurement onlineExecutors = meter.gaugeBuilder("jenkins.executor.online").setUnit("${executors}").setDescription("Online executors").ofLongs().buildObserver();
        ObservableLongMeasurement connectingExecutors = meter.gaugeBuilder("jenkins.executor.connecting").setUnit("${executors}").setDescription("Connecting executors").ofLongs().buildObserver();
        ObservableLongMeasurement definedExecutors = meter.gaugeBuilder("jenkins.executor.defined").setUnit("${executors}").setDescription("Defined executors").ofLongs().buildObserver();
        logger.log(Level.FINER, () -> "Metrics: " + String.valueOf(availableExecutors) + ", " + String.valueOf(busyExecutors) + ", " + String.valueOf(idleExecutors) + ", " + String.valueOf(onlineExecutors) + ", " + String.valueOf(connectingExecutors) + ", " + String.valueOf(definedExecutors) + ", " + String.valueOf(queueLength));
        meter.batchCallback(() -> {
            logger.log(Level.FINE, () -> "Recording Jenkins controller executor pool metrics...");
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                logger.log(Level.FINE, "Jenkins instance is null, skipping executor pool metrics recording");
                return;
            }
            AtomicInteger totalExecutorsIdle = new AtomicInteger();
            AtomicInteger totalExecutorsBusy = new AtomicInteger();
            AtomicInteger nodeOnline = new AtomicInteger();
            AtomicInteger nodeOffline = new AtomicInteger();
            if (jenkins.getNumExecutors() > 0) {
                nodeOnline.incrementAndGet();
                Optional.ofNullable(jenkins.toComputer()).map(Computer::getExecutors).ifPresent(e -> e.forEach(executor -> {
                    if (executor.isIdle()) {
                        totalExecutorsIdle.incrementAndGet();
                    } else {
                        totalExecutorsBusy.incrementAndGet();
                    }
                }));
            }
            jenkins.getNodes().stream().map(Node::toComputer).filter(Objects::nonNull).forEach(node -> {
                if (node.isOnline()) {
                    nodeOnline.incrementAndGet();
                    node.getExecutors().forEach(executor -> {
                        if (executor.isIdle()) {
                            totalExecutorsIdle.incrementAndGet();
                        } else {
                            totalExecutorsBusy.incrementAndGet();
                        }
                    });
                } else {
                    nodeOffline.incrementAndGet();
                }
            });
            totalExecutors.record((long)totalExecutorsBusy.get(), Attributes.of(ExtendedJenkinsAttributes.STATUS, (Object)"busy"));
            totalExecutors.record((long)totalExecutorsIdle.get(), Attributes.of(ExtendedJenkinsAttributes.STATUS, (Object)"idle"));
            nodes.record((long)nodeOnline.get(), Attributes.of(ExtendedJenkinsAttributes.STATUS, (Object)"online"));
            nodes.record((long)nodeOffline.get(), Attributes.of(ExtendedJenkinsAttributes.STATUS, (Object)"offline"));
            jenkins.getLabels().forEach(label -> {
                LoadStatistics.LoadStatisticsSnapshot loadStatisticsSnapshot = label.loadStatistics.computeSnapshot();
                Attributes attributes = Attributes.of(ExtendedJenkinsAttributes.LABEL, (Object)label.getDisplayName());
                executors.record((long)loadStatisticsSnapshot.getBusyExecutors(), attributes.toBuilder().put(ExtendedJenkinsAttributes.STATUS, (Object)"busy").build());
                executors.record((long)loadStatisticsSnapshot.getIdleExecutors(), attributes.toBuilder().put(ExtendedJenkinsAttributes.STATUS, (Object)"idle").build());
                executors.record((long)loadStatisticsSnapshot.getConnectingExecutors(), attributes.toBuilder().put(ExtendedJenkinsAttributes.STATUS, (Object)"connecting").build());
                queueLength.record((long)loadStatisticsSnapshot.getQueueLength(), attributes);
                availableExecutors.record((long)loadStatisticsSnapshot.getAvailableExecutors(), attributes);
                busyExecutors.record((long)loadStatisticsSnapshot.getBusyExecutors(), attributes);
                idleExecutors.record((long)loadStatisticsSnapshot.getIdleExecutors(), attributes);
                onlineExecutors.record((long)loadStatisticsSnapshot.getOnlineExecutors(), attributes);
                definedExecutors.record((long)loadStatisticsSnapshot.getDefinedExecutors(), attributes);
                connectingExecutors.record((long)loadStatisticsSnapshot.getConnectingExecutors(), attributes);
            });
        }, (ObservableMeasurement)availableExecutors, new ObservableMeasurement[]{busyExecutors, idleExecutors, onlineExecutors, connectingExecutors, definedExecutors, totalExecutors, executors, nodes, queueLength});
    }
}

