/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.init;

import com.google.common.base.Preconditions;
import hudson.Extension;
import io.jenkins.plugins.opentelemetry.JenkinsControllerOpenTelemetry;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.jenkins.plugins.opentelemetry.semconv.GitHubAttributes;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.semconv.incubating.EnduserIncubatingAttributes;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jenkins.YesNoMaybe;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.GitHubAppCredentials;
import org.kohsuke.github.GHApp;
import org.kohsuke.github.GHRateLimit;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.authorization.AuthorizationProvider;
import org.kohsuke.github.authorization.UserAuthorizationProvider;

@Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
public class GitHubClientMonitoring
implements OpenTelemetryLifecycleListener {
    private static final Logger logger = Logger.getLogger(GitHubClientMonitoring.class.getName());
    private final Field gitHub_clientField;
    private final Class<?> gitHubClientClass;
    private final Field gitHubClient_authorizationProviderField;
    private final Class<?> credentialsTokenProviderClass;
    private final Field credentialsTokenProvider_credentialsField;
    private final Field dependentAuthorizationProvider_gitHubField;
    private final Class<?> authorizationRefreshGitHubWrapperClass;
    private final Map<GitHub, ?> reverseLookup;
    @Inject
    protected JenkinsControllerOpenTelemetry jenkinsControllerOpenTelemetry;

    public GitHubClientMonitoring() {
        try {
            Field connector_reverseLookupField = Connector.class.getDeclaredField("reverseLookup");
            connector_reverseLookupField.setAccessible(true);
            Preconditions.checkState((boolean)Modifier.isStatic(connector_reverseLookupField.getModifiers()), (String)"Connector#reverseLookup is NOT a static field: %s", (Object)connector_reverseLookupField);
            this.gitHub_clientField = GitHub.class.getDeclaredField("client");
            this.gitHub_clientField.setAccessible(true);
            this.gitHubClientClass = Class.forName("org.kohsuke.github.GitHubClient");
            this.gitHubClient_authorizationProviderField = this.gitHubClientClass.getDeclaredField("authorizationProvider");
            this.gitHubClient_authorizationProviderField.setAccessible(true);
            this.credentialsTokenProviderClass = Class.forName("org.jenkinsci.plugins.github_branch_source.GitHubAppCredentials$CredentialsTokenProvider");
            this.credentialsTokenProvider_credentialsField = this.credentialsTokenProviderClass.getDeclaredField("credentials");
            this.credentialsTokenProvider_credentialsField.setAccessible(true);
            Preconditions.checkState((boolean)GitHubAppCredentials.class.isAssignableFrom(this.credentialsTokenProvider_credentialsField.getType()), (String)"Unsupported type for credentialsTokenProvider.credentials. Expected GitHubAppCredentials, current %s", (Object)this.credentialsTokenProvider_credentialsField);
            this.dependentAuthorizationProvider_gitHubField = GitHub.DependentAuthorizationProvider.class.getDeclaredField("gitHub");
            this.dependentAuthorizationProvider_gitHubField.setAccessible(true);
            this.authorizationRefreshGitHubWrapperClass = Class.forName("org.kohsuke.github.GitHub$AuthorizationRefreshGitHubWrapper");
            this.reverseLookup = (Map)connector_reverseLookupField.get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Unsupported version of the Github Branch Source Plugin", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("SecurityManager is activated, cannot monitor the GitHub Client as it requires Java reflection permissions", e);
        }
    }

    @PostConstruct
    public void postConstruct() {
        logger.log(Level.FINE, () -> "Start monitoring Jenkins controller GitHub client...");
        Meter meter = Objects.requireNonNull(this.jenkinsControllerOpenTelemetry).getDefaultMeter();
        meter.gaugeBuilder("github.api.rate_limit.remaining_requests").ofLongs().setDescription("GitHub Repository API rate limit remaining requests").setUnit("{requests}").buildWithCallback(gauge -> {
            logger.log(Level.FINE, () -> "Collect GitHub client API rate limit metrics");
            this.reverseLookup.keySet().forEach(gitHub -> {
                GHRateLimit ghRateLimit = gitHub.lastRateLimit();
                try {
                    Object authentication;
                    AttributesBuilder attributesBuilder = Attributes.of(GitHubAttributes.GITHUB_API_URL, (Object)gitHub.getApiUrl()).toBuilder();
                    if (gitHub.isAnonymous()) {
                        authentication = "anonymous";
                    } else {
                        Object gitHubClient = this.gitHub_clientField.get(gitHub);
                        Preconditions.checkState((boolean)this.gitHubClientClass.isAssignableFrom(gitHubClient.getClass()));
                        AuthorizationProvider authorizationProvider = (AuthorizationProvider)this.gitHubClient_authorizationProviderField.get(gitHubClient);
                        if (authorizationProvider instanceof UserAuthorizationProvider) {
                            String gitHubLogin = ((UserAuthorizationProvider)authorizationProvider).getLogin();
                            if (gitHubLogin == null) {
                                gitHubLogin = gitHub.getMyself().getLogin();
                            }
                            attributesBuilder.put(EnduserIncubatingAttributes.ENDUSER_ID, (Object)gitHubLogin);
                            authentication = "login:" + gitHubLogin;
                        } else if (this.credentialsTokenProviderClass.isAssignableFrom(authorizationProvider.getClass())) {
                            GitHub jwtTokenBasedGitHub = (GitHub)this.dependentAuthorizationProvider_gitHubField.get(authorizationProvider);
                            if (this.authorizationRefreshGitHubWrapperClass.isAssignableFrom(jwtTokenBasedGitHub.getClass())) {
                                GHApp gitHubApp = jwtTokenBasedGitHub.getApp();
                                attributesBuilder.put(GitHubAttributes.GITHUB_APP_NAME, (Object)gitHubApp.getName());
                                attributesBuilder.put(GitHubAttributes.GITHUB_APP_ID, (Object)gitHubApp.getId());
                                attributesBuilder.put(GitHubAttributes.GITHUB_APP_OWNER, (Object)gitHubApp.getName());
                                authentication = "app:id=" + gitHubApp.getId() + ",name=\"" + gitHubApp.getName() + "\",owner=" + gitHubApp.getName();
                            } else {
                                GitHubAppCredentials credentials = (GitHubAppCredentials)this.credentialsTokenProvider_credentialsField.get(authorizationProvider);
                                attributesBuilder.put(GitHubAttributes.GITHUB_APP_ID, (Object)Long.valueOf(credentials.getAppID()));
                                authentication = "app:id=" + credentials.getAppID();
                                logger.log(Level.INFO, "Unexpected credentialsTokenProvider with internal GitHub of type " + String.valueOf(jwtTokenBasedGitHub));
                            }
                        } else {
                            authentication = String.valueOf(authorizationProvider.getClass()) + ":" + System.identityHashCode(authorizationProvider);
                        }
                    }
                    Attributes attributes = attributesBuilder.put(GitHubAttributes.GITHUB_AUTHENTICATION, authentication).build();
                    logger.log(Level.FINER, () -> "Collect GitHub API " + String.valueOf(attributes) + ": rateLimit.remaining:" + ghRateLimit.getRemaining());
                    gauge.record((long)ghRateLimit.getRemaining(), attributes);
                }
                catch (IOException | IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        });
    }
}

