/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend.grafana;

import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.text.Template;
import hudson.util.FormValidation;
import io.jenkins.plugins.opentelemetry.TemplateBindingsProvider;
import io.jenkins.plugins.opentelemetry.backend.grafana.LokiBuildLogsLineIterator;
import io.jenkins.plugins.opentelemetry.backend.grafana.LokiGetJenkinsBuildLogsQueryParameters;
import io.jenkins.plugins.opentelemetry.backend.grafana.LokiGetJenkinsBuildLogsQueryParametersBuilder;
import io.jenkins.plugins.opentelemetry.backend.grafana.LokiTenantHeader;
import io.jenkins.plugins.opentelemetry.jenkins.HttpAuthHeaderFactory;
import io.jenkins.plugins.opentelemetry.job.log.LogStorageRetriever;
import io.jenkins.plugins.opentelemetry.job.log.LogsQueryResult;
import io.jenkins.plugins.opentelemetry.job.log.LogsViewHeader;
import io.jenkins.plugins.opentelemetry.job.log.util.InputStreamByteBuffer;
import io.jenkins.plugins.opentelemetry.job.log.util.LogLineIterator;
import io.jenkins.plugins.opentelemetry.job.log.util.LogLineIteratorInputStream;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.apachehttpclient.v5_2.ApacheHttpClientTelemetry;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;

public class LokiLogStorageRetriever
implements LogStorageRetriever,
Closeable {
    private static final Logger logger = Logger.getLogger(LokiLogStorageRetriever.class.getName());
    private final Template buildLogsVisualizationUrlTemplate;
    private final TemplateBindingsProvider templateBindingsProvider;
    private final String lokiUrl;
    private final String serviceName;
    private final Optional<String> serviceNamespace;
    private final Optional<HttpAuthHeaderFactory> httpAuthHeaderFactory;
    private final Optional<String> lokiTenantId;
    private final CloseableHttpClient httpClient;
    private final HttpContext httpContext;
    private final OpenTelemetry openTelemetry;
    private final Tracer tracer;

    @MustBeClosed
    public LokiLogStorageRetriever(@Nonnull String lokiUrl, boolean disableSslVerifications, @Nonnull Optional<HttpAuthHeaderFactory> httpAuthHeaderFactory, @Nonnull Optional<String> lokiTenantId, @NonNull Template buildLogsVisualizationUrlTemplate, @NonNull TemplateBindingsProvider templateBindingsProvider, @Nonnull String serviceName, @Nonnull Optional<String> serviceNamespace) {
        if (StringUtils.isBlank((String)lokiUrl)) {
            throw new IllegalArgumentException("Loki url cannot be blank");
        }
        this.lokiUrl = lokiUrl;
        this.serviceName = serviceName;
        this.serviceNamespace = serviceNamespace;
        this.httpAuthHeaderFactory = httpAuthHeaderFactory;
        this.lokiTenantId = lokiTenantId;
        this.httpContext = HttpClientContext.create();
        this.openTelemetry = GlobalOpenTelemetry.get();
        this.tracer = this.openTelemetry.getTracer("io.jenkins.opentelemetry");
        HttpClientBuilder httpClientBuilder = ApacheHttpClientTelemetry.create((OpenTelemetry)this.openTelemetry).newHttpClientBuilder();
        if (disableSslVerifications) {
            try {
                SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()).build();
                SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
                httpClientBuilder.setConnectionManager((HttpClientConnectionManager)cm);
            }
            catch (GeneralSecurityException e) {
                logger.log(Level.WARNING, "IllegalStateException: failure to disable SSL certs verification");
            }
        }
        this.httpClient = httpClientBuilder.build();
        this.buildLogsVisualizationUrlTemplate = buildLogsVisualizationUrlTemplate;
        this.templateBindingsProvider = templateBindingsProvider;
    }

    @Override
    @Nonnull
    public LogsQueryResult overallLog(String jobFullName, int runNumber, String traceId, String spanId, boolean complete, Instant startTime, @Nullable Instant endTime) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder("LokiLogStorageRetriever.overallLog").setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_ID, (Object)jobFullName).setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_NUMBER, (Object)runNumber).setAttribute("complete", complete);
        Span span = spanBuilder.startSpan();
        try {
            LogsQueryResult logsQueryResult;
            block11: {
                Scope ignored = span.makeCurrent();
                try {
                    LokiGetJenkinsBuildLogsQueryParameters lokiQueryParameters = new LokiGetJenkinsBuildLogsQueryParametersBuilder().setJobFullName(jobFullName).setRunNumber(runNumber).setTraceId(traceId).setStartTime(startTime).setEndTime(endTime).setServiceName(this.serviceName).setServiceNamespace(this.serviceNamespace).build();
                    LokiBuildLogsLineIterator logLines = new LokiBuildLogsLineIterator(lokiQueryParameters, this.httpClient, this.httpContext, this.lokiUrl, this.httpAuthHeaderFactory, this.lokiTenantId, this.openTelemetry.getTracer("io.jenkins.opentelemetry"));
                    LogLineIterator.JenkinsHttpSessionLineBytesToLogLineIdMapper lineBytesToLineNumberConverter = new LogLineIterator.JenkinsHttpSessionLineBytesToLogLineIdMapper(jobFullName, runNumber, null);
                    LogLineIteratorInputStream<Long> lineIteratorInputStream = new LogLineIteratorInputStream<Long>(logLines, lineBytesToLineNumberConverter, this.tracer);
                    InputStreamByteBuffer byteBuffer = new InputStreamByteBuffer(lineIteratorInputStream, this.tracer);
                    Map<String, Object> localBindings = Map.of("traceId", traceId, "spanId", spanId, "startTime", startTime, "endTime", Optional.ofNullable(endTime).or(() -> Optional.of(Instant.now())).get());
                    Map<String, Object> bindings = TemplateBindingsProvider.compose(this.templateBindingsProvider, localBindings).getBindings();
                    String logsVisualizationUrl = this.buildLogsVisualizationUrlTemplate.make(bindings).toString();
                    logsQueryResult = new LogsQueryResult(byteBuffer, new LogsViewHeader(bindings.get("backendName").toString(), logsVisualizationUrl, bindings.get("backend24x24IconUrl").toString()), StandardCharsets.UTF_8, complete);
                    if (ignored == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        span.recordException((Throwable)e);
                        span.setStatus(StatusCode.ERROR, e.getMessage());
                        throw e;
                    }
                }
                ignored.close();
            }
            return logsQueryResult;
        }
        finally {
            span.end();
        }
    }

    @Override
    @Nonnull
    public LogsQueryResult stepLog(String jobFullName, int runNumber, String flowNodeId, String traceId, String spanId, boolean complete, Instant startTime, @Nullable Instant endTime) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder("LokiLogStorageRetriever.stepLog").setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_ID, (Object)jobFullName).setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_NUMBER, (Object)runNumber).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_ID, (Object)flowNodeId).setAttribute("complete", complete);
        Span span = spanBuilder.startSpan();
        try {
            LogsQueryResult logsQueryResult;
            block11: {
                Scope ignored = span.makeCurrent();
                try {
                    LokiGetJenkinsBuildLogsQueryParameters lokiQueryParameters = new LokiGetJenkinsBuildLogsQueryParametersBuilder().setJobFullName(jobFullName).setRunNumber(runNumber).setTraceId(traceId).setFlowNodeId(flowNodeId).setStartTime(startTime).setEndTime(endTime).setServiceName(this.serviceName).setServiceNamespace(this.serviceNamespace).build();
                    LokiBuildLogsLineIterator logLines = new LokiBuildLogsLineIterator(lokiQueryParameters, this.httpClient, this.httpContext, this.lokiUrl, this.httpAuthHeaderFactory, this.lokiTenantId, this.openTelemetry.getTracer("io.jenkins"));
                    LogLineIterator.JenkinsHttpSessionLineBytesToLogLineIdMapper logLineBytesToLogLineIdMapper = new LogLineIterator.JenkinsHttpSessionLineBytesToLogLineIdMapper(jobFullName, runNumber, null);
                    LogLineIteratorInputStream<Long> logLineIteratorInputStream = new LogLineIteratorInputStream<Long>(logLines, logLineBytesToLogLineIdMapper, this.tracer);
                    InputStreamByteBuffer byteBuffer = new InputStreamByteBuffer(logLineIteratorInputStream, this.tracer);
                    Map<String, Object> localBindings = Map.of("traceId", traceId, "spanId", spanId, "startTime", startTime, "endTime", Optional.ofNullable(endTime).or(() -> Optional.of(Instant.now())).get());
                    Map<String, Object> bindings = TemplateBindingsProvider.compose(this.templateBindingsProvider, localBindings).getBindings();
                    String logsVisualizationUrl = this.buildLogsVisualizationUrlTemplate.make(bindings).toString();
                    logsQueryResult = new LogsQueryResult(byteBuffer, new LogsViewHeader(bindings.get("backendName").toString(), logsVisualizationUrl, bindings.get("backend24x24IconUrl").toString()), StandardCharsets.UTF_8, complete);
                    if (ignored == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        span.recordException((Throwable)e);
                        span.setStatus(StatusCode.ERROR, e.getMessage());
                        throw e;
                    }
                }
                ignored.close();
            }
            return logsQueryResult;
        }
        finally {
            span.end();
        }
    }

    public List<FormValidation> checkLokiSetup() {
        ArrayList<FormValidation> validations = new ArrayList<FormValidation>();
        final ClassicHttpRequest lokiBuildInfoRequest = ClassicRequestBuilder.get().setUri(this.lokiUrl + "/loki/api/v1/format_query").addParameter("query", "{foo= \"bar\"}").build();
        this.httpAuthHeaderFactory.ifPresent(factory -> lokiBuildInfoRequest.addHeader(factory.createAuthHeader()));
        this.lokiTenantId.ifPresent(tenantId -> lokiBuildInfoRequest.addHeader((Header)new LokiTenantHeader((String)tenantId)));
        try {
            validations.add((FormValidation)this.httpClient.execute(lokiBuildInfoRequest, this.httpContext, (HttpClientResponseHandler)new HttpClientResponseHandler<FormValidation>(){

                public FormValidation handleResponse(ClassicHttpResponse lokiReadyResponse) {
                    FormValidation ret = FormValidation.ok((String)"Loki connection successful");
                    try {
                        ret = lokiReadyResponse.getCode() != 200 ? FormValidation.error((String)("Failure to access Loki (" + String.valueOf(lokiBuildInfoRequest) + "): " + EntityUtils.toString((HttpEntity)lokiReadyResponse.getEntity()))) : FormValidation.ok((String)"Loki connection successful");
                    }
                    catch (IOException | ParseException e) {
                        ret = FormValidation.error((String)("Failure to access Loki (" + String.valueOf(lokiBuildInfoRequest) + "): " + e.getMessage()));
                    }
                    return ret;
                }
            }));
        }
        catch (IOException e) {
            validations.add(FormValidation.error((String)("Failure to access Loki (" + String.valueOf(lokiBuildInfoRequest) + "): " + e.getMessage())));
        }
        return validations;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }
}

