/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend.grafana;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.opentelemetry.backend.grafana.LokiMetadata;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;

public class LokiGetJenkinsBuildLogsQueryParameters {
    @NonNull
    private final String jobFullName;
    private final int runNumber;
    @NonNull
    private final String traceId;
    @NonNull
    private final Optional<String> flowNodeId;
    @NonNull
    private Long startTimeInNanos;
    @NonNull
    private final Optional<Long> endTimeInNanos;
    @NonNull
    private final String serviceName;
    @NonNull
    private final Optional<String> serviceNamespace;

    public LokiGetJenkinsBuildLogsQueryParameters(@NonNull String jobFullName, int runNumber, @NonNull String traceId, @NonNull Optional<String> flowNodeId, @NonNull Instant startTimeInNanos, @NonNull Optional<Instant> endTime, @NonNull String serviceName, @NonNull Optional<String> serviceNamespace) {
        this.jobFullName = jobFullName;
        this.runNumber = runNumber;
        this.traceId = traceId;
        this.flowNodeId = flowNodeId;
        this.startTimeInNanos = LokiGetJenkinsBuildLogsQueryParameters.instantToEpochNanos(startTimeInNanos);
        this.endTimeInNanos = endTime.map(new InstantToEpochInNanos());
        this.serviceName = serviceName;
        this.serviceNamespace = serviceNamespace;
    }

    public ClassicHttpRequest toHttpRequest(@Nonnull String lokiUrl) {
        StringBuilder logQl = new StringBuilder("{");
        this.serviceNamespace.ifPresent(serviceNamespace -> logQl.append(LokiMetadata.LABEL_SERVICE_NAMESPACE).append("=\"").append((String)serviceNamespace).append("\", "));
        logQl.append(LokiMetadata.LABEL_SERVICE_NAME + "=\"" + this.serviceName + "\"}");
        logQl.append("|trace_id=\"" + this.traceId + "\", " + LokiMetadata.META_DATA_CI_PIPELINE_ID + "=\"" + this.jobFullName + "\", " + LokiMetadata.META_DATA_CI_PIPELINE_RUN_NUMBER + "=" + this.runNumber);
        this.flowNodeId.ifPresent(flowNodeId -> logQl.append(", " + LokiMetadata.META_DATA_JENKINS_PIPELINE_STEP_ID + "=\"" + flowNodeId + "\""));
        logQl.append(" | keep __line__");
        ClassicRequestBuilder lokiQueryRangeRequestBuilder = ClassicRequestBuilder.get().setUri(lokiUrl + "/loki/api/v1/query_range").addParameter("query", logQl.toString()).addParameter("start", "" + this.startTimeInNanos).addParameter("direction", "forward");
        this.endTimeInNanos.ifPresent(endTimeInNanos -> lokiQueryRangeRequestBuilder.addParameter("end", String.valueOf(endTimeInNanos)));
        return lokiQueryRangeRequestBuilder.build();
    }

    public Attributes toAttributes() {
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributesBuilder.put("query.trace_id", this.traceId);
        attributesBuilder.put("query." + LokiMetadata.META_DATA_CI_PIPELINE_ID, this.jobFullName);
        attributesBuilder.put("query." + LokiMetadata.META_DATA_CI_PIPELINE_RUN_NUMBER, (long)this.runNumber);
        this.flowNodeId.ifPresent(flowNodeId -> attributesBuilder.put("query." + LokiMetadata.META_DATA_JENKINS_PIPELINE_STEP_ID, flowNodeId));
        attributesBuilder.put("query.startTimeInNanos", this.startTimeInNanos.longValue());
        this.endTimeInNanos.ifPresent(endTimeInNanos -> attributesBuilder.put("query.endTimeInNanos", endTimeInNanos.longValue()));
        return attributesBuilder.build();
    }

    public void setStartTimeInNanos(long startTimeInNanos) {
        this.startTimeInNanos = startTimeInNanos;
    }

    @NonNull
    public Long getStartTimeInNanos() {
        return this.startTimeInNanos;
    }

    public String toString() {
        return "LokiGetJenkinsBuildLogsQueryParameters{jobFullName='" + this.jobFullName + "', runNumber=" + this.runNumber + ", traceId='" + this.traceId + "', flowNodeId=" + String.valueOf(this.flowNodeId) + ", startTimeInNanos=" + this.startTimeInNanos + ", endTimeInNanos=" + String.valueOf(this.endTimeInNanos) + ", serviceName='" + this.serviceName + "', serviceNamespace=" + String.valueOf(this.serviceNamespace) + "}";
    }

    static long instantToEpochNanos(Instant instant) {
        return new InstantToEpochInNanos().apply(instant);
    }

    static class InstantToEpochInNanos
    implements Function<Instant, Long> {
        InstantToEpochInNanos() {
        }

        @Override
        @Nonnull
        public Long apply(Instant instant) {
            return TimeUnit.NANOSECONDS.convert(instant.toEpochMilli(), TimeUnit.MILLISECONDS) + (long)instant.getNano();
        }
    }
}

