/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend.grafana;

import com.google.common.annotations.VisibleForTesting;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.opentelemetry.backend.grafana.LokiGetJenkinsBuildLogsQueryParameters;
import io.jenkins.plugins.opentelemetry.backend.grafana.LokiTenantHeader;
import io.jenkins.plugins.opentelemetry.jenkins.HttpAuthHeaderFactory;
import io.jenkins.plugins.opentelemetry.job.log.LogLine;
import io.jenkins.plugins.opentelemetry.job.log.util.CloseableIterator;
import io.jenkins.plugins.opentelemetry.job.log.util.LogLineIterator;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;

public class LokiBuildLogsLineIterator
implements LogLineIterator<Long>,
AutoCloseable {
    protected static final Logger logger = Logger.getLogger(LokiBuildLogsLineIterator.class.getName());
    public static final int MAX_QUERIES = 100;
    protected final LokiGetJenkinsBuildLogsQueryParameters lokiQueryParameters;
    final String lokiUrl;
    final Optional<HttpAuthHeaderFactory> httpAuthHeaderFactory;
    final Optional<String> lokiTenantId;
    final CloseableHttpClient httpClient;
    final HttpContext httpContext;
    @VisibleForTesting
    int queryCounter;
    final Tracer tracer;
    Iterator<LogLine<Long>> delegate;
    boolean endOfStream;

    public LokiBuildLogsLineIterator(@NonNull LokiGetJenkinsBuildLogsQueryParameters lokiQueryParameters, @NonNull CloseableHttpClient httpClient, @NonNull HttpContext httpContext, @NonNull String lokiUrl, @NonNull Optional<HttpAuthHeaderFactory> httpAuthHeaderFactory, @NonNull Optional<String> lokiTenantId, @NonNull Tracer tracer) {
        this.lokiQueryParameters = lokiQueryParameters;
        this.lokiUrl = lokiUrl;
        this.httpAuthHeaderFactory = httpAuthHeaderFactory;
        this.lokiTenantId = lokiTenantId;
        this.httpClient = httpClient;
        this.httpContext = httpContext;
        this.tracer = tracer;
    }

    @NonNull
    Iterator<LogLine<Long>> getCurrentIterator() {
        try {
            if (this.endOfStream) {
                return this.delegate;
            }
            if (this.delegate == null) {
                this.delegate = this.loadNextLogLines();
            }
            if (this.delegate.hasNext()) {
                return this.delegate;
            }
            this.delegate = this.loadNextLogLines();
            if (!this.delegate.hasNext()) {
                this.endOfStream = true;
            }
            return this.delegate;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Iterator<LogLine<Long>> loadNextLogLines() throws IOException {
        if (this.queryCounter > 100) {
            logger.log(Level.INFO, () -> "Circuit breaker: " + this.queryCounter + " queries for " + String.valueOf(this.lokiQueryParameters));
            return Collections.emptyIterator();
        }
        Span loadNextLogLinesSpan = this.tracer.spanBuilder("LokiBuildLogsLineIterator.loadNextLogLines").setAllAttributes(this.lokiQueryParameters.toAttributes()).startSpan();
        try (Scope loadNextLogLinesScope = loadNextLogLinesSpan.makeCurrent();){
            ClassicHttpRequest lokiQueryRangeRequest = this.lokiQueryParameters.toHttpRequest(this.lokiUrl);
            this.httpAuthHeaderFactory.ifPresent(factory -> lokiQueryRangeRequest.addHeader(factory.createAuthHeader()));
            this.lokiTenantId.ifPresent(tenantId -> lokiQueryRangeRequest.addHeader((Header)new LokiTenantHeader((String)tenantId)));
            ++this.queryCounter;
            Iterator iterator = (Iterator)this.httpClient.execute(lokiQueryRangeRequest, this.httpContext, (HttpClientResponseHandler)new HttpClientResponseHandler<Iterator<LogLine<Long>>>(){

                public Iterator<LogLine<Long>> handleResponse(ClassicHttpResponse lokiQueryRangeResponse) throws IOException {
                    try {
                        if (lokiQueryRangeResponse.getCode() != 200) {
                            throw new IOException("Loki logs query failure: " + lokiQueryRangeResponse.getReasonPhrase() + " - " + EntityUtils.toString((HttpEntity)lokiQueryRangeResponse.getEntity()));
                        }
                        HttpEntity entity = lokiQueryRangeResponse.getEntity();
                        if (entity == null) {
                            logger.log(Level.INFO, "No content in response for " + String.valueOf(LokiBuildLogsLineIterator.this.lokiQueryParameters));
                            return Collections.emptyIterator();
                        }
                        InputStream lokiQueryLogsResponseStream = entity.getContent();
                        return LokiBuildLogsLineIterator.this.loadLogLines(lokiQueryLogsResponseStream);
                    }
                    catch (ParseException e) {
                        throw new IOException(e);
                    }
                }
            });
            return iterator;
        }
    }

    @Nonnull
    @VisibleForTesting
    protected Iterator<LogLine<Long>> loadLogLines(InputStream lokiQueryResponseInputStream) throws IOException {
        Iterator logLineIterator = ((List)JsonPath.read((InputStream)lokiQueryResponseInputStream, (String)"$.data.result[*].values[*]", (Predicate[])new Predicate[0])).stream().map(valueKeyPair -> {
            long timestampInNanos = Long.parseLong((String)valueKeyPair.get(0));
            String msg = (String)valueKeyPair.get(1);
            if (timestampInNanos < this.lokiQueryParameters.getStartTimeInNanos()) {
                logger.log(Level.INFO, () -> "Unordered timestamps " + timestampInNanos + " < " + this.lokiQueryParameters.getStartTimeInNanos() + " for " + String.valueOf(this.lokiQueryParameters));
            } else {
                this.lokiQueryParameters.setStartTimeInNanos(timestampInNanos + 1L);
            }
            return new LogLine<Long>(timestampInNanos, msg);
        }).iterator();
        return new CloseableIterator<LogLine<Long>>(logLineIterator, lokiQueryResponseInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void skipLines(Long lastLogTimestampInNanos) {
        Tracer tracer = logger.isLoggable(Level.FINE) ? this.tracer : TracerProvider.noop().get("noop");
        Span span = tracer.spanBuilder("LokiBuildLogsLineIterator.skip").setAllAttributes(this.lokiQueryParameters.toAttributes()).setAttribute("lastLogTimestampInNanos", lastLogTimestampInNanos.longValue()).startSpan();
        long newStartTimeInNanos = lastLogTimestampInNanos + 1L;
        try {
            if (this.delegate == null) {
                span.setAttribute("skippedLines", -1L);
                this.lokiQueryParameters.setStartTimeInNanos(newStartTimeInNanos);
            } else {
                span.setAttribute("skippedLines", -1L);
                this.lokiQueryParameters.setStartTimeInNanos(newStartTimeInNanos);
                this.delegate = null;
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean hasNext() {
        return this.getCurrentIterator().hasNext();
    }

    @Override
    public LogLine<Long> next() {
        return this.getCurrentIterator().next();
    }

    @Override
    public void close() throws Exception {
        if (this.delegate instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.delegate)).close();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to close delegate for " + String.valueOf(this.lokiQueryParameters), e);
            }
        }
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

