/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend.grafana;

import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.opentelemetry.TemplateBindingsProvider;
import io.jenkins.plugins.opentelemetry.backend.custom.CustomLogStorageRetriever;
import io.jenkins.plugins.opentelemetry.backend.grafana.GrafanaLogsBackend;
import io.jenkins.plugins.opentelemetry.job.log.LogStorageRetriever;
import java.util.Map;
import java.util.Objects;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GrafanaLogsBackendWithoutJenkinsVisualization
extends GrafanaLogsBackend
implements TemplateBindingsProvider {
    private String grafanaLokiDatasourceIdentifier = "grafanacloud-logs";

    @DataBoundConstructor
    public GrafanaLogsBackendWithoutJenkinsVisualization() {
    }

    public String getGrafanaLokiDatasourceIdentifier() {
        return this.grafanaLokiDatasourceIdentifier;
    }

    @DataBoundSetter
    public void setGrafanaLokiDatasourceIdentifier(String grafanaLokiDatasourceIdentifier) {
        this.grafanaLokiDatasourceIdentifier = grafanaLokiDatasourceIdentifier;
    }

    @Override
    @MustBeClosed
    public LogStorageRetriever newLogStorageRetriever(TemplateBindingsProvider templateBindingsProvider) {
        return new CustomLogStorageRetriever(this.getBuildLogsVisualizationUrlTemplate(), templateBindingsProvider);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrafanaLogsBackendWithoutJenkinsVisualization that = (GrafanaLogsBackendWithoutJenkinsVisualization)o;
        return Objects.equals(this.grafanaLokiDatasourceIdentifier, that.grafanaLokiDatasourceIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.grafanaLokiDatasourceIdentifier);
    }

    public String toString() {
        return "GrafanaLogsBackendWithoutJenkinsVisualization{grafanaLokiDatasourceIdentifier='" + this.grafanaLokiDatasourceIdentifier + "'}";
    }

    @Override
    public Map<String, Object> getBindings() {
        return Map.of("grafanaLokiDatasourceIdentifier", this.getGrafanaLokiDatasourceIdentifier());
    }

    @Extension(ordinal=50.0)
    public static class DescriptorImpl
    extends GrafanaLogsBackend.DescriptorImpl {
        @NonNull
        public String getDefaultLokiDataSourceIdentifier() {
            return "grafanacloud-logs";
        }

        @Override
        public String getDefaultLokiOTelLogFormat() {
            return GrafanaLogsBackend.LokiOTelLogFormat.LOKI_V3_OTEL_FORMAT.name();
        }

        @NonNull
        public String getDisplayName() {
            return "Store pipeline logs In Loki and visualize logs exclusively in Grafana (logs no longer visible through Jenkins screens)";
        }
    }
}

