/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend.grafana;

import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.opentelemetry.TemplateBindingsProvider;
import io.jenkins.plugins.opentelemetry.backend.ObservabilityBackend;
import io.jenkins.plugins.opentelemetry.job.log.LogStorageRetriever;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class GrafanaLogsBackend
extends AbstractDescribableImpl<GrafanaLogsBackend>
implements ExtensionPoint {
    private static final Logger logger = Logger.getLogger(GrafanaLogsBackend.class.getName());
    private transient Template buildLogsVisualizationUrlGTemplate;
    protected LokiOTelLogFormat lokiOTelLogFormat;

    @CheckForNull
    @MustBeClosed
    public abstract LogStorageRetriever newLogStorageRetriever(TemplateBindingsProvider var1);

    @NonNull
    public Template getBuildLogsVisualizationMessageTemplate() {
        try {
            return new GStringTemplateEngine().createTemplate("View build logs in ${backendName}");
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @NonNull
    public Template getBuildLogsVisualizationUrlTemplate() {
        if (this.buildLogsVisualizationUrlGTemplate == null) {
            String START = "__START__";
            String END = "__END__";
            JsonObject panesAsJson = Json.createObjectBuilder().add("NZj", Json.createObjectBuilder().add("datasource", "__START__grafanaLokiDatasourceIdentifier__END__").add("queries", Json.createArrayBuilder().add(Json.createObjectBuilder().add("refId", "A").add("expr", switch (Optional.ofNullable(this.lokiOTelLogFormat).orElse(LokiOTelLogFormat.LOKI_V2_JSON_OTEL_FORMAT).ordinal()) {
                case 1 -> "{service_name=\"__START__serviceName__END__\"} | trace_id=\"__START__traceId__END__\"";
                default -> "{job=\"__START__serviceNamespaceAndName__END__\"} | json | traceid=\"__START__traceId__END__\" | line_format \"{{.body}}\"";
            }).add("queryType", "range").add("datasource", Json.createObjectBuilder().add("type", "loki").add("uid", "__START__grafanaLokiDatasourceIdentifier__END__")).add("editorMode", "code"))).add("range", Json.createObjectBuilder().add("from", "--start_time--").add("to", "--end_time--"))).build();
            StringWriter panesAsStringWriter = new StringWriter();
            Json.createWriter((Writer)panesAsStringWriter).writeObject(panesAsJson);
            String panes = URLEncoder.encode(panesAsStringWriter.toString(), StandardCharsets.UTF_8).replace("__START__", "${").replace("__END__", "}").replace("--start_time--", "${startTime.minus(1, java.time.temporal.ChronoUnit.DAYS).atZone(java.util.TimeZone.getDefault().toZoneId()).toInstant().toEpochMilli()}").replace("--end_time--", "${endTime.plus(1, java.time.temporal.ChronoUnit.DAYS).atZone(java.util.TimeZone.getDefault().toZoneId()).toInstant().toEpochMilli()}");
            String urlTemplate = "${grafanaBaseUrl}/explore?panes=" + panes + "&schemaVersion=1&orgId=${grafanaOrgId}";
            GStringTemplateEngine gStringTemplateEngine = new GStringTemplateEngine();
            try {
                this.buildLogsVisualizationUrlGTemplate = gStringTemplateEngine.createTemplate(urlTemplate);
            }
            catch (IOException | ClassNotFoundException e) {
                logger.log(Level.WARNING, "Invalid build logs Visualisation URL Template '" + urlTemplate + "'", e);
                this.buildLogsVisualizationUrlGTemplate = ObservabilityBackend.ERROR_TEMPLATE;
            }
        }
        return this.buildLogsVisualizationUrlGTemplate;
    }

    public Map<String, String> getOtelConfigurationProperties() {
        return Collections.singletonMap("otel.logs.exporter", "otlp");
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @NonNull
    public String getLokiOTelLogFormat() {
        return Optional.ofNullable(this.lokiOTelLogFormat).map(Enum::name).orElse(this.getDescriptor().getDefaultLokiOTelLogFormat());
    }

    @DataBoundSetter
    public void setLokiOTelLogFormat(String lokiOTelLogFormat) {
        this.lokiOTelLogFormat = LokiOTelLogFormat.valueOf(lokiOTelLogFormat);
    }

    public static DescriptorExtensionList<GrafanaLogsBackend, Descriptor<GrafanaLogsBackend>> all() {
        return Jenkins.get().getDescriptorList(GrafanaLogsBackend.class);
    }

    public static enum LokiOTelLogFormat {
        LOKI_V2_JSON_OTEL_FORMAT("Loki V2 OTel logs format as JSON"),
        LOKI_V3_OTEL_FORMAT("Loki V3 OTel logs format using Loki labels and structured metadata");

        final String displayName;

        private LokiOTelLogFormat(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    public static abstract class DescriptorImpl
    extends Descriptor<GrafanaLogsBackend> {
        public ListBoxModel doFillLokiOTelLogFormatItems() {
            ListBoxModel items = new ListBoxModel();
            for (LokiOTelLogFormat lokiOTelLogFormat : LokiOTelLogFormat.values()) {
                items.add(lokiOTelLogFormat.getDisplayName(), lokiOTelLogFormat.name());
            }
            return items;
        }

        public abstract String getDefaultLokiOTelLogFormat();
    }
}

