/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend.elastic;

import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import io.jenkins.plugins.opentelemetry.TemplateBindingsProvider;
import io.jenkins.plugins.opentelemetry.backend.ElasticBackend;
import io.jenkins.plugins.opentelemetry.backend.ObservabilityBackend;
import io.jenkins.plugins.opentelemetry.job.log.LogStorageRetriever;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public abstract class ElasticLogsBackend
extends AbstractDescribableImpl<ElasticLogsBackend>
implements ExtensionPoint {
    private static final Logger logger = Logger.getLogger(ElasticLogsBackend.class.getName());
    private transient Template buildLogsVisualizationUrlGTemplate;

    @CheckForNull
    @MustBeClosed
    public abstract LogStorageRetriever newLogStorageRetriever(TemplateBindingsProvider var1);

    public Template getBuildLogsVisualizationMessageTemplate() {
        try {
            return new GStringTemplateEngine().createTemplate("View build logs in ${backendName}");
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public Template getBuildLogsVisualizationUrlTemplate() {
        if (this.buildLogsVisualizationUrlGTemplate == null) {
            String kibanaSpaceBaseUrl = this.getEffectiveKibanaURL();
            String urlTemplate = kibanaSpaceBaseUrl + "/app/discover#/?_a=(columns:!(message),dataSource:(dataViewId:discover-observability-solution-all-logs,type:dataView),filters:!((meta:(alias:!n,disabled:!f,field:trace.id,index:discover-observability-solution-all-logs,key:trace.id,negate:!f,params:(query:%27${traceId}%27),type:phrase),query:(match_phrase:(trace.id:%27${traceId}%27)))))&_g=(filters:!(),time:(from:now-40d,to:now))";
            GStringTemplateEngine gStringTemplateEngine = new GStringTemplateEngine();
            try {
                this.buildLogsVisualizationUrlGTemplate = gStringTemplateEngine.createTemplate(urlTemplate);
            }
            catch (IOException | ClassNotFoundException e) {
                logger.log(Level.WARNING, "Invalid build logs Visualisation URL Template '" + urlTemplate + "'", e);
                this.buildLogsVisualizationUrlGTemplate = ObservabilityBackend.ERROR_TEMPLATE;
            }
        }
        return this.buildLogsVisualizationUrlGTemplate;
    }

    public Map<String, String> getOtelConfigurationProperties() {
        return Collections.singletonMap("otel.logs.exporter", "otlp");
    }

    private String getEffectiveKibanaURL() {
        String ret = "";
        Optional<ElasticBackend> backend = ElasticBackend.get();
        if (!backend.isEmpty()) {
            ElasticBackend elasticLogsBackend = backend.get();
            ret = elasticLogsBackend.getEffectiveKibanaURL();
        }
        return ret;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static DescriptorExtensionList<ElasticLogsBackend, Descriptor<ElasticLogsBackend>> all() {
        return Jenkins.get().getDescriptorList(ElasticLogsBackend.class);
    }

    public static abstract class DescriptorImpl
    extends Descriptor<ElasticLogsBackend> {
    }
}

