/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.FormValidation;
import io.jenkins.plugins.opentelemetry.backend.ObservabilityBackend;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class JaegerBackend
extends ObservabilityBackend {
    public static final String OTEL_JAEGER_URL = "OTEL_JAEGER_URL";
    public static final String DEFAULT_NAME = "Jaeger";
    private String jaegerBaseUrl;

    @DataBoundConstructor
    public JaegerBackend() {
    }

    @Override
    public Map<String, Object> mergeBindings(Map<String, Object> bindings) {
        HashMap<String, Object> mergedBindings = new HashMap<String, Object>(bindings);
        mergedBindings.put("jaegerBaseUrl", this.jaegerBaseUrl);
        return mergedBindings;
    }

    @Override
    @CheckForNull
    public String getTraceVisualisationUrlTemplate() {
        return "${jaegerBaseUrl}/trace/${traceId}";
    }

    public String getJaegerBaseUrl() {
        return this.jaegerBaseUrl;
    }

    @DataBoundSetter
    public void setJaegerBaseUrl(String jaegerBaseUrl) {
        this.jaegerBaseUrl = jaegerBaseUrl;
    }

    @Override
    @CheckForNull
    public String getIconPath() {
        return "icon-otel-jaeger";
    }

    @Override
    @CheckForNull
    public String getEnvVariableName() {
        return OTEL_JAEGER_URL;
    }

    @Override
    @CheckForNull
    public String getDefaultName() {
        return DEFAULT_NAME;
    }

    @Override
    @CheckForNull
    public String getMetricsVisualizationUrlTemplate() {
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj instanceof JaegerBackend;
    }

    @Override
    public int hashCode() {
        return JaegerBackend.class.hashCode();
    }

    @Override
    public Map<String, Object> getBindings() {
        return Map.of("backendName", this.getName(), "backend24x24IconUrl", "/plugin/opentelemetry/images/24x24/jaeger.png");
    }

    static {
        IconSet.icons.addIcon(new Icon("icon-otel-jaeger icon-sm", "plugin/opentelemetry/images/svgs/jaeger.svg", "width: 16px; height: 16px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-jaeger icon-md", "plugin/opentelemetry/images/svgs/jaeger.svg", "width: 24px; height: 24px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-jaeger icon-lg", "plugin/opentelemetry/images/svgs/jaeger.svg", "width: 32px; height: 32px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-jaeger icon-xlg", "plugin/opentelemetry/images/svgs/jaeger.svg", "width: 48px; height: 48px;"));
    }

    @Extension
    @Symbol(value={"jaeger"})
    public static class DescriptorImpl
    extends ObservabilityBackend.ObservabilityBackendDescriptor {
        @NonNull
        public String getDisplayName() {
            return JaegerBackend.DEFAULT_NAME;
        }

        public FormValidation doCheckJaegerBaseUrl(@QueryParameter String jaegerBaseUrl) {
            if (jaegerBaseUrl == null || jaegerBaseUrl.isEmpty()) {
                return FormValidation.ok();
            }
            try {
                new URL(jaegerBaseUrl);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)("Invalid URL: " + e.getMessage()));
            }
            return FormValidation.ok();
        }
    }
}

