/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.opentelemetry.TemplateBindingsProvider;
import io.jenkins.plugins.opentelemetry.backend.ObservabilityBackend;
import io.jenkins.plugins.opentelemetry.backend.grafana.GrafanaLogsBackend;
import io.jenkins.plugins.opentelemetry.job.log.LogStorageRetriever;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GrafanaBackend
extends ObservabilityBackend {
    public static final String DEFAULT_BACKEND_NAME = "Grafana";
    public static final String OTEL_GRAFANA_URL = "OTEL_GRAFANA_URL";
    private static final String DEFAULT_TEMPO_DATA_SOURCE_IDENTIFIER = "grafanacloud-traces";
    public static final String DEFAULT_LOKI_DATA_SOURCE_IDENTIFIER = "grafanacloud-logs";
    private static final String DEFAULT_GRAFANA_ORG_ID = "1";
    private static final String DEFAULT_TEMPO_QUERY_TYPE = "traceql";
    private String grafanaBaseUrl;
    private String grafanaMetricsDashboard;
    private String tempoDataSourceIdentifier = "grafanacloud-traces";
    private String grafanaOrgId = "1";
    private String tempoQueryType = "traceql";
    private GrafanaLogsBackend grafanaLogsBackend;

    @DataBoundConstructor
    public GrafanaBackend() {
    }

    @Override
    @Nullable
    public String getTraceVisualisationUrlTemplate() {
        return "${grafanaBaseUrl}/explore?orgId=${grafanaOrgId}&left=%7B%22datasource%22:%22${grafanaTempoDatasourceIdentifier}%22,%22queries%22:%5B%7B%22refId%22:%22A%22,%22datasource%22:%7B%22type%22:%22tempo%22,%22uid%22:%22${grafanaTempoDatasourceIdentifier}%22%7D,%22queryType%22:%22${grafanaTempoQueryType}%22,%22query%22:%22${traceId}%22%7D%5D,%22range%22:%7B%22from%22:%22${startTime.minusSeconds(600).atZone(java.util.TimeZone.getDefault().toZoneId()).toInstant().toEpochMilli()}%22,%22to%22:%22${startTime.plusSeconds(600).atZone(java.util.TimeZone.getDefault().toZoneId()).toInstant().toEpochMilli()}%22%7D%7D";
    }

    @Override
    @Nullable
    public String getMetricsVisualizationUrlTemplate() {
        return this.grafanaMetricsDashboard;
    }

    @Override
    @Nullable
    public String getIconPath() {
        return "icon-otel-grafana";
    }

    @Override
    @Nullable
    public String getEnvVariableName() {
        return OTEL_GRAFANA_URL;
    }

    @Override
    @Nullable
    public String getDefaultName() {
        return DEFAULT_BACKEND_NAME;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrafanaBackend that = (GrafanaBackend)o;
        return Objects.equals(this.grafanaOrgId, that.grafanaOrgId) && Objects.equals(this.grafanaBaseUrl, that.grafanaBaseUrl) && Objects.equals(this.tempoDataSourceIdentifier, that.tempoDataSourceIdentifier) && Objects.equals(this.tempoQueryType, that.tempoQueryType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.grafanaBaseUrl, this.tempoDataSourceIdentifier, this.grafanaOrgId, this.tempoQueryType);
    }

    @Override
    public Map<String, Object> mergeBindings(Map<String, Object> bindings) {
        HashMap<String, Object> mergedBindings = new HashMap<String, Object>(bindings);
        mergedBindings.putAll(this.getBindings());
        return mergedBindings;
    }

    @Override
    public Map<String, Object> getBindings() {
        Map<String, Object> bindings = Map.of("backendName", this.getName(), "backend24x24IconUrl", "/plugin/opentelemetry/images/24x24/grafana.png", "grafanaBaseUrl", this.getGrafanaBaseUrl(), "grafanaOrgId", String.valueOf(this.getGrafanaOrgId()), "grafanaTempoDatasourceIdentifier", this.getTempoDataSourceIdentifier(), "grafanaTempoQueryType", this.getTempoQueryType());
        if (this.grafanaLogsBackend instanceof TemplateBindingsProvider) {
            Map<String, Object> logsBackendBindings = ((TemplateBindingsProvider)((Object)this.grafanaLogsBackend)).getBindings();
            HashMap<String, Object> result = new HashMap<String, Object>(bindings);
            result.putAll(logsBackendBindings);
            return result;
        }
        return bindings;
    }

    @Override
    @CheckForNull
    public LogStorageRetriever newLogStorageRetriever(TemplateBindingsProvider templateBindingsProvider) {
        return Optional.ofNullable(this.grafanaLogsBackend).map(b -> b.newLogStorageRetriever(templateBindingsProvider)).orElse(null);
    }

    public String getGrafanaBaseUrl() {
        return this.grafanaBaseUrl;
    }

    @DataBoundSetter
    public void setGrafanaBaseUrl(String grafanaBaseUrl) {
        this.grafanaBaseUrl = grafanaBaseUrl;
    }

    @DataBoundSetter
    public String getTempoDataSourceIdentifier() {
        return this.tempoDataSourceIdentifier;
    }

    @DataBoundSetter
    public void setTempoDataSourceIdentifier(String tempoDataSourceIdentifier) {
        this.tempoDataSourceIdentifier = tempoDataSourceIdentifier;
    }

    @DataBoundSetter
    public void setGrafanaMetricsDashboard(String grafanaMetricsDashboard) {
        this.grafanaMetricsDashboard = grafanaMetricsDashboard;
    }

    public String getGrafanaOrgId() {
        return this.grafanaOrgId;
    }

    @DataBoundSetter
    public void setGrafanaOrgId(String grafanaOrgId) {
        this.grafanaOrgId = grafanaOrgId;
    }

    @DataBoundSetter
    public String getTempoQueryType() {
        return this.tempoQueryType;
    }

    @DataBoundSetter
    public void setTempoQueryType(String tempoQueryType) {
        this.tempoQueryType = tempoQueryType;
    }

    @CheckForNull
    public GrafanaLogsBackend getGrafanaLogsBackend() {
        return this.grafanaLogsBackend;
    }

    @DataBoundSetter
    public void setGrafanaLogsBackend(GrafanaLogsBackend grafanaLogsBackend) {
        this.grafanaLogsBackend = grafanaLogsBackend;
    }

    @Override
    @NonNull
    public Map<String, String> getOtelConfigurationProperties() {
        if (this.grafanaLogsBackend == null) {
            return Collections.emptyMap();
        }
        return this.grafanaLogsBackend.getOtelConfigurationProperties();
    }

    static {
        IconSet.icons.addIcon(new Icon("icon-otel-grafana icon-sm", "plugin/opentelemetry/images/svgs/grafana.svg", "width: 16px; height: 16px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-grafana icon-md", "plugin/opentelemetry/images/svgs/grafana.svg", "width: 24px; height: 24px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-grafana icon-lg", "plugin/opentelemetry/images/svgs/grafana.svg", "width: 32px; height: 32px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-grafana icon-xlg", "plugin/opentelemetry/images/svgs/grafana.svg", "width: 48px; height: 48px;"));
    }

    public static interface TemplateBindings
    extends ObservabilityBackend.TemplateBindings {
        public static final String GRAFANA_BASE_URL = "grafanaBaseUrl";
        public static final String GRAFANA_TEMPO_DATASOURCE_IDENTIFIER = "grafanaTempoDatasourceIdentifier";
        public static final String GRAFANA_LOKI_DATASOURCE_IDENTIFIER = "grafanaLokiDatasourceIdentifier";
        public static final String GRAFANA_ORG_ID = "grafanaOrgId";
        public static final String GRAFANA_TEMPO_QUERY_TYPE = "grafanaTempoQueryType";
    }

    @Extension
    @Symbol(value={"grafana"})
    public static class DescriptorImpl
    extends ObservabilityBackend.ObservabilityBackendDescriptor {
        @NonNull
        public String getDisplayName() {
            return GrafanaBackend.DEFAULT_BACKEND_NAME;
        }

        public String getDefaultGrafanaOrgId() {
            return GrafanaBackend.DEFAULT_GRAFANA_ORG_ID;
        }

        public String getDefaultTempoDataSourceIdentifier() {
            return GrafanaBackend.DEFAULT_TEMPO_DATA_SOURCE_IDENTIFIER;
        }

        public String getDefaultTempoQueryType() {
            return GrafanaBackend.DEFAULT_TEMPO_QUERY_TYPE;
        }

        public FormValidation doCheckGrafanaBaseUrl(@QueryParameter(value="grafanaBaseUrl") String grafanaBaseUrl) {
            if (StringUtils.isEmpty((String)grafanaBaseUrl)) {
                return FormValidation.ok();
            }
            try {
                new URI(grafanaBaseUrl).toURL();
            }
            catch (MalformedURLException | URISyntaxException e) {
                return FormValidation.error((String)("Invalid URL: " + e.getMessage()));
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillTempoQueryTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Query Tempo using TraceQL", GrafanaBackend.DEFAULT_TEMPO_QUERY_TYPE);
            items.add("Query Tempo by TraceID (older Tempo versions)", "traceid");
            return items;
        }
    }
}

