/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.opentelemetry.backend.ObservabilityBackend;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class DynatraceGrailBackend
extends ObservabilityBackend {
    public static final String OTEL_DYNATRACE_URL = "OTEL_DYNATRACE_URL";
    public static final String DEFAULT_NAME = "Dynatrace (Grail)";
    private final String url;

    @DataBoundConstructor
    public DynatraceGrailBackend(String url) {
        if (url != null && !((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        this.url = url;
    }

    @Override
    public Map<String, Object> mergeBindings(Map<String, Object> bindings) {
        HashMap<String, Object> mergedBindings = new HashMap<String, Object>(bindings);
        mergedBindings.put("dynatraceBaseUrl", this.url);
        return mergedBindings;
    }

    @Override
    @NonNull
    public String getTraceVisualisationUrlTemplate() {
        return "${dynatraceBaseUrl}ui/apps/dynatrace.distributedtracing/explorer?v=spans&filter=trace.id+%3D+${traceId}&traceId=${traceId}&cv=a%2Cfalse&sidebar=a%2Cfalse";
    }

    @Override
    @CheckForNull
    public String getMetricsVisualizationUrlTemplate() {
        String filtersAndColumns = "ui/apps/dynatrace.distributedtracing/explorer?filter=ci.pipeline.name+%3D+*+OR+jenkins.pipeline.step.name+%3D+*&columns=start_time%2Cspan.name%2Cduration%2Crequest.status_code%2Cci.pipeline.name%2Cci.pipeline.run.cause%2Cci.pipeline.run.durationMillis%2Cjenkins.pipeline.step.plugin.name%2Cjenkins.pipeline.step.name%2Cjenkins.pipeline.step.result%2Cci.pipeline.run.user%2Cjenkins.url&sidebar=u%2Cfalse&v=spans&tf=-7d%3Bnow";
        return "${dynatraceBaseUrl}" + filtersAndColumns;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    @NonNull
    public String getIconPath() {
        return "icon-otel-dynatrace";
    }

    @Override
    @NonNull
    public String getEnvVariableName() {
        return OTEL_DYNATRACE_URL;
    }

    @Override
    @NonNull
    public String getDefaultName() {
        return DEFAULT_NAME;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynatraceGrailBackend that = (DynatraceGrailBackend)o;
        return Objects.equals(this.url, that.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.url);
    }

    @Override
    public Map<String, Object> getBindings() {
        return Map.of("backendName", this.getName(), "backend24x24IconUrl", "/plugin/opentelemetry/images/svgs/dynatrace.svg");
    }

    static {
        IconSet.icons.addIcon(new Icon("icon-otel-dynatrace icon-sm", "plugin/opentelemetry/images/svgs/dynatrace.svg", "width: 16px; height: 16px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-dynatrace icon-md", "plugin/opentelemetry/images/svgs/dynatrace.svg", "width: 24px; height: 24px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-dynatrace icon-lg", "plugin/opentelemetry/images/svgs/dynatrace.svg", "width: 32px; height: 32px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-dynatrace icon-xlg", "plugin/opentelemetry/images/svgs/dynatrace.svg", "width: 48px; height: 48px;"));
    }

    @Extension
    @Symbol(value={"dynatrace"})
    public static class DescriptorImpl
    extends ObservabilityBackend.ObservabilityBackendDescriptor {
        @NonNull
        public String getDisplayName() {
            return DynatraceGrailBackend.DEFAULT_NAME;
        }
    }
}

