/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.administrativemonitor;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import io.jenkins.plugins.opentelemetry.JenkinsOpenTelemetryPluginConfiguration;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class ObservabilityBackendCheckAdministrativeMonitor
extends AdministrativeMonitor {
    JenkinsOpenTelemetryPluginConfiguration pluginConfiguration;

    public boolean isActivated() {
        boolean pluginConfiguredToPublishData = StringUtils.isNotBlank((String)this.pluginConfiguration.getEndpoint());
        return pluginConfiguredToPublishData && this.pluginConfiguration.getObservabilityBackends().isEmpty();
    }

    public String getDisplayName() {
        return "OpenTelemetry - No Observability Backend Defined";
    }

    @Inject
    public void setJenkinsOpenTelemetryPluginConfiguration(JenkinsOpenTelemetryPluginConfiguration jenkinsOpenTelemetryPluginConfiguration) {
        this.pluginConfiguration = jenkinsOpenTelemetryPluginConfiguration;
    }

    @RequirePOST
    public HttpResponse doAct(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        if (req.hasParameter("no")) {
            this.disable(true);
        }
        return HttpResponses.redirectViaContextPath((String)"/configure");
    }
}

