/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry;

import hudson.Extension;
import hudson.model.RootAction;
import io.jenkins.plugins.opentelemetry.JenkinsOpenTelemetryPluginConfiguration;
import io.jenkins.plugins.opentelemetry.api.ReconfigurableOpenTelemetry;
import io.jenkins.plugins.opentelemetry.backend.ObservabilityBackend;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;

@Extension
public class OpenTelemetryRootAction
implements RootAction {
    private static final Logger logger = Logger.getLogger(OpenTelemetryRootAction.class.getName());
    private JenkinsOpenTelemetryPluginConfiguration pluginConfiguration;
    private ReconfigurableOpenTelemetry openTelemetry;

    public Optional<ObservabilityBackend> getFirstMetricsCapableObservabilityBackend() {
        Optional<ObservabilityBackend> observabilityBackend = this.pluginConfiguration.getObservabilityBackends().stream().filter(backend -> backend.getMetricsVisualizationUrlTemplate() != null).findFirst();
        logger.log(Level.FINE, () -> "getFirstMetricsCapableObservabilityBackend: " + String.valueOf(observabilityBackend.orElse(null)));
        return observabilityBackend;
    }

    public String getIconFileName() {
        return this.getFirstMetricsCapableObservabilityBackend().map(ObservabilityBackend::getIconPath).map(icon -> icon + " icon-md").orElse(null);
    }

    public String getDisplayName() {
        return this.getFirstMetricsCapableObservabilityBackend().map(ObservabilityBackend::getName).orElse(null);
    }

    public String getUrlName() {
        return this.getFirstMetricsCapableObservabilityBackend().map(backend -> backend.getMetricsVisualizationUrl(this.openTelemetry.getResource())).orElse(null);
    }

    @Inject
    public void setJenkinsOpenTelemetryPluginConfiguration(JenkinsOpenTelemetryPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    @Inject
    public void setOpenTelemetry(ReconfigurableOpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }
}

