/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest5_client.low_level;

import java.util.concurrent.CancellationException;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.concurrent.CancellableDependency;

public abstract class Cancellable
implements org.apache.hc.core5.concurrent.Cancellable {
    static final Cancellable NO_OP = new Cancellable(){

        public boolean cancel() {
            throw new UnsupportedOperationException();
        }

        @Override
        void runIfNotCancelled(Runnable runnable) {
            throw new UnsupportedOperationException();
        }
    };

    abstract void runIfNotCancelled(Runnable var1);

    static Cancellable fromRequest(HttpUriRequestBase httpRequest) {
        return new RequestCancellable(httpRequest);
    }

    static CancellationException newCancellationException() {
        return new CancellationException("request was cancelled");
    }

    private static class RequestCancellable
    extends Cancellable {
        private final CancellableDependency httpRequest;

        private RequestCancellable(HttpUriRequestBase httpRequest) {
            this.httpRequest = httpRequest;
        }

        public synchronized boolean cancel() {
            return this.httpRequest.cancel();
        }

        @Override
        synchronized void runIfNotCancelled(Runnable runnable) {
            if (this.httpRequest.isCancelled()) {
                throw RequestCancellable.newCancellationException();
            }
            runnable.run();
        }
    }
}

