/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.User;
import io.jenkins.plugins.opentelemetry.JenkinsControllerOpenTelemetry;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.semconv.ClientAttributes;
import io.opentelemetry.semconv.incubating.EnduserIncubatingAttributes;
import io.opentelemetry.semconv.incubating.EventIncubatingAttributes;
import io.opentelemetry.semconv.incubating.UserIncubatingAttributes;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jenkins.YesNoMaybe;
import jenkins.security.SecurityListener;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

@Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
public class AuditingSecurityListener
extends SecurityListener
implements OpenTelemetryLifecycleListener {
    private static final Logger LOGGER = Logger.getLogger(AuditingSecurityListener.class.getName());
    private LongCounter loginSuccessCounter;
    private LongCounter loginFailureCounter;
    private LongCounter loginCounter;
    private io.opentelemetry.api.logs.Logger otelLogger;
    private JenkinsControllerOpenTelemetry jenkinsControllerOpenTelemetry;

    @PostConstruct
    public void postConstruct() {
        LOGGER.log(Level.FINE, () -> "Start monitoring Jenkins controller authentication events...");
        this.otelLogger = GlobalOpenTelemetry.get().getLogsBridge().get("io.jenkins.opentelemetry");
        Meter meter = this.jenkinsControllerOpenTelemetry.getDefaultMeter();
        this.loginSuccessCounter = meter.counterBuilder("login_success").setDescription("Successful logins").setUnit("${logins}").build();
        this.loginFailureCounter = meter.counterBuilder("login_failure").setDescription("Failing logins").setUnit("${logins}").build();
        this.loginCounter = meter.counterBuilder("login").setDescription("Logins").setUnit("${logins}").build();
    }

    protected void authenticated2(@NonNull UserDetails details) {
        super.authenticated2(details);
    }

    protected void failedToAuthenticate(@NonNull String username) {
        super.failedToAuthenticate(username);
    }

    protected void loggedIn(@NonNull String username) {
        Authentication authentication;
        Object details;
        this.loginCounter.add(1L);
        this.loginSuccessCounter.add(1L);
        String message = "Successful login of user '" + username + "'";
        AttributesBuilder attributesBuilder = Attributes.builder();
        Optional<User> user = Optional.ofNullable(User.current());
        attributesBuilder.put(EventIncubatingAttributes.EVENT_NAME, (Object)"user_login").put(ExtendedJenkinsAttributes.EVENT_CATEGORY, (Object)"authentication").put(ExtendedJenkinsAttributes.EVENT_OUTCOME, (Object)"success").put(EnduserIncubatingAttributes.ENDUSER_ID, (Object)user.map(User::getId).orElse(username)).put(UserIncubatingAttributes.USER_ID, (Object)user.map(User::getId).orElse(username));
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext != null && (details = (authentication = securityContext.getAuthentication()).getDetails()) instanceof WebAuthenticationDetails) {
            WebAuthenticationDetails webAuthenticationDetails = (WebAuthenticationDetails)details;
            attributesBuilder.put(ClientAttributes.CLIENT_ADDRESS, (Object)webAuthenticationDetails.getRemoteAddress());
            message = message + " from " + webAuthenticationDetails.getRemoteAddress();
        }
        this.otelLogger.logRecordBuilder().setAllAttributes(attributesBuilder.build()).setSeverity(Severity.INFO).setBody(message).emit();
    }

    protected void failedToLogIn(@NonNull String username) {
        this.loginCounter.add(1L);
        this.loginFailureCounter.add(1L);
        String message = "Failed login of user '" + username + "'";
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributesBuilder.put(EventIncubatingAttributes.EVENT_NAME, (Object)"user_login").put(ExtendedJenkinsAttributes.EVENT_CATEGORY, (Object)"authentication").put(ExtendedJenkinsAttributes.EVENT_OUTCOME, (Object)"failure").put(EnduserIncubatingAttributes.ENDUSER_ID, (Object)username).put(UserIncubatingAttributes.USER_ID, (Object)username);
        this.otelLogger.logRecordBuilder().setAllAttributes(attributesBuilder.build()).setSeverity(Severity.WARN).setBody(message).emit();
    }

    @Inject
    public void setJenkinsControllerOpenTelemetry(JenkinsControllerOpenTelemetry jenkinsControllerOpenTelemetry) {
        this.jenkinsControllerOpenTelemetry = jenkinsControllerOpenTelemetry;
    }
}

