/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.queue;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Queue;
import hudson.model.queue.QueueListener;
import io.jenkins.plugins.opentelemetry.JenkinsControllerOpenTelemetry;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.jenkins.plugins.opentelemetry.queue.RemoteSpanAction;
import io.jenkins.plugins.opentelemetry.semconv.ConfigurationKey;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jenkins.YesNoMaybe;
import jenkins.model.Jenkins;

@Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
public class MonitoringQueueListener
extends QueueListener
implements OpenTelemetryLifecycleListener {
    private static final Logger LOGGER = Logger.getLogger(MonitoringQueueListener.class.getName());
    private LongCounter leftItemCounter;
    private LongCounter timeInQueueInMillisCounter;
    @Inject
    private JenkinsControllerOpenTelemetry jenkinsControllerOpenTelemetry;
    private final AtomicBoolean traceContextPropagationEnabled = new AtomicBoolean(false);

    public void afterConfiguration(ConfigProperties configProperties) {
        this.traceContextPropagationEnabled.set(configProperties.getBoolean(ConfigurationKey.OTEL_INSTRUMENTATION_JENKINS_REMOTE_SPAN_ENABLED.asProperty(), false));
    }

    @PostConstruct
    public void postConstruct() {
        LOGGER.log(Level.FINE, () -> "Start monitoring Jenkins queue...");
        Meter meter = this.jenkinsControllerOpenTelemetry.getDefaultMeter();
        ObservableLongMeasurement queueItems = meter.gaugeBuilder("jenkins.queue.count").ofLongs().setDescription("Number of tasks in the queue").setUnit("${tasks}").buildObserver();
        ObservableLongMeasurement queueWaitingItems = meter.gaugeBuilder("jenkins.queue.waiting").ofLongs().setDescription("Number of tasks in the queue with the status 'waiting', 'buildable' or 'pending'").setUnit("{tasks}").buildObserver();
        ObservableLongMeasurement queueBlockedItems = meter.gaugeBuilder("jenkins.queue.blocked").ofLongs().setDescription("Number of blocked tasks in the queue. Note that waiting for an executor to be available is not a reason to be counted as blocked").setUnit("{tasks}").buildObserver();
        ObservableLongMeasurement queueBuildableItems = meter.gaugeBuilder("jenkins.queue.buildable").ofLongs().setDescription("Number of tasks in the queue with the status 'buildable' or 'pending'").setUnit("{tasks}").buildObserver();
        meter.batchCallback(() -> {
            LOGGER.log(Level.FINE, () -> "Recording Jenkins queue metrics...");
            Optional<Queue> queue = Optional.ofNullable(Jenkins.getInstanceOrNull()).map(Jenkins::getQueue);
            queue.map(Queue::getItems).ifPresent(items -> {
                AtomicInteger blocked = new AtomicInteger();
                AtomicInteger buildable = new AtomicInteger();
                AtomicInteger left = new AtomicInteger();
                AtomicInteger stuck = new AtomicInteger();
                AtomicInteger unknown = new AtomicInteger();
                AtomicInteger waiting = new AtomicInteger();
                Arrays.stream(items).forEach(item -> {
                    if (item instanceof Queue.BlockedItem) {
                        blocked.incrementAndGet();
                    } else if (item instanceof Queue.BuildableItem) {
                        if (item.isStuck()) {
                            stuck.incrementAndGet();
                        } else {
                            buildable.incrementAndGet();
                        }
                    } else if (item instanceof Queue.WaitingItem) {
                        waiting.incrementAndGet();
                    } else if (item instanceof Queue.LeftItem) {
                        left.incrementAndGet();
                    } else {
                        LOGGER.log(Level.INFO, () -> "Unknown item: " + String.valueOf(item) + " - class=" + String.valueOf(item.getClass()));
                        unknown.incrementAndGet();
                    }
                });
                queueItems.record((long)blocked.get(), Attributes.of(ExtendedJenkinsAttributes.STATUS, (Object)"blocked"));
                queueBlockedItems.record((long)blocked.get());
                queueItems.record((long)buildable.get(), Attributes.of(ExtendedJenkinsAttributes.STATUS, (Object)"buildable"));
                queueBuildableItems.record((long)buildable.get());
                queueItems.record((long)stuck.get(), Attributes.of(ExtendedJenkinsAttributes.STATUS, (Object)"stuck"));
                if (unknown.get() > 0) {
                    queueItems.record((long)unknown.get(), Attributes.of(ExtendedJenkinsAttributes.STATUS, (Object)"unknown"));
                }
                queueItems.record((long)waiting.get(), Attributes.of(ExtendedJenkinsAttributes.STATUS, (Object)"waiting"));
                queueWaitingItems.record((long)waiting.get());
            });
        }, (ObservableMeasurement)queueItems, new ObservableMeasurement[]{queueWaitingItems, queueBlockedItems, queueBuildableItems});
        this.leftItemCounter = meter.counterBuilder("jenkins.queue.left").setDescription("Total count of tasks that have been processed").setUnit("{tasks}").build();
        this.timeInQueueInMillisCounter = meter.counterBuilder("jenkins.queue.time_spent_millis").setDescription("Total time spent in queue by the tasks that have been processed").setUnit("ms").build();
    }

    public void onLeft(Queue.LeftItem li) {
        this.leftItemCounter.add(1L);
        this.timeInQueueInMillisCounter.add(System.currentTimeMillis() - li.getInQueueSince());
        LOGGER.log(Level.FINE, () -> "onLeft(): " + String.valueOf(li));
    }

    public void onEnterWaiting(Queue.WaitingItem wi) {
        Span span;
        if (this.traceContextPropagationEnabled.get() && (span = Span.fromContextOrNull((Context)Context.current())) != null) {
            SpanContext spanContext = span.getSpanContext();
            wi.addAction((Action)new RemoteSpanAction(spanContext.getTraceId(), spanContext.getSpanId(), spanContext.getTraceFlags().asByte(), spanContext.getTraceState().asMap()));
            LOGGER.log(Level.FINE, () -> "attach RemoteSpanAction to " + String.valueOf(wi));
        }
    }
}

