/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.opentelemetry.common;

import io.opentelemetry.sdk.common.Clock;
import java.util.concurrent.atomic.AtomicReference;

public class Clocks {
    private Clocks() {
    }

    public static Clock monotonicOffsetClock(long offsetInNanos) {
        return new MonotonicClock(new OffsetClock(offsetInNanos, Clock.getDefault()));
    }

    public static Clock offsetClock(long offsetInNanos, Clock baseClock) {
        return new OffsetClock(offsetInNanos, baseClock);
    }

    public static Clock monotonicClock(Clock delegate) {
        return new MonotonicClock(delegate);
    }

    public static Clock monotonicClock() {
        return Clocks.monotonicClock(Clock.getDefault());
    }

    private static class MonotonicClock
    implements Clock {
        private final Clock delegate;
        private final AtomicReference<Long> lastNanoTime = new AtomicReference<Long>(0L);

        public MonotonicClock(Clock delegate) {
            this.delegate = delegate;
        }

        public long now() {
            return this.lastNanoTime.updateAndGet(current -> Math.max(current + 1L, this.delegate.now()));
        }

        public long now(boolean highPrecision) {
            return this.lastNanoTime.updateAndGet(current -> Math.max(current + 1L, this.delegate.now(highPrecision)));
        }

        public long nanoTime() {
            return this.lastNanoTime.updateAndGet(current -> Math.max(current + 1L, this.delegate.nanoTime()));
        }
    }

    private static class OffsetClock
    implements Clock {
        private final long offsetInNanos;
        private final Clock baseClock;

        private OffsetClock(long offsetInNanos, Clock baseClock) {
            this.offsetInNanos = offsetInNanos;
            this.baseClock = baseClock;
        }

        public long now() {
            return this.baseClock.now() + this.offsetInNanos;
        }

        public long nanoTime() {
            return this.baseClock.nanoTime() + this.offsetInNanos;
        }

        public String toString() {
            return "OffsetClock{offsetInNanos=" + this.offsetInNanos + "}";
        }
    }
}

