/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.opentelemetry;

import com.google.common.annotations.VisibleForTesting;
import io.jenkins.plugins.opentelemetry.api.ReconfigurableOpenTelemetry;
import io.opentelemetry.instrumentation.resources.ContainerResourceProvider;
import io.opentelemetry.instrumentation.resources.HostIdResourceProvider;
import io.opentelemetry.instrumentation.resources.HostResourceProvider;
import io.opentelemetry.instrumentation.resources.OsResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import io.opentelemetry.semconv.incubating.ServiceIncubatingAttributes;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public final class GlobalOpenTelemetrySdk {
    private static final Logger logger = Logger.getLogger(GlobalOpenTelemetrySdk.class.getName());
    private static final ReconfigurableOpenTelemetry openTelemetry;
    private static final io.opentelemetry.api.logs.Logger otelLogger;
    @VisibleForTesting
    static OtelSdkConfiguration currentSdkConfiguration;
    static final AtomicInteger configurationCounter;

    @Nonnull
    public static ReconfigurableOpenTelemetry get() {
        return openTelemetry;
    }

    public static boolean isInitialized() {
        return openTelemetry != null;
    }

    @Nonnull
    public static io.opentelemetry.api.logs.Logger getOtelLogger() {
        return otelLogger;
    }

    public static synchronized void configure(Map<String, String> configurationProperties, Map<String, String> resourceAttributes, boolean registerShutDownHook) {
        OtelSdkConfiguration newOtelSdkConfiguration = new OtelSdkConfiguration(configurationProperties, resourceAttributes);
        if (Objects.equals(newOtelSdkConfiguration, currentSdkConfiguration)) {
            logger.log(Level.FINEST, () -> "OpenTelemetry SDK configuration has NOT changed, don't reconfigure SDK");
            return;
        }
        logger.log(Level.FINEST, () -> "Configure OpenTelemetry SDK...");
        DefaultConfigProperties configProperties = DefaultConfigProperties.create(configurationProperties);
        ResourceBuilder resourceBuilder = Resource.builder();
        resourceBuilder.putAll(new HostResourceProvider().createResource((ConfigProperties)configProperties));
        resourceBuilder.putAll(new HostIdResourceProvider().createResource((ConfigProperties)configProperties));
        resourceBuilder.putAll(new ContainerResourceProvider().createResource((ConfigProperties)configProperties));
        resourceBuilder.putAll(new OsResourceProvider().createResource((ConfigProperties)configProperties));
        resourceAttributes.entrySet().stream().filter(Predicate.not(entry -> Objects.equals(ServiceIncubatingAttributes.SERVICE_INSTANCE_ID.getKey(), entry.getKey()))).forEach(entry -> resourceBuilder.put((String)entry.getKey(), (String)entry.getValue()));
        Resource resource = resourceBuilder.build();
        GlobalOpenTelemetrySdk.get().configure(configurationProperties, resource, registerShutDownHook);
        currentSdkConfiguration = newOtelSdkConfiguration;
        configurationCounter.incrementAndGet();
    }

    static {
        currentSdkConfiguration = new OtelSdkConfiguration(Collections.emptyMap(), Collections.emptyMap());
        openTelemetry = ReconfigurableOpenTelemetry.get();
        otelLogger = openTelemetry.getLogsBridge().loggerBuilder("io.jenkins.opentelemetry").build();
        configurationCounter = new AtomicInteger();
    }

    static class OtelSdkConfiguration {
        private final Map<String, String> configurationProperties;
        private final Map<String, String> resourceAttributes;

        public OtelSdkConfiguration(Map<String, String> configurationProperties, Map<String, String> resourceAttributes) {
            this.configurationProperties = configurationProperties;
            this.resourceAttributes = resourceAttributes;
        }

        public Map<String, String> getConfigurationProperties() {
            return this.configurationProperties;
        }

        public Map<String, String> getResourceAttributes() {
            return this.resourceAttributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OtelSdkConfiguration that = (OtelSdkConfiguration)o;
            return Objects.equals(this.configurationProperties, that.configurationProperties) && Objects.equals(this.resourceAttributes, that.resourceAttributes);
        }

        public int hashCode() {
            return Objects.hash(this.configurationProperties, this.resourceAttributes);
        }
    }
}

