/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.step;

import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Run;
import io.jenkins.plugins.opentelemetry.OpenTelemetryAttributesAction;
import io.jenkins.plugins.opentelemetry.job.OtelTraceService;
import io.jenkins.plugins.opentelemetry.job.step.SpanAttribute;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.GeneralNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class SpanAttributeStepExecution
extends GeneralNonBlockingStepExecution {
    private static final Logger logger = Logger.getLogger(SpanAttributeStepExecution.class.getName());
    private final List<SpanAttribute> spanAttributes;
    private final boolean setOnChildren;
    private final boolean setAttributesOnlyOnParent;
    private static final long serialVersionUID = 1L;

    public SpanAttributeStepExecution(List<SpanAttribute> spanAttributes, boolean setOnChildren, StepContext context) {
        super(context);
        this.spanAttributes = spanAttributes;
        this.setOnChildren = setOnChildren;
        this.setAttributesOnlyOnParent = false;
    }

    public SpanAttributeStepExecution(List<SpanAttribute> spanAttributes, boolean setOnChildren, StepContext context, boolean setAttributesOnlyOnParent) {
        super(context);
        this.spanAttributes = spanAttributes;
        this.setOnChildren = setOnChildren;
        this.setAttributesOnlyOnParent = setAttributesOnlyOnParent;
    }

    public boolean start() throws Exception {
        if (this.setOnChildren) {
            try {
                this.run();
            }
            catch (Throwable t) {
                this.getContext().onFailure(t);
            }
            return false;
        }
        try {
            this.getContext().onSuccess((Object)this.run());
        }
        catch (Throwable t) {
            this.getContext().onFailure(t);
        }
        return true;
    }

    protected Void run() throws Exception {
        OtelTraceService otelTraceService = (OtelTraceService)ExtensionList.lookupSingleton(OtelTraceService.class);
        Run run = (Run)this.getContext().get(Run.class);
        FlowNode flowNode = (FlowNode)this.getContext().get(FlowNode.class);
        String currentSpanId = otelTraceService.getSpan(run, flowNode).getSpanContext().getSpanId();
        this.spanAttributes.forEach(spanAttribute -> {
            switch (spanAttribute.getTarget()) {
                case PIPELINE_ROOT_SPAN: {
                    spanAttribute.setTargetSpan(otelTraceService.getPipelineRootSpan(run));
                    break;
                }
                case CURRENT_SPAN: {
                    spanAttribute.setTargetSpan(otelTraceService.getSpan(run, flowNode));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported target span '" + String.valueOf((Object)spanAttribute.getTarget()) + "'. ");
                }
            }
        });
        this.spanAttributes.forEach(SpanAttribute::convert);
        this.spanAttributes.forEach(spanAttribute -> {
            logger.log(Level.FINE, () -> "spanAttribute: run=\"" + run.getParent().getName() + "#" + run.getId() + "\", key=" + spanAttribute.getKey() + " value=\"" + String.valueOf(spanAttribute.getValue()) + "\" type=" + String.valueOf(spanAttribute.getAttributeType()));
            spanAttribute.getTargetSpan().setAttribute(spanAttribute.getAttributeKey(), spanAttribute.getConvertedValue());
        });
        if (this.setOnChildren) {
            this.spanAttributes.forEach(spanAttribute -> {
                switch (spanAttribute.getTarget()) {
                    case PIPELINE_ROOT_SPAN: {
                        Span phaseSpan = otelTraceService.getSpan(run);
                        phaseSpan.setAttribute(spanAttribute.getAttributeKey(), spanAttribute.getConvertedValue());
                        Span currentSpan = otelTraceService.getSpan(run, flowNode);
                        currentSpan.setAttribute(spanAttribute.getAttributeKey(), spanAttribute.getConvertedValue());
                        this.addAttributeToRunAction((Actionable)run, spanAttribute.getAttributeKey(), spanAttribute.getConvertedValue());
                        break;
                    }
                    case CURRENT_SPAN: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported target span '" + String.valueOf((Object)spanAttribute.getTarget()) + "'. ");
                    }
                }
            });
            this.getContext().newBodyInvoker().withContext((Object)this.mergeAttributes(this.getContext(), this.spanAttributes, currentSpanId)).withCallback((BodyExecutionCallback)NopCallback.INSTANCE).start();
        }
        return null;
    }

    private void addAttributeToRunAction(Actionable actionable, AttributeKey attributeKey, Object convertedValue) {
        OpenTelemetryAttributesAction openTelemetryAttributesAction = (OpenTelemetryAttributesAction)actionable.getAction(OpenTelemetryAttributesAction.class);
        if (openTelemetryAttributesAction == null) {
            actionable.addAction((Action)new OpenTelemetryAttributesAction());
            openTelemetryAttributesAction = (OpenTelemetryAttributesAction)actionable.getAction(OpenTelemetryAttributesAction.class);
        }
        openTelemetryAttributesAction.getAttributes().put(attributeKey, convertedValue);
    }

    private OpenTelemetryAttributesAction mergeAttributes(StepContext context, List<SpanAttribute> spanAttributes, String currentSpanId) throws IOException, InterruptedException {
        OpenTelemetryAttributesAction existingAttributes = (OpenTelemetryAttributesAction)context.get(OpenTelemetryAttributesAction.class);
        OpenTelemetryAttributesAction resultingAttributes = new OpenTelemetryAttributesAction();
        if (existingAttributes != null) {
            resultingAttributes.getAttributes().putAll(existingAttributes.getAttributes());
        }
        spanAttributes.forEach(spanAttribute -> resultingAttributes.getAttributes().put(spanAttribute.getAttributeKey(), spanAttribute.getConvertedValue()));
        if (this.setAttributesOnlyOnParent) {
            resultingAttributes.addSpanIdToInheritanceAllowedList(currentSpanId);
        }
        return resultingAttributes;
    }

    private static class NopCallback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 957579239256583870L;
        public static final NopCallback INSTANCE = new NopCallback();

        private NopCallback() {
        }

        protected void finished(StepContext context) throws Exception {
        }
    }
}

