/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.step;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import io.jenkins.plugins.opentelemetry.job.step.SpanAttributeTarget;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributeType;
import io.opentelemetry.api.trace.Span;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class SpanAttribute
extends AbstractDescribableImpl<SpanAttribute>
implements ExtensionPoint,
Serializable {
    private static final long serialVersionUID = -8621147407454968274L;
    private String key;
    private Object value;
    private AttributeType attributeType;
    private SpanAttributeTarget target;
    private transient AttributeKey<?> attributeKey;
    private transient Object convertedValue;
    private transient Span targetSpan;

    @DataBoundConstructor
    public SpanAttribute(String key, Object value, AttributeType attributeType, SpanAttributeTarget target) {
        this.key = key;
        this.value = value;
        this.attributeType = attributeType;
        this.target = Objects.requireNonNullElse(target, SpanAttributeTarget.CURRENT_SPAN);
    }

    protected Object readResolve() throws ObjectStreamException {
        this.setDefaultType();
        this.convert();
        return this;
    }

    public void setDefaultType() {
        if (this.attributeType != null) {
            return;
        }
        boolean isArray = this.value.getClass().isArray();
        this.attributeType = this.value instanceof Boolean ? (isArray ? AttributeType.BOOLEAN_ARRAY : AttributeType.BOOLEAN) : (this.value instanceof Double || this.value instanceof Float ? (isArray ? AttributeType.DOUBLE_ARRAY : AttributeType.DOUBLE) : (this.value instanceof Long || this.value instanceof Integer ? (isArray ? AttributeType.LONG_ARRAY : AttributeType.LONG) : (isArray ? AttributeType.STRING_ARRAY : AttributeType.STRING)));
    }

    public void convert() {
        switch (this.attributeType) {
            case BOOLEAN: {
                this.attributeKey = AttributeKey.booleanKey((String)this.key);
                this.convertedValue = this.value instanceof Boolean ? this.value : Boolean.valueOf(Boolean.parseBoolean(this.value.toString()));
                break;
            }
            case DOUBLE: {
                this.attributeKey = AttributeKey.doubleKey((String)this.key);
                this.convertedValue = this.value instanceof Double ? this.value : Double.valueOf(this.value instanceof Float ? ((Float)this.value).doubleValue() : Double.parseDouble(this.value.toString()));
                break;
            }
            case STRING: {
                this.attributeKey = AttributeKey.stringKey((String)this.key);
                this.convertedValue = this.value instanceof String ? this.value : this.value.toString();
                break;
            }
            case LONG: {
                this.attributeKey = AttributeKey.longKey((String)this.key);
                this.convertedValue = this.value instanceof Long ? this.value : Long.valueOf(this.value instanceof Integer ? ((Integer)this.value).longValue() : Long.parseLong(this.value.toString()));
                break;
            }
            case BOOLEAN_ARRAY: {
                this.attributeKey = AttributeKey.booleanArrayKey((String)this.key);
                this.convertedValue = this.value;
                break;
            }
            case DOUBLE_ARRAY: {
                this.attributeKey = AttributeKey.doubleArrayKey((String)this.key);
                this.convertedValue = this.value;
                break;
            }
            case LONG_ARRAY: {
                this.attributeKey = AttributeKey.longArrayKey((String)this.key);
                this.convertedValue = this.value;
                break;
            }
            case STRING_ARRAY: {
                this.attributeKey = AttributeKey.stringArrayKey((String)this.key);
                this.convertedValue = this.value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported span attribute type '" + String.valueOf(this.attributeType) + "'. ");
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(AttributeType attributeType) {
        this.attributeType = attributeType;
    }

    public SpanAttributeTarget getTarget() {
        return this.target;
    }

    public void setTarget(SpanAttributeTarget target) {
        this.target = target;
    }

    public AttributeKey getAttributeKey() {
        return this.attributeKey;
    }

    public Object getConvertedValue() {
        return this.convertedValue;
    }

    public Span getTargetSpan() {
        return this.targetSpan;
    }

    public void setTargetSpan(Span targetSpan) {
        this.targetSpan = targetSpan;
    }

    @Symbol(value={"spanAttribute"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<SpanAttribute> {
        @NonNull
        public String getDisplayName() {
            return "An individual span attribute key value pair";
        }
    }
}

