/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.BuildListener;
import io.jenkins.plugins.opentelemetry.job.log.util.TeeOutputStream;
import io.jenkins.plugins.opentelemetry.job.log.util.TeePrintStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.jenkinsci.plugins.workflow.log.OutputStreamTaskListener;

public class TeeOutputStreamBuildListener
implements BuildListener,
OutputStreamTaskListener,
AutoCloseable {
    private static final long serialVersionUID = 1L;
    private final BuildListener primary;
    private final BuildListener secondary;
    private transient OutputStream outputStream;
    private transient PrintStream printStream;

    public TeeOutputStreamBuildListener(BuildListener primary, BuildListener secondary) {
        if (!(primary instanceof OutputStreamTaskListener)) {
            throw new ClassCastException("Primary is not an instance of OutputStreamTaskListener: " + String.valueOf(primary));
        }
        if (!(secondary instanceof OutputStreamTaskListener)) {
            throw new ClassCastException("Secondary is not an instance of OutputStreamTaskListener: " + String.valueOf(primary));
        }
        this.primary = primary;
        this.secondary = secondary;
    }

    @NonNull
    public synchronized OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = new TeeOutputStream(((OutputStreamTaskListener)this.primary).getOutputStream(), ((OutputStreamTaskListener)this.secondary).getOutputStream());
        }
        return this.outputStream;
    }

    @NonNull
    public synchronized PrintStream getLogger() {
        if (this.printStream == null) {
            this.printStream = new TeePrintStream(this.primary.getLogger(), this.secondary.getLogger());
        }
        return this.printStream;
    }

    @Override
    public void close() throws Exception {
        if (this.primary instanceof AutoCloseable) {
            ((AutoCloseable)this.primary).close();
        }
        if (this.secondary instanceof AutoCloseable) {
            ((AutoCloseable)this.secondary).close();
        }
    }
}

