/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import io.jenkins.plugins.opentelemetry.job.log.util.TeePrintStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TeeBuildListener
implements BuildListener,
AutoCloseable {
    private static final Logger logger = Logger.getLogger(TeeBuildListener.class.getName());
    final TaskListener main;
    final TaskListener secondary;

    public TeeBuildListener(TaskListener main, TaskListener secondary) {
        this.main = main;
        this.secondary = secondary;
    }

    @NonNull
    public PrintStream getLogger() {
        return new TeePrintStream(this.main.getLogger(), this.secondary.getLogger());
    }

    @Override
    public void close() throws IOException {
        logger.log(Level.FINEST, "close()");
        if (this.main instanceof Closeable) {
            ((Closeable)this.main).close();
        }
        if (this.secondary instanceof Closeable) {
            ((Closeable)this.secondary).close();
        }
    }

    public String toString() {
        return "TeeBuildListener[" + String.valueOf(this.main) + "," + String.valueOf(this.secondary) + "]";
    }
}

