/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.console.LineTransformationOutputStream;
import io.jenkins.plugins.opentelemetry.job.log.ConsoleNotes;
import io.jenkins.plugins.opentelemetry.job.log.RunTraceContext;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.sdk.common.Clock;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

final class OtelLogOutputStream
extends LineTransformationOutputStream {
    public static boolean ENABLE_LOG_FORMATTING = Boolean.parseBoolean(System.getProperty("pipeline.log.elastic.enable.log.formatting", "false"));
    private static final Logger LOGGER = Logger.getLogger(OtelLogOutputStream.class.getName());
    @NonNull
    final RunTraceContext runTraceContext;
    final io.opentelemetry.api.logs.Logger otelLogger;
    final Clock clock;

    public OtelLogOutputStream(@NonNull RunTraceContext runTraceContext, @NonNull io.opentelemetry.api.logs.Logger otelLogger, @NonNull Clock clock) {
        this.runTraceContext = runTraceContext;
        this.otelLogger = otelLogger;
        this.clock = clock;
    }

    protected void eol(byte[] bytes, int len) {
        if (len == 0) {
            return;
        }
        ConsoleNotes.TextAndAnnotations textAndAnnotations = ConsoleNotes.parse(bytes, len);
        String plainLogLine = textAndAnnotations.text;
        if (plainLogLine == null || plainLogLine.isEmpty()) {
            LOGGER.log(Level.FINEST, () -> String.valueOf(this.runTraceContext) + " - skip empty log line");
        } else {
            AttributesBuilder attributesBuilder = Attributes.builder();
            if (ENABLE_LOG_FORMATTING && textAndAnnotations.annotations != null) {
                attributesBuilder.put(ExtendedJenkinsAttributes.JENKINS_ANSI_ANNOTATIONS, (Object)textAndAnnotations.annotations.toString());
            }
            attributesBuilder.putAll(this.runTraceContext.toAttributes());
            this.otelLogger.logRecordBuilder().setSeverity(Severity.INFO).setBody(plainLogLine).setAllAttributes(attributesBuilder.build()).setContext(this.runTraceContext.getContext()).setTimestamp(this.clock.now(), TimeUnit.NANOSECONDS).emit();
            LOGGER.log(Level.FINEST, () -> this.runTraceContext.jobFullName + "#" + this.runTraceContext.runNumber + " - emit body: '" + StringUtils.abbreviate((String)plainLogLine, (int)30) + "'");
        }
    }

    public void flush() {
    }

    public void close() {
    }
}

