/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Run;
import io.jenkins.plugins.opentelemetry.OtelUtils;
import io.jenkins.plugins.opentelemetry.job.log.RunTraceContext;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public class FlowNodeTraceContext
extends RunTraceContext {
    private static final long serialVersionUID = 1L;
    private final String flowNodeId;

    public static FlowNodeTraceContext newFlowNodeTraceContext(@NonNull Run run, @NonNull FlowNode flowNode, @NonNull Span span) {
        String spanId = span.getSpanContext().getSpanId();
        String traceId = span.getSpanContext().getTraceId();
        Map<String, String> w3cTraceContext = OtelUtils.getW3cTraceContext(span);
        return new FlowNodeTraceContext(run.getParent().getFullName(), run.getNumber(), flowNode.getId(), traceId, spanId, w3cTraceContext);
    }

    public FlowNodeTraceContext(String jobFullName, int runNumber, String flowNodeId, String traceId, String spanId, Map<String, String> w3cTraceContext) {
        super(jobFullName, runNumber, traceId, spanId, w3cTraceContext);
        this.flowNodeId = flowNodeId;
    }

    public String getFlowNodeId() {
        return this.flowNodeId;
    }

    @Override
    public String toString() {
        return "FlowNodeTraceContext{jobFullName='" + this.jobFullName + "', runNumber=" + this.runNumber + ", flowNodeId='" + this.flowNodeId + "', spanId='" + this.spanId + "', traceId='" + this.traceId + "'}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowNodeTraceContext traceContext = (FlowNodeTraceContext)o;
        return this.runNumber == traceContext.runNumber && com.google.common.base.Objects.equal((Object)this.jobFullName, (Object)traceContext.jobFullName) && com.google.common.base.Objects.equal((Object)this.flowNodeId, (Object)traceContext.flowNodeId) && com.google.common.base.Objects.equal((Object)this.traceId, (Object)traceContext.traceId) && com.google.common.base.Objects.equal((Object)this.spanId, (Object)traceContext.spanId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.flowNodeId);
    }

    @Override
    @Nonnull
    public Attributes toAttributes() {
        return Attributes.builder().putAll(super.toAttributes()).put(ExtendedJenkinsAttributes.JENKINS_STEP_ID, (Object)this.flowNodeId).build();
    }
}

