/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job.action;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.opentelemetry.job.action.OtelMonitoringAction;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractMonitoringAction
implements OtelMonitoringAction {
    private static final Logger LOGGER = Logger.getLogger(AbstractMonitoringAction.class.getName());
    @CheckForNull
    transient SpanAndScopes spanAndScopes;
    final String traceId;
    final String spanId;
    protected String spanName;
    protected Map<String, String> w3cTraceContext;

    public AbstractMonitoringAction(Span span, List<Scope> scopes) {
        this.spanAndScopes = new SpanAndScopes(span, scopes, Thread.currentThread().getName());
        this.traceId = span.getSpanContext().getTraceId();
        this.spanId = span.getSpanContext().getSpanId();
        this.spanName = span instanceof ReadWriteSpan ? ((ReadWriteSpan)span).getName() : null;
        try (Scope scope = span.makeCurrent();){
            HashMap<String, String> w3cTraceContext = new HashMap<String, String>();
            W3CTraceContextPropagator.getInstance().inject(Context.current(), w3cTraceContext, (carrier, key, value) -> carrier.put(key, value));
            this.w3cTraceContext = w3cTraceContext;
        }
        LOGGER.log(Level.FINE, () -> "Span " + this.getSpanName() + Optional.ofNullable(this.spanAndScopes).map(sas -> ", thread=" + sas.scopeStartThreadName + " opened " + sas.scopes.size() + " scopes").orElse(", null spanAndScopes"));
    }

    public String getSpanName() {
        return this.spanName;
    }

    @Override
    public Map<String, String> getW3cTraceContext() {
        return Collections.unmodifiableMap(this.w3cTraceContext);
    }

    @Override
    @CheckForNull
    public Span getSpan() {
        return this.spanAndScopes == null ? null : this.spanAndScopes.span;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    @Override
    public void purgeSpanAndCloseAssociatedScopes() {
        LOGGER.log(Level.FINE, () -> "Purge span='" + this.spanName + "', spanId=" + this.spanId + ", traceId=" + this.traceId + ": " + String.valueOf(this.spanAndScopes));
        Optional.ofNullable(this.spanAndScopes).map(spanAndScopes -> spanAndScopes.scopes).map(ImmutableList::copyOf).map(ImmutableList::reverse).ifPresent(scopes -> scopes.forEach(Scope::close));
        this.spanAndScopes = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{traceId='" + this.traceId + "', spanId='" + this.spanId + "', span.name='" + this.spanName + "'}";
    }

    @Override
    public boolean hasEnded() {
        return Optional.ofNullable(this.spanAndScopes).map(sac -> sac.span).filter(s -> s instanceof ReadableSpan).map(s -> (ReadableSpan)s).map(ReadableSpan::hasEnded).orElse(true);
    }

    static class SpanAndScopes {
        @NonNull
        final Span span;
        @NonNull
        final List<Scope> scopes;
        @NonNull
        final String scopeStartThreadName;

        public SpanAndScopes(@NonNull Span span, @NonNull List<Scope> scopes, @NonNull String scopeStartThreadName) {
            this.span = span;
            this.scopes = scopes;
            this.scopeStartThreadName = scopeStartThreadName;
        }

        public String toString() {
            return "SpanAndScopes{span=" + String.valueOf(this.span) + ", scopes=" + this.scopes.size() + ", scopeStartThreadName='" + this.scopeStartThreadName + "'}";
        }
    }
}

