/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Run;
import io.jenkins.plugins.opentelemetry.api.ReconfigurableOpenTelemetry;
import io.jenkins.plugins.opentelemetry.job.MonitoringAction;
import io.jenkins.plugins.opentelemetry.semconv.ConfigurationKey;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@Extension
public class OtelEnvironmentContributorService {
    public static final String SPAN_ID = "SPAN_ID";
    public static final String TRACE_ID = "TRACE_ID";
    private final List<ConfigurationKey> exportedConfigKeys = List.of(ConfigurationKey.OTEL_EXPORTER_OTLP_CERTIFICATE, ConfigurationKey.OTEL_EXPORTER_OTLP_ENDPOINT, ConfigurationKey.OTEL_EXPORTER_OTLP_HEADERS, ConfigurationKey.OTEL_EXPORTER_OTLP_INSECURE, ConfigurationKey.OTEL_EXPORTER_OTLP_PROTOCOL, ConfigurationKey.OTEL_EXPORTER_OTLP_TIMEOUT, ConfigurationKey.OTEL_METRIC_EXPORT_INTERVAL, ConfigurationKey.OTEL_LOGS_EXPORTER, ConfigurationKey.OTEL_METRICS_EXPORTER, ConfigurationKey.OTEL_TRACES_EXPORTER);
    private ReconfigurableOpenTelemetry reconfigurableOpenTelemetry;

    public void addEnvironmentVariables(@NonNull Run<?, ?> run, @NonNull EnvVars envs, @NonNull Span span) {
        String spanId = span.getSpanContext().getSpanId();
        String traceId = span.getSpanContext().getTraceId();
        envs.put(TRACE_ID, traceId);
        envs.put(SPAN_ID, spanId);
        try (Scope ignored = span.makeCurrent();){
            TextMapSetter setter = (carrier, key, value) -> carrier.put(key.toUpperCase(), value);
            W3CTraceContextPropagator.getInstance().inject(Context.current(), (Object)envs, setter);
        }
        Baggage baggage = Baggage.builder().put(ExtendedJenkinsAttributes.CI_PIPELINE_ID.getKey(), run.getParent().getFullName()).put(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_NUMBER.getKey(), String.valueOf(run.getNumber())).build();
        try (Scope ignored = baggage.makeCurrent();){
            TextMapSetter setter = (carrier, key, value) -> carrier.put(key.toUpperCase(), value);
            W3CBaggagePropagator.getInstance().inject(Context.current(), (Object)envs, setter);
        }
        Optional.ofNullable((MonitoringAction)run.getAction(MonitoringAction.class)).ifPresent(monitoringAction -> monitoringAction.getLinks().stream().filter(link -> link.getEnvironmentVariableName() != null).forEach(link -> envs.put(link.getEnvironmentVariableName(), link.getUrl())));
        ConfigProperties config = this.reconfigurableOpenTelemetry.getConfig();
        boolean exportOTelConfigAsEnvVar = config.getBoolean(ConfigurationKey.OTEL_INSTRUMENTATION_JENKINS_EXPORT_OTEL_CONFIG_AS_ENV_VARS.asProperty(), true);
        if (exportOTelConfigAsEnvVar) {
            for (ConfigurationKey configKey : this.exportedConfigKeys) {
                Optional.ofNullable(config.getString(configKey.asProperty())).ifPresent(configValue -> envs.put(configKey.asEnvVar(), configValue));
            }
        }
    }

    @Inject
    public void setReconfigurableOpenTelemetry(ReconfigurableOpenTelemetry reconfigurableOpenTelemetry) {
        this.reconfigurableOpenTelemetry = reconfigurableOpenTelemetry;
    }
}

