/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job;

import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.plugins.opentelemetry.JenkinsControllerOpenTelemetry;
import io.jenkins.plugins.opentelemetry.JenkinsOpenTelemetryPluginConfiguration;
import io.jenkins.plugins.opentelemetry.OpenTelemetryAttributesAction;
import io.jenkins.plugins.opentelemetry.OtelUtils;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.jenkins.plugins.opentelemetry.job.OtelTraceService;
import io.jenkins.plugins.opentelemetry.job.jenkins.AbstractPipelineListener;
import io.jenkins.plugins.opentelemetry.job.step.SpanAttribute;
import io.jenkins.plugins.opentelemetry.job.step.StepHandler;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.incubating.HostIncubatingAttributes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jenkins.YesNoMaybe;
import jenkins.model.CauseOfInterruption;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.actions.ArgumentsAction;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.StepListener;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.GenericStatus;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StatusAndTiming;
import org.jenkinsci.plugins.workflow.steps.CoreStep;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

@Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
public class MonitoringPipelineListener
extends AbstractPipelineListener
implements StepListener,
OpenTelemetryLifecycleListener {
    private static final Logger LOGGER = Logger.getLogger(MonitoringPipelineListener.class.getName());
    private OtelTraceService otelTraceService;
    private Tracer tracer;
    private Set<String> ignoredSteps;
    private List<StepHandler> stepHandlers;
    Set<String> statusUnsetCausesOfInterruption;
    @Inject
    protected JenkinsControllerOpenTelemetry jenkinsControllerOpenTelemetry;

    @PostConstruct
    public void postConstruct() {
        LOGGER.log(Level.FINE, () -> "Start monitoring Jenkins pipeline executions...");
        this.tracer = this.jenkinsControllerOpenTelemetry.getDefaultTracer();
        JenkinsOpenTelemetryPluginConfiguration jenkinsOpenTelemetryPluginConfiguration = JenkinsOpenTelemetryPluginConfiguration.get();
        this.ignoredSteps = new HashSet<String>(Arrays.asList(jenkinsOpenTelemetryPluginConfiguration.getIgnoredSteps().split(",")));
        this.statusUnsetCausesOfInterruption = new HashSet<String>(jenkinsOpenTelemetryPluginConfiguration.getStatusUnsetCausesOfInterruption());
    }

    @Override
    public void onStartNodeStep(@NonNull StepStartNode stepStartNode, @Nullable String agentLabel, @NonNull WorkflowRun run) {
        try (Scope nodeSpanScope = this.setupContext(run, (FlowNode)stepStartNode);){
            Verify.verifyNotNull((Object)nodeSpanScope, (String)"%s - No span found for node %s", (Object[])new Object[]{run, stepStartNode});
            String stepType = this.getStepType((FlowNode)stepStartNode, stepStartNode.getDescriptor(), "node");
            JenkinsOpenTelemetryPluginConfiguration.StepPlugin stepPlugin = JenkinsOpenTelemetryPluginConfiguration.get().findStepPluginOrDefault(stepType, stepStartNode);
            SpanBuilder agentSpanBuilder = this.getTracer().spanBuilder("Agent").setParent(Context.current()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_TYPE, (Object)stepType).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_ID, (Object)stepStartNode.getId()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_NAME, (Object)"agent").setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_PLUGIN_NAME, (Object)stepPlugin.getName()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_PLUGIN_VERSION, (Object)stepPlugin.getVersion());
            if (agentLabel != null) {
                agentSpanBuilder.setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_AGENT_LABEL, (Object)agentLabel);
            }
            Span agentSpan = agentSpanBuilder.startSpan();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - > agent(" + agentLabel + ") - begin " + OtelUtils.toDebugString(agentSpan));
            this.getTracerService().putAgentSpan((Run<?, ?>)run, agentSpan, (FlowNode)stepStartNode);
            try (Scope allocateAgentSpanScope = agentSpan.makeCurrent();){
                SpanBuilder allocateAgentSpanBuilder = this.getTracer().spanBuilder("Agent Allocation").setParent(Context.current()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_TYPE, (Object)this.getStepType((FlowNode)stepStartNode, stepStartNode.getDescriptor(), "node")).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_ID, (Object)stepStartNode.getId()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_NAME, (Object)"agent.allocate").setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_PLUGIN_NAME, (Object)stepPlugin.getName()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_PLUGIN_VERSION, (Object)stepPlugin.getVersion());
                if (agentLabel != null) {
                    allocateAgentSpanBuilder.setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_AGENT_LABEL, (Object)agentLabel);
                }
                Span allocateAgentSpan = allocateAgentSpanBuilder.startSpan();
                LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - > agent.allocate(" + agentLabel + ") - begin " + OtelUtils.toDebugString(allocateAgentSpan));
                this.getTracerService().putAgentSpan((Run<?, ?>)run, allocateAgentSpan, (FlowNode)stepStartNode);
            }
        }
    }

    @Override
    public void onAfterStartNodeStep(@NonNull StepStartNode stepStartNode, @Nullable String nodeLabel, @NonNull WorkflowRun run) {
        this.endCurrentSpan((FlowNode)stepStartNode, run, null);
    }

    @Override
    public void onStartStageStep(@NonNull StepStartNode stepStartNode, @NonNull String stageName, @NonNull WorkflowRun run) {
        try (Scope ignored = this.setupContext(run, (FlowNode)stepStartNode);){
            Verify.verifyNotNull((Object)ignored, (String)"%s - No span found for node %s", (Object[])new Object[]{run, stepStartNode});
            String spanStageName = "Stage: " + stageName;
            String stepType = this.getStepType((FlowNode)stepStartNode, stepStartNode.getDescriptor(), "stage");
            JenkinsOpenTelemetryPluginConfiguration.StepPlugin stepPlugin = JenkinsOpenTelemetryPluginConfiguration.get().findStepPluginOrDefault(stepType, stepStartNode);
            Span stageSpan = this.getTracer().spanBuilder(spanStageName).setParent(Context.current()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_TYPE, (Object)stepType).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_ID, (Object)stepStartNode.getId()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_NAME, (Object)stageName).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_PLUGIN_NAME, (Object)stepPlugin.getName()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_PLUGIN_VERSION, (Object)stepPlugin.getVersion()).startSpan();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - > stage(" + stageName + ") - begin " + OtelUtils.toDebugString(stageSpan));
            this.getTracerService().putSpan((Run<?, ?>)run, stageSpan, (FlowNode)stepStartNode);
        }
    }

    @Override
    public void onEndNodeStep(@NonNull StepEndNode node, @NonNull String nodeName, FlowNode nextNode, @NonNull WorkflowRun run) {
        StepStartNode nodeStartNode = (StepStartNode)node.getStartNode();
        GenericStatus nodeStatus = StatusAndTiming.computeChunkStatus2((WorkflowRun)run, null, (FlowNode)nodeStartNode, (FlowNode)node, (FlowNode)nextNode);
        this.endCurrentSpan((FlowNode)node, run, nodeStatus);
    }

    @Override
    public void onEndStageStep(@NonNull StepEndNode node, @NonNull String stageName, FlowNode nextNode, @NonNull WorkflowRun run) {
        StepStartNode stageStartNode = (StepStartNode)node.getStartNode();
        GenericStatus stageStatus = StatusAndTiming.computeChunkStatus2((WorkflowRun)run, null, (FlowNode)stageStartNode, (FlowNode)node, (FlowNode)nextNode);
        this.endCurrentSpan((FlowNode)node, run, stageStatus);
    }

    protected List<StepHandler> getStepHandlers() {
        if (this.stepHandlers == null) {
            ArrayList<StepHandler> stepHandlers = new ArrayList<StepHandler>((Collection<StepHandler>)ExtensionList.lookup(StepHandler.class));
            Collections.sort(stepHandlers);
            this.stepHandlers = stepHandlers;
        }
        return this.stepHandlers;
    }

    @Override
    public void onAtomicStep(@NonNull StepAtomNode node, @NonNull WorkflowRun run) {
        if (this.isIgnoredStep(node.getDescriptor())) {
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - don't create span for step '" + node.getDisplayFunctionName() + "'");
            return;
        }
        Scope encapsulatingNodeScope = this.setupContext(run, (FlowNode)node);
        Verify.verifyNotNull((Object)encapsulatingNodeScope, (String)"%s - No span found for node %s", (Object[])new Object[]{run, node});
        String principal = Objects.toString(node.getExecution().getAuthentication2().getPrincipal(), "#null#");
        StepHandler stepHandler = this.getStepHandlers().stream().filter(sh -> sh.canCreateSpanBuilder((FlowNode)node, run)).findFirst().orElseThrow(() -> new IllegalStateException("No StepHandler found for node " + String.valueOf(node.getClass()) + " - " + String.valueOf(node) + " on " + String.valueOf(run)));
        SpanBuilder spanBuilder = stepHandler.createSpanBuilder((FlowNode)node, run, this.getTracer());
        String stepType = this.getStepType((FlowNode)node, node.getDescriptor(), "step");
        JenkinsOpenTelemetryPluginConfiguration.StepPlugin stepPlugin = JenkinsOpenTelemetryPluginConfiguration.get().findStepPluginOrDefault(stepType, node);
        spanBuilder.setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_TYPE, (Object)stepType).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_ID, (Object)node.getId()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_NAME, (Object)this.getStepName(node, "step")).setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_USER, (Object)principal).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_PLUGIN_NAME, (Object)stepPlugin.getName()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_PLUGIN_VERSION, (Object)stepPlugin.getVersion());
        Span atomicStepSpan = spanBuilder.startSpan();
        LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - > " + node.getDisplayFunctionName() + " - begin " + OtelUtils.toDebugString(atomicStepSpan));
        Scope atomicStepScope = atomicStepSpan.makeCurrent();
        stepHandler.afterSpanCreated(node, run);
        this.getTracerService().putSpanAndScopes((Run<?, ?>)run, atomicStepSpan, (FlowNode)node, Arrays.asList(encapsulatingNodeScope, atomicStepScope));
    }

    @Override
    public void onAfterAtomicStep(@NonNull StepAtomNode node, FlowNode nextNode, @NonNull WorkflowRun run) {
        if (this.isIgnoredStep(node.getDescriptor())) {
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - don't end span for step '" + node.getDisplayFunctionName() + "'");
            return;
        }
        GenericStatus stageStatus = StatusAndTiming.computeChunkStatus2((WorkflowRun)run, null, (FlowNode)node, (FlowNode)node, (FlowNode)nextNode);
        this.endCurrentSpan((FlowNode)node, run, stageStatus);
    }

    private boolean isIgnoredStep(@Nullable StepDescriptor stepDescriptor) {
        if (stepDescriptor == null) {
            return true;
        }
        String stepFunctionName = stepDescriptor.getFunctionName();
        boolean ignoreStep = "setSpanAttributes".equals(stepFunctionName) || "withSpanAttribute".equals(stepFunctionName) || "withSpanAttributes".equals(stepFunctionName) || this.ignoredSteps.contains(stepFunctionName);
        LOGGER.log(Level.FINER, () -> "isIgnoreStep(" + String.valueOf(stepDescriptor) + "): " + ignoreStep);
        return ignoreStep;
    }

    private String getStepName(@NonNull StepAtomNode node, @NonNull String name) {
        StepDescriptor stepDescriptor = node.getDescriptor();
        if (stepDescriptor == null) {
            return name;
        }
        UninstantiatedDescribable describable = this.getUninstantiatedDescribableOrNull((FlowNode)node, stepDescriptor);
        if (describable != null) {
            Descriptor d = SymbolLookup.get().findDescriptor(Describable.class, describable.getSymbol());
            return d.getDisplayName();
        }
        return stepDescriptor.getDisplayName();
    }

    private String getStepName(@NonNull StepStartNode node, @NonNull String name) {
        StepDescriptor stepDescriptor = node.getDescriptor();
        if (stepDescriptor == null) {
            return name;
        }
        UninstantiatedDescribable describable = this.getUninstantiatedDescribableOrNull((FlowNode)node, stepDescriptor);
        if (describable != null) {
            Descriptor d = SymbolLookup.get().findDescriptor(Describable.class, describable.getSymbol());
            return d.getDisplayName();
        }
        return stepDescriptor.getDisplayName();
    }

    private String getStepType(@NonNull FlowNode node, @Nullable StepDescriptor stepDescriptor, @NonNull String type) {
        if (stepDescriptor == null) {
            return type;
        }
        UninstantiatedDescribable describable = this.getUninstantiatedDescribableOrNull(node, stepDescriptor);
        if (describable != null) {
            return describable.getSymbol();
        }
        return stepDescriptor.getFunctionName();
    }

    @Nullable
    private UninstantiatedDescribable getUninstantiatedDescribableOrNull(@NonNull FlowNode node, @Nullable StepDescriptor stepDescriptor) {
        Map arguments;
        if (stepDescriptor instanceof CoreStep.DescriptorImpl && (arguments = ArgumentsAction.getFilteredArguments((FlowNode)node)).get("delegate") instanceof UninstantiatedDescribable) {
            return (UninstantiatedDescribable)arguments.get("delegate");
        }
        return null;
    }

    @Override
    public void onStartParallelStepBranch(@NonNull StepStartNode stepStartNode, @NonNull String branchName, @NonNull WorkflowRun run) {
        try (Scope ignored = this.setupContext(run, (FlowNode)stepStartNode);){
            Verify.verifyNotNull((Object)ignored, (String)"%s - No span found for node %s", (Object[])new Object[]{run, stepStartNode});
            String stepType = this.getStepType((FlowNode)stepStartNode, stepStartNode.getDescriptor(), "branch");
            JenkinsOpenTelemetryPluginConfiguration.StepPlugin stepPlugin = JenkinsOpenTelemetryPluginConfiguration.get().findStepPluginOrDefault(stepType, stepStartNode);
            Span atomicStepSpan = this.getTracer().spanBuilder("Parallel branch: " + branchName).setParent(Context.current()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_TYPE, (Object)stepType).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_ID, (Object)stepStartNode.getId()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_NAME, (Object)branchName).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_PLUGIN_NAME, (Object)stepPlugin.getName()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_PLUGIN_VERSION, (Object)stepPlugin.getVersion()).startSpan();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - > parallel branch(" + branchName + ") - begin " + OtelUtils.toDebugString(atomicStepSpan));
            this.getTracerService().putSpan((Run<?, ?>)run, atomicStepSpan, (FlowNode)stepStartNode);
        }
    }

    @Override
    public void onEndParallelStepBranch(@NonNull StepEndNode node, @NonNull String branchName, FlowNode nextNode, @NonNull WorkflowRun run) {
        StepStartNode parallelStartNode = (StepStartNode)node.getStartNode();
        GenericStatus parallelStatus = StatusAndTiming.computeChunkStatus2((WorkflowRun)run, null, (FlowNode)parallelStartNode, (FlowNode)node, (FlowNode)nextNode);
        this.endCurrentSpan((FlowNode)node, run, parallelStatus);
    }

    private void endCurrentSpan(FlowNode node, WorkflowRun run, GenericStatus status) {
        try (Scope ignored = this.setupContext(run, node);){
            Verify.verifyNotNull((Object)ignored, (String)"%s - No span found for node %s", (Object[])new Object[]{run, node});
            Span span = this.getTracerService().getSpan((Run<?, ?>)run, node);
            ErrorAction errorAction = node.getError();
            if (errorAction == null) {
                if (status == null) {
                    status = GenericStatus.SUCCESS;
                }
                span.setStatus(StatusCode.OK);
            } else {
                Throwable throwable = errorAction.getError();
                if (throwable instanceof FlowInterruptedException) {
                    FlowInterruptedException interruptedException = (FlowInterruptedException)throwable;
                    List causesOfInterruption = interruptedException.getCauses();
                    if (status == null) {
                        status = GenericStatus.fromResult((Result)interruptedException.getResult());
                    }
                    List causeDescriptions = causesOfInterruption.stream().map(cause -> cause.getClass().getSimpleName() + ": " + cause.getShortDescription()).collect(Collectors.toList());
                    span.setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_INTERRUPTION_CAUSES, causeDescriptions);
                    boolean suppressSpanStatusCodeError = false;
                    for (CauseOfInterruption causeOfInterruption : causesOfInterruption) {
                        if (!this.statusUnsetCausesOfInterruption.contains(causeOfInterruption.getClass().getName())) continue;
                        suppressSpanStatusCodeError = true;
                        break;
                    }
                    if (suppressSpanStatusCodeError) {
                        span.setStatus(StatusCode.UNSET);
                    } else {
                        span.recordException(throwable);
                        String statusDescription = throwable.getClass().getSimpleName() + ": " + String.join((CharSequence)", ", causeDescriptions);
                        span.setStatus(StatusCode.ERROR, statusDescription);
                    }
                } else {
                    if (status == null) {
                        status = GenericStatus.FAILURE;
                    }
                    span.recordException(throwable);
                    span.setStatus(StatusCode.ERROR, throwable.getMessage());
                }
            }
            if (status != null) {
                status = StatusAndTiming.coerceStatusApi((GenericStatus)status, (StatusAndTiming.StatusApiVersion)StatusAndTiming.API_V2);
                span.setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_RESULT, (Object)status.toString());
            }
            span.end();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - < " + node.getDisplayFunctionName() + " - end " + OtelUtils.toDebugString(span));
            this.getTracerService().removePipelineStepSpanAndCloseAssociatedScopes(run, node, span);
        }
    }

    @Override
    public void onStartWithNewSpanStep(@NonNull StepStartNode stepStartNode, @NonNull WorkflowRun run) {
        try (Scope ignored = this.setupContext(run, (FlowNode)stepStartNode);){
            Verify.verifyNotNull((Object)ignored, (String)"%s - No span found for node %s", (Object[])new Object[]{run, stepStartNode});
            String stepName = this.getStepName(stepStartNode, "withNewSpan");
            String stepType = this.getStepType((FlowNode)stepStartNode, stepStartNode.getDescriptor(), "step");
            JenkinsOpenTelemetryPluginConfiguration.StepPlugin stepPlugin = JenkinsOpenTelemetryPluginConfiguration.get().findStepPluginOrDefault(stepType, stepStartNode);
            Map arguments = ArgumentsAction.getFilteredArguments((FlowNode)stepStartNode);
            String spanLabelArgument = arguments.getOrDefault("label", stepName);
            String spanLabel = Strings.isNullOrEmpty((String)spanLabelArgument) ? stepName : spanLabelArgument;
            SpanBuilder spanBuilder = this.getTracer().spanBuilder(spanLabel).setParent(Context.current()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_TYPE, (Object)stepType).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_ID, (Object)stepStartNode.getId()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_NAME, (Object)stepName).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_PLUGIN_NAME, (Object)stepPlugin.getName()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_PLUGIN_VERSION, (Object)stepPlugin.getVersion());
            try {
                List attributesObj = arguments.getOrDefault("attributes", Collections.emptyList());
                if (attributesObj instanceof List) {
                    List<SpanAttribute> attributes = attributesObj.stream().filter(item -> item instanceof SpanAttribute).map(item -> (SpanAttribute)item).toList();
                    for (SpanAttribute attribute : attributes) {
                        attributes.forEach(SpanAttribute::setDefaultType);
                        attribute.convert();
                        spanBuilder.setAttribute(attribute.getAttributeKey(), attribute.getConvertedValue());
                    }
                } else {
                    LOGGER.log(Level.WARNING, "Attributes are in an unexpected format: " + attributesObj.getClass().getSimpleName());
                }
            }
            catch (ClassCastException cce) {
                LOGGER.log(Level.WARNING, run.getFullDisplayName() + " failure to gather the attributes for the 'withNewSpan' step.", cce);
            }
            Span newSpan = spanBuilder.startSpan();
            LOGGER.log(Level.FINE, () -> run.getFullDisplayName() + " - > " + stepStartNode.getDisplayFunctionName() + " - begin " + OtelUtils.toDebugString(newSpan));
            this.getTracerService().putSpan((Run<?, ?>)run, newSpan, (FlowNode)stepStartNode);
        }
    }

    @Override
    public void onEndWithNewSpanStep(@NonNull StepEndNode node, FlowNode nextNode, @NonNull WorkflowRun run) {
        StepStartNode nodeStartNode = (StepStartNode)node.getStartNode();
        GenericStatus nodeStatus = StatusAndTiming.computeChunkStatus2((WorkflowRun)run, null, (FlowNode)nodeStartNode, (FlowNode)node, (FlowNode)nextNode);
        this.endCurrentSpan((FlowNode)node, run, nodeStatus);
    }

    public void notifyOfNewStep(@NonNull Step step, @NonNull StepContext context) {
        try {
            WorkflowRun run = (WorkflowRun)context.get(WorkflowRun.class);
            FlowNode node = (FlowNode)context.get(FlowNode.class);
            Computer computer = (Computer)context.get(Computer.class);
            if (computer == null || node == null || run == null) {
                LOGGER.log(Level.FINER, () -> "No run, flowNode or computer, skip. Run:" + String.valueOf(run) + ", flowNode: " + String.valueOf(node) + ", computer:" + String.valueOf(computer));
                return;
            }
            if (computer.getAction(OpenTelemetryAttributesAction.class) == null) {
                LOGGER.log(Level.WARNING, "Unexpected missing " + String.valueOf(OpenTelemetryAttributesAction.class) + " on " + String.valueOf(computer) + ", adding fallback");
                String hostName = computer.getHostName();
                OpenTelemetryAttributesAction openTelemetryAttributesAction = new OpenTelemetryAttributesAction();
                if (hostName != null) {
                    openTelemetryAttributesAction.getAttributes().put(HostIncubatingAttributes.HOST_NAME, hostName);
                }
                openTelemetryAttributesAction.getAttributes().put(AttributeKey.stringKey((String)ExtendedJenkinsAttributes.JENKINS_COMPUTER_NAME.getKey()), computer.getName());
                computer.addAction((Action)openTelemetryAttributesAction);
            }
            OpenTelemetryAttributesAction otelComputerAttributesAction = (OpenTelemetryAttributesAction)computer.getAction(OpenTelemetryAttributesAction.class);
            OpenTelemetryAttributesAction otelChildAttributesAction = (OpenTelemetryAttributesAction)context.get(OpenTelemetryAttributesAction.class);
            try (Scope ignored = this.setupContext(run, node);){
                Span currentSpan = Span.current();
                LOGGER.log(Level.FINE, () -> "Add resource attributes to span " + OtelUtils.toDebugString(currentSpan) + " - " + String.valueOf(otelComputerAttributesAction));
                this.setAttributesToSpan(currentSpan, otelComputerAttributesAction);
                LOGGER.log(Level.FINE, () -> "Add attributes to child span " + OtelUtils.toDebugString(currentSpan) + " - " + String.valueOf(otelChildAttributesAction));
                this.setAttributesToSpan(currentSpan, otelChildAttributesAction);
            }
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            LOGGER.log(Level.WARNING, "Exception processing " + String.valueOf(step) + " - " + String.valueOf(context), e);
        }
    }

    private void setAttributesToSpan(@NonNull Span span, OpenTelemetryAttributesAction openTelemetryAttributesAction) {
        if (openTelemetryAttributesAction == null) {
            return;
        }
        if (!openTelemetryAttributesAction.inheritanceAllowedSpanIdListIsEmpty() && !openTelemetryAttributesAction.isSpanIdAllowedToInheritAttributes(span.getSpanContext().getSpanId())) {
            return;
        }
        if (!openTelemetryAttributesAction.isNotYetAppliedToSpan(span.getSpanContext().getSpanId())) {
            return;
        }
        for (Map.Entry<AttributeKey<?>, Object> entry : openTelemetryAttributesAction.getAttributes().entrySet()) {
            AttributeKey<?> attributeKey = entry.getKey();
            Object value = Verify.verifyNotNull((Object)entry.getValue());
            span.setAttribute(attributeKey, value);
        }
    }

    @NonNull
    @MustBeClosed
    protected Scope setupContext(WorkflowRun run, @NonNull FlowNode node) {
        Verify.verifyNotNull((Object)run, (String)"%s No run found for node %s", (Object[])new Object[]{run, node});
        Span span = this.otelTraceService.getSpan((Run<?, ?>)run, node);
        return span.makeCurrent();
    }

    @Inject
    public final void setOpenTelemetryTracerService(@NonNull OtelTraceService otelTraceService) {
        this.otelTraceService = otelTraceService;
    }

    @NonNull
    public OtelTraceService getTracerService() {
        return this.otelTraceService;
    }

    @NonNull
    public Tracer getTracer() {
        return this.tracer;
    }

    public String toString() {
        return "TracingPipelineListener{}";
    }
}

